/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.config.db.util;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.mservice.center.common.CacheHelper;
import kd.bos.mservice.center.common.MserviceCenterConstants;
import kd.bos.mservice.center.common.MserviceCenterUtil;
import kd.bos.mservice.center.config.db.common.ConfigDTO;
import kd.bos.mservice.center.config.db.util.DBConfigCenterUtil;

public class ConfigCacheHelper {
    private static Map<String, byte[]> cacheConfigs = new ConcurrentHashMap<String, byte[]>(1000);
    private static final String CONFIGS = "configs";

    public static boolean checkVersion(String clusterName, String appName) {
        String key = DBConfigCenterUtil.getVersionKey(clusterName, appName);
        return CacheHelper.checkVersion(key);
    }

    public static List<ConfigDTO> getConfigsFromLocal(String clusterName, String appName) {
        byte[] results = cacheConfigs.get(DBConfigCenterUtil.getVersionKey(clusterName, appName));
        if (results != null && results.length > 0) {
            return (List)MserviceCenterUtil.decode(results);
        }
        return Collections.emptyList();
    }

    public static void updateLocalVersion(String clusterName, String appName, String version) {
        String versionKey = DBConfigCenterUtil.getVersionKey(clusterName, appName);
        CacheHelper.setLocalVersion(versionKey, version);
    }

    public static void updateLocalConfigsAndVersion(String clusterName, String appName, List<ConfigDTO> configDTOS) {
        String versionKey = ConfigCacheHelper.updateLocalConfigs(clusterName, appName, configDTOS);
        String version = CacheHelper.hgetVersion(versionKey);
        if (version != null && version.length() != 0) {
            CacheHelper.setLocalVersion(versionKey, version);
        }
    }

    public static String updateLocalConfigs(String clusterName, String appName, List<ConfigDTO> configDTOS) {
        String versionKey = DBConfigCenterUtil.getVersionKey(clusterName, appName);
        byte[] results = cacheConfigs.computeIfPresent(versionKey, (k, v) -> MserviceCenterUtil.encode(configDTOS));
        if (results == null) {
            cacheConfigs.computeIfAbsent(versionKey, v -> MserviceCenterUtil.encode(configDTOS));
        }
        return versionKey;
    }

    public static void updateDistributeConfig(String clusterName, String appName, List<ConfigDTO> configDTOS, String version) {
        HashMap<byte[], byte[]> values = new HashMap<byte[], byte[]>(2);
        String versionKey = DBConfigCenterUtil.getVersionKey(clusterName, appName);
        if (version == null || version.trim().length() == 0) {
            version = String.valueOf(new Date().getTime());
        }
        values.put(MserviceCenterUtil.encode("version"), MserviceCenterUtil.encode(version));
        values.put(MserviceCenterUtil.encode(CONFIGS), MserviceCenterUtil.encode(configDTOS));
        CacheHelper.hmset(versionKey, values, MserviceCenterConstants.CONFIG_TIME_OUT.intValue());
    }

    public static void updateConfigs(String clusterName, String appName, List<ConfigDTO> configDTOS) {
        ConfigCacheHelper.updateDistributeConfig(clusterName, appName, configDTOS, null);
        ConfigCacheHelper.updateLocalConfigsAndVersion(clusterName, appName, configDTOS);
    }

    public static String getLocalVersion(String clusterName, String appName) {
        return CacheHelper.getLocalVersion(DBConfigCenterUtil.getVersionKey(clusterName, appName));
    }

    public static List<ConfigDTO> hgetConfig(String clusterName, String appName) {
        return (List)CacheHelper.hget(DBConfigCenterUtil.getVersionKey(clusterName, appName), CONFIGS);
    }

    public static void clearConfig(String clusterName, String appName) {
        cacheConfigs.remove(DBConfigCenterUtil.getVersionKey(clusterName, appName));
    }
}

