/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.config.db.util;

import com.alibaba.fastjson.JSON;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.login.utils.DateUtils;
import kd.bos.mservice.center.common.DBCongfigTypeEnum;
import kd.bos.mservice.center.common.DBUtil;
import kd.bos.mservice.center.common.MserviceCenterConstants;
import kd.bos.mservice.center.common.ResultHandler;
import kd.bos.mservice.center.config.db.common.ConfigDTO;
import kd.bos.mservice.center.config.db.common.ConfigStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDBHelper {
    private static final Logger logger = LoggerFactory.getLogger(ConfigDBHelper.class);
    private static final String QUERY_CONFIG = "SELECT FID,FCONFIGAPPNAME,FKEY,FVALUE,FSTATUS,FCLUSTERNAME,FCREATETIME,FUPDATETIME,FCONFIGTYPE FROM T_CBS_CC_CONFIG WHERE ";
    private static final String SAVE_CONFIG = "INSERT INTO T_CBS_CC_CONFIG(FID,FCONFIGAPPNAME,FKEY,FVALUE,FSTATUS,FCLUSTERNAME,FCREATETIME,FUPDATETIME,FCONFIGTYPE) VALUES(?,?,?,?,?,?,now(),now(),?)";
    private static final String UPDATE_CONFIG = "UPDATE T_CBS_CC_CONFIG SET FVALUE = ?, FSTATUS = ?,FUPDATETIME = ? WHERE ";
    private static final String DELETE_CONFIG = "DELETE FROM T_CBS_CC_CONFIG WHERE ";
    private static final String QUERY_CONFIGNAMES = "select distinct FCONFIGAPPNAME from T_CBS_CC_CONFIG where FCLUSTERNAME = ?";

    public static List<ConfigDTO> queryNotDeletedConfig(String clusterName, String appName, String configType) {
        String sql = String.format("%s FCLUSTERNAME = ? and FCONFIGAPPNAME =? and FCONFIGTYPE = ? and FSTATUS !='0'", QUERY_CONFIG);
        return ConfigDBHelper.query(sql, new Object[]{clusterName, appName, configType});
    }

    public static List<ConfigDTO> queryNotDeletedConfig(String clusterName, String appName) {
        String sql = String.format("%s FCLUSTERNAME = ? and FCONFIGAPPNAME =? and FSTATUS !='0'", QUERY_CONFIG);
        return ConfigDBHelper.query(sql, new Object[]{clusterName, appName});
    }

    public static List<String> queryConfigNames(String clusterName) {
        try {
            List configNames = (List)DBUtil.query(DBCongfigTypeEnum.DBCONFIG, QUERY_CONFIGNAMES, new Object[]{clusterName}, new ResultHandler(){

                protected List<String> doHandle(ResultSet resultSet) throws SQLException {
                    ArrayList<String> tempConfigNames = new ArrayList<String>(2);
                    while (resultSet.next()) {
                        tempConfigNames.add(resultSet.getString("FCONFIGAPPNAME"));
                    }
                    return tempConfigNames;
                }
            });
            return configNames;
        }
        catch (Exception e) {
            if (e instanceof KDException) {
                throw (KDException)e;
            }
            throw new KDException(BosErrorCode.bOS, "queryConfigNames error", (Throwable)e);
        }
    }

    public static List<ConfigDTO> queryAllConfigs(String clusterName, String appName) {
        String sql = String.format("%s FCLUSTERNAME = ? and FCONFIGAPPNAME = ? order by FCLUSTERNAME ASC, FCONFIGAPPNAME ASC,FKEY ASC,FUPDATETIME ASC", QUERY_CONFIG);
        return ConfigDBHelper.query(sql, new Object[]{clusterName, appName});
    }

    public static void batchSaveOrUpdateConfig(String clusterName, String appName, Map<String, Object> properties, String configType) {
        if (properties == null || properties.size() == 0) {
            return;
        }
        ArrayList<Tuple<String, List<Object[]>>> sqlAndParams = new ArrayList<Tuple<String, List<Object[]>>>();
        Map<String, ConfigDTO> existsKeys = ConfigDBHelper.existsKeys(properties.keySet(), clusterName, appName);
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(properties.size());
        Date updateDate = new Date();
        if (existsKeys.size() > 0) {
            String sql = "UPDATE T_CBS_CC_CONFIG SET FVALUE = ?, FSTATUS = ?,FUPDATETIME = ? WHERE  FID = ? ";
            Iterator<Map.Entry<String, Object>> iterator = existsKeys.entrySet().iterator();
            while (iterator.hasNext()) {
                Object[] params = new Object[4];
                Map.Entry<String, Object> next = iterator.next();
                String key = next.getKey();
                ConfigDTO value = (ConfigDTO)next.getValue();
                if (!properties.get(key).toString().equals(value.getValue().toString())) {
                    params[0] = properties.get(key);
                    params[1] = Character.valueOf(ConfigStatusEnum.UPDATE.getCode());
                    params[2] = updateDate;
                    params[3] = value.getId();
                    updateParamList.add(params);
                }
                properties.remove(key);
            }
            Tuple updateTupe = Tuple.create((Object)sql, updateParamList);
            sqlAndParams.add(updateTupe);
        }
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>(properties.size());
        for (Map.Entry<String, Object> next : properties.entrySet()) {
            String key = next.getKey();
            Object value = next.getValue();
            Object[] params = new Object[]{ID.genLongId(), appName, key, value, Character.valueOf(ConfigStatusEnum.INSERT.getCode()), clusterName, configType};
            insertParamList.add(params);
        }
        if (insertParamList.size() > 0) {
            Tuple insertTuple = Tuple.create((Object)SAVE_CONFIG, insertParamList);
            sqlAndParams.add((Tuple<String, List<Object[]>>)insertTuple);
        }
        try {
            if (!DBUtil.executeMultiSqlBatch(DBCongfigTypeEnum.DBCONFIG, sqlAndParams)) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"batchSaveOrUpdateConfig fail"});
            }
        }
        catch (Throwable e) {
            if (!(e instanceof KDException)) {
                logger.error(ConfigDBHelper.class.getName() + ".batchSaveOrUpdateConfig:" + JSON.toJSONString(properties));
            }
            throw new KDException(BosErrorCode.bOS, "batchSaveOrUpdateConfig error", e);
        }
    }

    public static void batchDeleteConfig(String clusterName, String appName, Map<String, Object> properties, String configType) {
        if (properties == null || properties.size() == 0) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(properties.size());
        Date updateDate = new Date();
        String sql = "UPDATE T_CBS_CC_CONFIG SET FVALUE = ?, FSTATUS = ?,FUPDATETIME = ? WHERE  FCLUSTERNAME = ? AND FCONFIGAPPNAME = ? AND FKEY = ? AND FCONFIGTYPE = ?";
        Iterator<Map.Entry<String, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Object[] params = new Object[7];
            Map.Entry<String, Object> next = iterator.next();
            String key = next.getKey();
            params[0] = next.getValue();
            params[1] = Character.valueOf(ConfigStatusEnum.DELETED.getCode());
            params[2] = updateDate;
            params[3] = clusterName;
            params[4] = appName;
            params[5] = key;
            params[6] = configType;
            paramsList.add(params);
        }
        boolean result = ConfigDBHelper.executeBatch(sql, paramsList);
        if (!result) {
            logger.error(ConfigDBHelper.class.getName() + ".batchDeleteConfig:delete properties:" + JSON.toJSONString(paramsList));
            throw new KDException(BosErrorCode.bOS, new Object[]{"delete config error"});
        }
    }

    public static boolean deleteStatusOfDeletedConfig(String clusterName) {
        Date deleteTime = DateUtils.plusSecondsWithDate((Date)new Date(), (int)(-MserviceCenterConstants.CONFIG_DELETE_TIME.intValue()));
        String sql = String.format("%s fclustername = ? and FUPDATETIME < ? and fstatus = ?", DELETE_CONFIG);
        Object[] params = new Object[]{clusterName, deleteTime, Character.valueOf(ConfigStatusEnum.DELETED.getCode())};
        try {
            DBUtil.execute(DBCongfigTypeEnum.DBCONFIG, sql, params);
            return true;
        }
        catch (Throwable e) {
            logger.error("deleteStatusOfDeletedConfig error", e);
            return false;
        }
    }

    private static boolean executeBatch(String sql, List<Object[]> paramsList) {
        try {
            return DBUtil.executeBatch(DBCongfigTypeEnum.DBCONFIG, sql, paramsList);
        }
        catch (Throwable e) {
            if (!(e instanceof KDException)) {
                logger.error(ConfigDBHelper.class.getName() + ".executeBatch:" + JSON.toJSONString(paramsList));
            }
            throw new KDException(BosErrorCode.bOS, "save/update/delete properties error", e);
        }
    }

    private static Map<String, ConfigDTO> existsKeys(Set<String> keys, String clusterName, String appConfigName) {
        if (keys == null || keys.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        StringBuilder sqlBuilder = new StringBuilder("SELECT FID,FCONFIGAPPNAME,FKEY,FVALUE,FSTATUS,FCLUSTERNAME,FCREATETIME,FUPDATETIME,FCONFIGTYPE FROM T_CBS_CC_CONFIG WHERE  FCLUSTERNAME = ? and FCONFIGAPPNAME = ? and FKEY in (");
        Object[] params = new Object[keys.size() + 2];
        params[0] = clusterName;
        params[1] = appConfigName;
        int count = 2;
        for (String key : keys) {
            sqlBuilder.append("?,");
            params[count] = key;
            ++count;
        }
        String sql = sqlBuilder.substring(0, sqlBuilder.length() - 1) + ")";
        try {
            Map keyAndIds = (Map)DBUtil.query(DBCongfigTypeEnum.DBCONFIG, sql, params, new ResultHandler(){

                protected Map<String, ConfigDTO> doHandle(ResultSet resultSet) throws SQLException {
                    HashMap<String, ConfigDTO> tempKeyAndIds = new HashMap<String, ConfigDTO>(8);
                    while (resultSet.next()) {
                        String key = resultSet.getString("FKEY");
                        String value = resultSet.getString("FVALUE");
                        Timestamp fupdatetime = resultSet.getTimestamp("FUPDATETIME");
                        long id = resultSet.getLong("fid");
                        ConfigDTO configDTO = new ConfigDTO();
                        configDTO.setKey(key);
                        configDTO.setValue(value);
                        configDTO.setUpdateTime(fupdatetime);
                        configDTO.setId(id);
                        tempKeyAndIds.put(key, configDTO);
                    }
                    return tempKeyAndIds;
                }
            });
            return keyAndIds;
        }
        catch (Throwable e) {
            throw new KDException(BosErrorCode.bOS, "call existsKeys error,appName:" + appConfigName + ",clusterName" + clusterName, e);
        }
    }

    private static List<ConfigDTO> query(String sql, Object[] params) {
        try {
            List configs = (List)DBUtil.query(DBCongfigTypeEnum.DBCONFIG, sql, params, new ResultHandler(){

                protected List<ConfigDTO> doHandle(ResultSet resultSet) throws SQLException {
                    ArrayList<ConfigDTO> tempConfigs = new ArrayList<ConfigDTO>(8);
                    while (resultSet.next()) {
                        String key = resultSet.getString("FKEY");
                        String value = resultSet.getString("FVALUE");
                        Timestamp fupdatetime = resultSet.getTimestamp("FUPDATETIME");
                        String fstatus = resultSet.getString("FSTATUS");
                        String clusterName = resultSet.getString("FCLUSTERNAME");
                        String configAppName = resultSet.getString("FCONFIGAPPNAME");
                        String configType = resultSet.getString("FCONFIGTYPE");
                        ConfigDTO configDTO = new ConfigDTO(key, value, new Date(fupdatetime.getTime()), ConfigStatusEnum.valueOfCode(fstatus));
                        configDTO.setAppName(configAppName);
                        configDTO.setClusterName(clusterName);
                        configDTO.setConfigType(configType);
                        tempConfigs.add(configDTO);
                    }
                    return tempConfigs;
                }
            });
            return configs;
        }
        catch (Throwable e) {
            throw new KDException(BosErrorCode.bOS, "query error:" + JSON.toJSONString((Object)params), e);
        }
    }

    static {
        try {
            DBUtil.initDataSouce(DBCongfigTypeEnum.DBCONFIG, true, null);
        }
        catch (Throwable e) {
            logger.warn("init datasource error", e);
        }
    }
}

