/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.config.db.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.mservice.center.config.db.ConfigNotifier;
import kd.bos.mservice.center.config.db.common.ConfigDTO;
import kd.bos.mservice.center.config.db.common.ConfigStatusEnum;
import kd.bos.mservice.center.config.db.util.ConfigCacheHelper;

public class DBConfigCenterUtil {
    public static Map<String, Object> getKeyValues(List<ConfigDTO> configDTOS) {
        if (configDTOS == null || configDTOS.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> configs = new HashMap<String, Object>(configDTOS.size());
        configDTOS.stream().forEach(key -> configs.put(key.getKey(), key.getValue()));
        return configs;
    }

    public static Map<String, Long> getKeyUpdateTime(List<ConfigDTO> configDTOS) {
        if (configDTOS == null || configDTOS.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> configs = new HashMap<String, Long>(configDTOS.size());
        configDTOS.stream().forEach(key -> configs.put(key.getKey(), key.getUpdateTime().getTime()));
        return configs;
    }

    public static Map<String, ConfigDTO> toMap(List<ConfigDTO> configDTOS) {
        if (configDTOS == null || configDTOS.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, ConfigDTO> configs = new HashMap<String, ConfigDTO>(configDTOS.size());
        configDTOS.stream().forEach(key -> configs.put(key.getClusterName() + "_" + key.getAppName() + "_" + key.getKey(), (ConfigDTO)key));
        return configs;
    }

    public static void compareAndUpdate(List<ConfigDTO> dbOrDistribute, List<ConfigDTO> local, boolean fromDB, String clusterName, String appName) {
        Map<String, ConfigDTO> dbOrDistributeConfigMap = DBConfigCenterUtil.toMap(dbOrDistribute);
        Map<String, ConfigDTO> localCache = DBConfigCenterUtil.toMap(local);
        Iterator<Map.Entry<String, ConfigDTO>> iterator = dbOrDistributeConfigMap.entrySet().iterator();
        ArrayList<ConfigDTO> notDeletedConfig = new ArrayList<ConfigDTO>(8);
        boolean hasChange = false;
        if (local != null && local.size() > 0) {
            while (iterator.hasNext()) {
                Map.Entry<String, ConfigDTO> next = iterator.next();
                String key = next.getKey();
                ConfigDTO localDTO = localCache.get(key);
                ConfigDTO dbDTO = next.getValue();
                boolean delete = false;
                if (localDTO == null || dbDTO.getUpdateTime().compareTo(localDTO.getUpdateTime()) > 0) {
                    hasChange = true;
                    ConfigStatusEnum status = dbDTO.getStatus();
                    if (status == ConfigStatusEnum.INSERT) {
                        ConfigNotifier.notifyAdded(dbDTO.getKey(), (String)dbDTO.getValue());
                    } else if (status == ConfigStatusEnum.UPDATE) {
                        ConfigNotifier.notifyUpdated(dbDTO.getKey(), (String)dbDTO.getValue());
                    } else if (status == ConfigStatusEnum.DELETED) {
                        ConfigNotifier.notifyRemoved(dbDTO.getKey(), (String)dbDTO.getValue());
                        delete = true;
                    }
                }
                if (delete) continue;
                notDeletedConfig.add(dbDTO);
            }
            if (hasChange) {
                if (fromDB) {
                    ConfigCacheHelper.updateConfigs(clusterName, appName, notDeletedConfig);
                } else {
                    ConfigCacheHelper.updateLocalConfigsAndVersion(clusterName, appName, notDeletedConfig);
                }
            } else if (fromDB) {
                String version = ConfigCacheHelper.getLocalVersion(clusterName, appName);
                if (version == null || version.trim().length() == 0) {
                    version = String.valueOf(new Date().getTime());
                    ConfigCacheHelper.updateLocalVersion(clusterName, appName, version);
                }
                ConfigCacheHelper.updateDistributeConfig(clusterName, appName, notDeletedConfig, version);
            }
        } else {
            notDeletedConfig.addAll(dbOrDistribute);
            if (fromDB) {
                ConfigCacheHelper.updateConfigs(clusterName, appName, notDeletedConfig);
            } else {
                ConfigCacheHelper.updateLocalConfigsAndVersion(clusterName, appName, notDeletedConfig);
            }
        }
    }

    public static String getVersionKey(String clusterName, String appName) {
        return clusterName + "&###&" + appName;
    }
}

