/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.registry.db;

import com.alibaba.fastjson.JSON;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.center.common.MserviceCenterTableInit;
import kd.bos.mservice.center.common.MserviceCenterUtil;
import kd.bos.mservice.center.registry.db.DBRegistrant;
import kd.bos.mservice.center.registry.db.DBSubscriber;
import kd.bos.mservice.center.registry.db.task.DBRegistryTaskStarter;
import kd.bos.mservice.center.registry.db.util.RegistryCacheHelper;
import kd.bos.mservice.center.registry.db.util.RegistryDBHelper;
import kd.bos.mservice.center.registry.db.util.RegistryUtil;
import kd.bos.mservice.kregistrycenter.CallNotify;
import kd.bos.mservice.kregistrycenter.RegistrationInfo;
import kd.bos.mservice.kregistrycenter.spi.KRegistryCenter;

public class DBRegistryCenter
implements KRegistryCenter {
    private static final Log logger = LogFactory.getLog(DBRegistryCenter.class);

    public void doSaveRegister(RegistrationInfo registyInfo) {
        RegistryCacheHelper.clearDistributeCache(registyInfo.getClusterName(), registyInfo.getServiceKey());
        MserviceCenterTableInit.initDBRegistryTable();
        RegistryDBHelper.saveRegistyInfo(registyInfo);
        DBRegistryTaskStarter.startInstanceStatusMangeTask();
    }

    public void doRemoveRegister(RegistrationInfo registyInfo) {
        RegistryCacheHelper.clearDistributeCache(registyInfo.getClusterName(), registyInfo.getServiceKey());
        RegistryDBHelper.deleteRegistyInfo(registyInfo);
        if (MserviceCenterUtil.isLogEnable()) {
            logger.info(MserviceCenterUtil.toString(registyInfo));
        }
    }

    public void doAddSubscribeListener(RegistrationInfo registyInfo, CallNotify callNotify) {
        MserviceCenterTableInit.initDBRegistryTable();
        DBSubscriber.subscrib(registyInfo, callNotify);
        List<String> providerList = this.getProviderList(registyInfo, null);
        RegistryUtil.notify(registyInfo.categoryPath, providerList, callNotify);
        DBRegistryTaskStarter.startProviderListManageTask();
        if (MserviceCenterUtil.isLogEnable()) {
            logger.info("doAddSubscribeListener {},stack:{},localUrls:{}", new Object[]{MserviceCenterUtil.toString(registyInfo), RegistryUtil.getCallStack(null), JSON.toJSONString(providerList)});
        }
    }

    public void doRemoveSubscribeListener(RegistrationInfo registyInfo, CallNotify listener) {
        DBSubscriber.unSubscrib(registyInfo, listener);
        if (MserviceCenterUtil.isLogEnable()) {
            logger.info(MserviceCenterUtil.toString(registyInfo));
        }
    }

    public List<String> getProviderList(RegistrationInfo registyInfo, String path) {
        String versionKey = "";
        try {
            versionKey = registyInfo.getServiceKey() + "&###&" + registyInfo.getClusterName();
            if (RegistryCacheHelper.checkVersion(versionKey)) {
                List<String> localUrls = DBRegistrant.getRegistyInfo(versionKey);
                if (MserviceCenterUtil.isLogEnable()) {
                    logger.info("getProviderList {},path:{},stack:{},localUrls:{}", new Object[]{MserviceCenterUtil.toString(registyInfo), path, RegistryUtil.getCallStack(null), JSON.toJSONString(localUrls)});
                }
                return localUrls;
            }
            List<String> fullUrsl = RegistryCacheHelper.hgetUrls(versionKey);
            if (fullUrsl != null && fullUrsl.size() > 0) {
                if (MserviceCenterUtil.isLogEnable()) {
                    logger.info("getProviderList {},path:{},stack:{},localUrls:{}", new Object[]{MserviceCenterUtil.toString(registyInfo), path, RegistryUtil.getCallStack(null), JSON.toJSONString(fullUrsl)});
                }
                return fullUrsl;
            }
        }
        catch (Throwable e) {
            logger.error("getProviderList from cache error,versionKey:{},errorMsg:{},stack:\n{}", new Object[]{versionKey, e.getMessage(), RegistryUtil.getCallStack(e.getStackTrace())});
        }
        return RegistryUtil.getUrls(registyInfo.getServiceKey(), registyInfo.getClusterName());
    }
}

