/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.registry.db;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kd.bos.mservice.center.registry.db.util.RegistryUtil;
import kd.bos.mservice.kregistrycenter.CallNotify;
import kd.bos.mservice.kregistrycenter.RegistrationInfo;

public class DBSubscriber {
    private static Map<String, List<CallNotify>> subcribRegistyInfo = new ConcurrentHashMap<String, List<CallNotify>>(8);

    public static void subscrib(RegistrationInfo registyInfo, CallNotify callNotify) {
        List callNotifies = subcribRegistyInfo.computeIfAbsent(registyInfo.getServiceKey() + "&###&" + registyInfo.getClusterName(), value -> new CopyOnWriteArrayList());
        callNotifies.add(callNotify);
    }

    public static void unSubscrib(RegistrationInfo registyInfo, CallNotify callNotify) {
        List<CallNotify> callNotifies = subcribRegistyInfo.get(registyInfo.getServiceKey() + "&###&" + registyInfo.getClusterName());
        if (callNotifies == null || callNotifies.size() == 0) {
            return;
        }
        callNotifies.remove(callNotify);
    }

    public static void notifyChange(String subcribKey, List<String> fullUrls, Set<String> categoryPaths) {
        if (fullUrls == null || fullUrls.size() == 0) {
            return;
        }
        List<CallNotify> callNotifies = subcribRegistyInfo.get(subcribKey);
        if (callNotifies != null && callNotifies.size() > 0) {
            for (CallNotify callNotify : callNotifies) {
                if (categoryPaths != null && callNotifies.size() > 0) {
                    Iterator<String> iterator = categoryPaths.iterator();
                    while (iterator.hasNext()) {
                        RegistryUtil.notify(iterator.next(), fullUrls, callNotify);
                    }
                    continue;
                }
                callNotify.notifyChange(subcribKey.split("&###&")[0], fullUrls);
            }
        }
    }

    public static Set<String> getSubscribKey() {
        return subcribRegistyInfo.keySet();
    }
}

