/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.registry.db.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.center.common.CacheHelper;
import kd.bos.mservice.center.common.MserviceCenterConstants;
import kd.bos.mservice.center.common.MserviceCenterUtil;
import kd.bos.mservice.center.registry.db.util.RegistryUtil;

public class RegistryCacheHelper {
    private static final String URLS = "urls";
    private static final String PATHS = "paths";
    private static final Map<String, Boolean> hasInit = new ConcurrentHashMap<String, Boolean>(16);
    private static final Log logger = LogFactory.getLog(RegistryCacheHelper.class);

    public static boolean checkVersion(String versionKey) {
        return CacheHelper.checkVersion(versionKey);
    }

    public static void setLocalVersion(String versionKey, String version) {
        if (version != null && version.trim().length() > 0) {
            CacheHelper.setLocalVersion(versionKey, version);
        }
    }

    public static String getLocalVersion(String versionKey) {
        return CacheHelper.getLocalVersion(versionKey);
    }

    public static void hmsetVersionAndUrls(String versionKey, String version, List<String> urls, Set<String> categoryPaths) {
        HashMap<byte[], byte[]> versionAndUrls = new HashMap<byte[], byte[]>(2);
        versionAndUrls.put(MserviceCenterUtil.encode("version"), MserviceCenterUtil.encode(version));
        versionAndUrls.put(MserviceCenterUtil.encode(URLS), MserviceCenterUtil.encode(urls));
        versionAndUrls.put(MserviceCenterUtil.encode(PATHS), MserviceCenterUtil.encode(categoryPaths));
        CacheHelper.hmset(versionKey, versionAndUrls, MserviceCenterConstants.SERVICE_KEY_TIME_OUT.intValue());
    }

    public static String hgetVersion(String versionKey) {
        return CacheHelper.hgetVersion(versionKey);
    }

    public static List<String> hgetUrls(String versionKey) {
        List urls = (List)CacheHelper.hget(versionKey, URLS);
        if (urls == null || urls.size() == 0) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(new HashSet(urls));
    }

    public static Set<String> hgetPaths(String versionKey) {
        return (Set)CacheHelper.hget(versionKey, PATHS);
    }

    public static String genVersion(Collection<String> instanceIds, String clusterName, String serviceKey) {
        ArrayList<String> sortList = new ArrayList<String>(instanceIds);
        sortList.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        StringBuilder versionBuilder = new StringBuilder();
        versionBuilder.append(clusterName).append("#").append(serviceKey).append("#");
        for (String instanceId : sortList) {
            versionBuilder.append(instanceId).append("#");
        }
        return versionBuilder.toString();
    }

    public static void clearDistributeCache(String clusterName, String serviceKey) {
        try {
            String versionKey = serviceKey + "&###&" + clusterName;
            CacheHelper.remove(versionKey);
        }
        catch (Throwable e) {
            logger.error("clearDistributeCache error,clusterName: {},serviceKey:{},erroMsg:{},stack:\n{}", new Object[]{clusterName, serviceKey, e.getMessage(), RegistryUtil.getCallStack(e.getStackTrace())});
        }
    }

    public static boolean serviceHasInit(String serviceKey, String instanceId, String clusterName, String categoryPath) {
        Boolean aBoolean = hasInit.get(serviceKey + "_" + instanceId + "_" + clusterName + "_" + categoryPath);
        return aBoolean == null ? false : aBoolean;
    }

    public static void initService(String serviceKey, String instanceId, String clusterName, String categoryPath) {
        hasInit.put(serviceKey + "_" + instanceId + "_" + clusterName + "_" + categoryPath, true);
    }

    public static void clearService(String serviceKey, String instanceId, String clusterName, String categoryPath) {
        hasInit.remove(serviceKey + "_" + instanceId + "_" + clusterName + "_" + categoryPath);
    }
}

