/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.spi.define;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sun.reflect.ConstructorAccessor;
import sun.reflect.FieldAccessor;
import sun.reflect.ReflectionFactory;

public class EnumUtil {
    private static ReflectionFactory reflectionFactory = ReflectionFactory.getReflectionFactory();
    private static Map<Class<?>, Field> cachedValueFields = new ConcurrentHashMap(2);

    private static void setFailsafeFieldValue(Field field, Object target, Object value) throws NoSuchFieldException, IllegalAccessException {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        int modifiers = modifiersField.getInt(field);
        modifiersField.setInt(field, modifiers &= 0xFFFFFFEF);
        FieldAccessor fa = reflectionFactory.newFieldAccessor(field, false);
        fa.set(target, value);
    }

    private static void blankField(Class<?> enumClass, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        for (Field field : Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            AccessibleObject.setAccessible(new Field[]{field}, true);
            EnumUtil.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    private static void cleanEnumCache(Class<?> enumClass) throws NoSuchFieldException, IllegalAccessException {
        EnumUtil.blankField(enumClass, "enumConstantDirectory");
        EnumUtil.blankField(enumClass, "enumConstants");
    }

    private static ConstructorAccessor getConstructorAccessor(Class<?> enumClass, Class<?>[] additionalParameterTypes) throws NoSuchMethodException {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return reflectionFactory.newConstructorAccessor(enumClass.getDeclaredConstructor(parameterTypes));
    }

    private static Object makeEnum(Class<?> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object[] additionalValues) throws Exception {
        Object[] parms = new Object[additionalValues.length + 2];
        parms[0] = value;
        parms[1] = ordinal;
        System.arraycopy(additionalValues, 0, parms, 2, additionalValues.length);
        return enumClass.cast(EnumUtil.getConstructorAccessor(enumClass, additionalTypes).newInstance(parms));
    }

    public static <T extends Enum<?>> T addEnumIfAbsent(Class<T> enumType, String enumName, Class<?>[] additionalTypes, Object[] additionalValues) {
        if (!Enum.class.isAssignableFrom(enumType)) {
            throw new RuntimeException("class " + enumType + " is not an instance of Enum");
        }
        Field valuesField = cachedValueFields.computeIfAbsent(enumType, k -> {
            Field[] fields;
            for (Field field : fields = enumType.getDeclaredFields()) {
                if (!field.getName().contains("$VALUES")) continue;
                return field;
            }
            return null;
        });
        if (valuesField == null) {
            return null;
        }
        AccessibleObject.setAccessible(new Field[]{valuesField}, true);
        try {
            Enum[] previousValues;
            if (enumName.startsWith("JAVA.")) {
                enumName = enumName.substring(enumName.lastIndexOf(46) + 1);
            }
            for (Enum t : previousValues = (Enum[])valuesField.get(enumType)) {
                if (!enumName.equalsIgnoreCase(t.name())) continue;
                return (T)t;
            }
            ArrayList<Enum> values = new ArrayList<Enum>(Arrays.asList(previousValues));
            Enum newValue = (Enum)EnumUtil.makeEnum(enumType, enumName, values.size(), additionalTypes, additionalValues);
            values.add(newValue);
            EnumUtil.setFailsafeFieldValue(valuesField, null, values.toArray((Enum[])Array.newInstance(enumType, 0)));
            EnumUtil.cleanEnumCache(enumType);
            return (T)newValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

