/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.action.branch.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import kd.bos.context.KdtxRequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.common.constant.LocalTxLogStatus;
import kd.bos.kdtx.common.entity.TxBranchInfo;
import kd.bos.kdtx.common.exception.BranchCommitFailException;
import kd.bos.kdtx.common.param.BranchActionParam;
import kd.bos.kdtx.server.action.branch.BranchAction;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.dao.BranchDao;
import kd.bos.kdtx.server.factory.StateFactory;
import kd.bos.kdtx.server.service.impl.TxCommonService;
import kd.bos.kdtx.server.state.TcState;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class BranchCommitAction
implements BranchAction {
    private static final Log LOG = LogFactory.getLog(BranchCommitAction.class);
    private static final String GET_VALID_BRANCHID_SQL = "select fid from t_cbs_dtx_branch where fxid = ? and fseq = ? and  fstatus IN (1,2,7 )";

    @Override
    public void handle(BranchActionParam branchActionParam) throws Exception {
        TcState tcState = null;
        try {
            tcState = this.getStateObject();
            boolean updated = tcState.updateTx(GlobalTxStatus.COMMITTING, null);
            if (!updated) {
                throw new RuntimeException("BranchCommit err: update tx to committing status error");
            }
            tcState = StateFactory.getInstance(GlobalTxStatus.COMMITTING.getCode());
            String xid = KdtxRequestContext.get().getXid();
            if (StringUtils.isEmpty((String)xid)) {
                throw new RuntimeException("BranchCommit err: xid can not be null");
            }
            ObjectMapper objectMapper = new ObjectMapper();
            DtxParas tccParas = (DtxParas)objectMapper.readValue(branchActionParam.getParas(), DtxParas.class);
            Long branchFid = (Long)DB.query((DBRoute)DBRoute.base, (String)GET_VALID_BRANCHID_SQL, (Object[])new Object[]{xid, tccParas.getSeq()}, rs -> {
                if (rs.next()) {
                    return rs.getLong(1);
                }
                return null;
            });
            if (branchFid == null) {
                throw new RuntimeException("BranchCommit err: branch has not registry OR branch already commit success");
            }
            if (tccParas.getTotalBranch() == 0) {
                throw new RuntimeException("BranchCommit err: msg TotalBranch could not be  zero");
            }
            TxBranchInfo branchInfo = new TxBranchInfo();
            branchInfo.setId(branchFid.longValue());
            branchInfo.setBranchId(TcContext.get().getBranchId());
            branchInfo.setParas(branchActionParam.getParas());
            branchInfo.setSeq(branchActionParam.getSeq());
            branchInfo.setXid(xid);
            branchInfo.setParasBytes(branchActionParam.getParasBytes());
            tcState.commit(branchInfo);
            if (tccParas.getTotalBranch() == BranchDao.getCommitCount(xid)) {
                tcState.updateTx(GlobalTxStatus.COMMITTED, LocalTxLogStatus.PUBLISHED);
                tcState.deleteBusinessInfo();
                TxCommonService.callback(xid, true, false);
            }
            LOG.info("tx[{}] branchCommit success branchId:{}", (Object)xid, (Object)TcContext.get().getBranchId());
        }
        catch (Exception e) {
            if (tcState != null) {
                tcState.updateTx(GlobalTxStatus.COMMIT_FAILED, null);
            }
            LOG.error("tx branchCommit err -- branchId: " + TcContext.get().getBranchId(), (Throwable)e);
            throw new BranchCommitFailException(e.getMessage(), (Throwable)e);
        }
    }
}

