/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.action.branch.impl;

import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.common.exception.BranchRegisterException;
import kd.bos.kdtx.common.param.BranchActionParam;
import kd.bos.kdtx.server.action.branch.BranchAction;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.factory.StateFactory;
import kd.bos.kdtx.server.state.BaseTcState;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BranchRegisterAction
implements BranchAction {
    private static final Log LOG = LogFactory.getLog(BranchRegisterAction.class);

    @Override
    public void handle(BranchActionParam branchActionParam) throws Exception {
        if (TcContext.get().getBranchId() == null) {
            throw new BranchRegisterException("BranchRegisterAction err: rid can not be null -- xid: " + TcContext.get().getXid());
        }
        try {
            TcContext.getOrCreate().setParas(branchActionParam.getParas());
            TcContext.getOrCreate().setResource(branchActionParam.getResource());
            TcContext.getOrCreate().setContextBranchSeq(Long.toString(branchActionParam.getSeq()));
            TcContext.getOrCreate().setBizId(branchActionParam.getBizId() == null ? "" : branchActionParam.getBizId());
            TcContext.getOrCreate().setCascadeSeq(branchActionParam.getCascadeSeq());
            TcContext.getOrCreate().setParentBranchId(branchActionParam.getParentBranchId());
            TcContext.getOrCreate().setParasBytes(branchActionParam.getParasBytes());
            TcContext.getOrCreate().setLocalStatus(branchActionParam.getLocalStatus());
            BaseTcState baseTcState = StateFactory.getInstance(GlobalTxStatus.PREPARING.getCode());
            baseTcState.setTxType(this.getTxType());
            baseTcState.registerBranch();
        }
        catch (Exception e) {
            throw new BranchRegisterException("BranchRegisterAction err: some error happened. -- xid: " + TcContext.get().getXid() + " " + e.getMessage(), (Throwable)e);
        }
    }
}

