/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.action.tx.impl;

import kd.bos.context.KdtxRequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.common.constant.LocalTxLogStatus;
import kd.bos.kdtx.common.exception.NoDbRouteException;
import kd.bos.kdtx.common.exception.TxRollbackFailException;
import kd.bos.kdtx.common.localtx.LocalTxDbHelper;
import kd.bos.kdtx.server.action.tx.TxAction;
import kd.bos.kdtx.server.async.ActionAsyncServiceImpl;
import kd.bos.kdtx.server.async.AsyncServiceImpl;
import kd.bos.kdtx.server.config.TransCoordinatorConfig;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.service.impl.TxCommonService;
import kd.bos.kdtx.server.state.TcState;
import kd.bos.kdtx.server.state.adapter.UpdateTxAdapter;
import kd.bos.kdtx.server.state.impl.PreparingState;
import kd.bos.kdtx.server.state.impl.RollbackFailedState;
import kd.bos.kdtx.server.state.impl.RollbackingState;
import kd.bos.kdtx.server.tasks.homeless.CompensateStrategyScheduler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class RollbackTxAction
implements TxAction {
    private static final Log LOG = LogFactory.getLog(RollbackTxAction.class);
    private static final CompensateStrategyScheduler compensateStrategyScheduler = new CompensateStrategyScheduler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Object ... paras) throws Exception {
        block11: {
            TcState tcState = null;
            try {
                tcState = this.getStateObject();
                if (!(tcState instanceof PreparingState) && !(tcState instanceof RollbackFailedState) && !(tcState instanceof RollbackingState)) break block11;
                if (DtxType.TCC.getCode() != ((UpdateTxAdapter)tcState).getTxType() && this.isExistDtxLocalLog()) {
                    LOG.warn("\u6700\u7ec8\u4e00\u81f4\u6a21\u5f0f\u672c\u5730\u4e8b\u52a1\u8868\u5df2\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u80fd\u56de\u6eda");
                    return;
                }
                boolean updated = tcState.updateTx(GlobalTxStatus.ROLLBACKING, null);
                if (!updated && !(tcState instanceof RollbackingState)) {
                    return;
                }
                if (TcContext.get().isAsyncRollback()) {
                    String curDealXid = KdtxRequestContext.get().getXid();
                    try {
                        if (TransCoordinatorConfig.isStandardThreadPool()) {
                            LOG.info("This KDTX rollback is using the Java Standard ThreadPool.");
                            AsyncServiceImpl.executeAction(() -> this.rollback());
                        } else {
                            ActionAsyncServiceImpl.asyncExecuteAfterlCopyContext(() -> this.rollback());
                        }
                        break block11;
                    }
                    finally {
                        KdtxRequestContext.popDealedTx((String)curDealXid);
                    }
                }
                this.rollback();
            }
            catch (Exception e) {
                if (tcState != null) {
                    tcState.updateTx(GlobalTxStatus.ROLLBACK_FAILED, null);
                }
                LOG.error("tx rollback err -- xid: " + TcContext.get().getXid(), (Throwable)e);
                throw new TxRollbackFailException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollback() throws Exception {
        TcState tcState = null;
        String curDealXid = KdtxRequestContext.get().getXid();
        try {
            tcState = this.getStateObject();
            if (tcState instanceof RollbackingState) {
                tcState.rollback();
                tcState.updateTx(GlobalTxStatus.ROLLBACKED, LocalTxLogStatus.ROLLBACKED);
                tcState.deleteBusinessInfo();
                TxCommonService.callback(KdtxRequestContext.get().getXid(), false, true);
                compensateStrategyScheduler.autoCompensateComplete(TcContext.get().getXid());
                LOG.info("TccMonitorLog | " + TcContext.get().getXid() + " | tx rollback");
            }
        }
        catch (Exception e) {
            if (tcState != null) {
                tcState.updateTx(GlobalTxStatus.ROLLBACK_FAILED, null);
            }
            LOG.error("tx rollback err -- xid: " + TcContext.get().getXid(), (Throwable)e);
        }
        finally {
            KdtxRequestContext.popDealedTx((String)curDealXid);
        }
    }

    private boolean isExistDtxLocalLog() throws NoDbRouteException {
        String sql = "SELECT froutekey FROM t_cbs_dtx_transaction  WHERE fxid = ?";
        String dbRouteStr = (String)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{TcContext.get().getXid()}, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getString(1);
            }
            return null;
        });
        if (StringUtils.isEmpty((String)dbRouteStr)) {
            LOG.warn("dbRouteStr is empty.");
            return false;
        }
        return LocalTxDbHelper.localTxLogCount((DBRoute)DBRoute.of((String)dbRouteStr), (String)TcContext.get().getXid()) > 0L;
    }
}

