/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.async;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.KdtxRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.server.async.ActionAsyncServiceImpl;
import kd.bos.kdtx.server.async.ActionRunnable;
import kd.bos.kdtx.server.async.AsyncRunnable;
import kd.bos.kdtx.server.config.TransCoordinatorConfig;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.resource.balancer.Configs;
import kd.bos.resource.balancer.KDThreadPoolFactory;
import kd.bos.resource.balancer.allocator.threadpool.DiscardPolicyRejectedHandler;
import kd.bos.resource.balancer.allocator.threadpool.KDThreadPoolEnum;
import kd.bos.resource.balancer.allocator.threadpool.KDThreadPoolExecutor;
import kd.bos.thread.ThreadLifeCycleManager;

public class AsyncServiceImpl {
    private static final Log LOG = LogFactory.getLog(AsyncServiceImpl.class);
    public static final String ACTION_THREAD_POOL_NAME = "kdtx-commit-pool";
    public static final String TASK_THREAD_POOL_NAME = "kdtx-task-pool";
    private static ExecutorService actionExecutorService;
    private static ExecutorService taskExecutorService;
    private static KDThreadPoolExecutor resourceBalanceActionExecutor;
    private static KDThreadPoolExecutor resourceBalanceTaskExecutor;

    public static void executeAction(final AsyncHandler asyncHandler) {
        if (Configs.isKdtxResourceBalanceEnable()) {
            resourceBalanceActionExecutor.execute((Runnable)new AsyncRunnable(TcContext.get(), KdtxRequestContext.get(), RequestContext.get().getTraceId()){

                @Override
                protected void execute() {
                    try {
                        asyncHandler.handle();
                    }
                    catch (Exception e) {
                        ExceptionLogger.error(ActionAsyncServiceImpl.class, (String)"AsyncServiceImpl.executeAction: KdtxMonitorLog start async execute {} fail {}", (Object[])new Object[]{TcContext.get().getActionType().getName(), e.getMessage()});
                    }
                }
            });
            return;
        }
        actionExecutorService.execute(ThreadLifeCycleManager.wrapRunnable((Runnable)new AsyncRunnable(TcContext.get(), KdtxRequestContext.get(), RequestContext.get().getTraceId()){

            @Override
            protected void execute() {
                try {
                    asyncHandler.handle();
                }
                catch (Exception e) {
                    ExceptionLogger.error(ActionAsyncServiceImpl.class, (String)"AsyncServiceImpl.executeAction: KdtxMonitorLog start async execute {} fail {}", (Object[])new Object[]{TcContext.get().getActionType().getName(), e.getMessage()});
                }
            }
        }));
    }

    public static void executeTask(final AsyncHandler asyncHandler) {
        if (Configs.isKdtxResourceBalanceEnable()) {
            resourceBalanceTaskExecutor.execute((Runnable)new ActionRunnable(TcContext.get(), KdtxRequestContext.get(), RequestContext.get().getTraceId()){

                @Override
                protected void execute() {
                    try {
                        asyncHandler.handle();
                    }
                    catch (Exception e) {
                        ExceptionLogger.error(ActionAsyncServiceImpl.class, (String)"AsyncServiceImpl.executeTask: KdtxMonitorLog start async execute {} fail {}", (Object[])new Object[]{TcContext.get().getActionType().getName(), e.getMessage()});
                    }
                }
            });
            return;
        }
        taskExecutorService.execute(ThreadLifeCycleManager.wrapRunnable((Runnable)new ActionRunnable(TcContext.get(), KdtxRequestContext.get(), RequestContext.get().getTraceId()){

            @Override
            protected void execute() {
                try {
                    asyncHandler.handle();
                }
                catch (Exception e) {
                    ExceptionLogger.error(ActionAsyncServiceImpl.class, (String)"AsyncServiceImpl.executeTask: KdtxMonitorLog start async execute {} fail {}", (Object[])new Object[]{TcContext.get().getActionType().getName(), e.getMessage()});
                }
            }
        }));
    }

    static {
        try {
            int core = TransCoordinatorConfig.getCommitThreadCoreNum();
            int max = TransCoordinatorConfig.getCommitThreadMaxNum();
            if (core > max) {
                max = core;
            }
            actionExecutorService = new ThreadPoolExecutor(core, max, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(TransCoordinatorConfig.getCommitThreadQueueSize()), new AsyncThreadFactory(ACTION_THREAD_POOL_NAME), new ThreadPoolExecutor.DiscardPolicy());
            resourceBalanceActionExecutor = KDThreadPoolFactory.getOrCreate((String)KDThreadPoolEnum.KDTX_COMMIT.getResourceName(), (int)core, (int)max);
            resourceBalanceActionExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new DiscardPolicyRejectedHandler());
            core = TransCoordinatorConfig.getTaskThreadCoreNum();
            max = TransCoordinatorConfig.getTaskThreadMaxNum();
            if (core > max) {
                max = core;
            }
            taskExecutorService = new ThreadPoolExecutor(core, max, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(TransCoordinatorConfig.getTaskThreadQueueSize()), new AsyncThreadFactory(TASK_THREAD_POOL_NAME), new ThreadPoolExecutor.DiscardPolicy());
            resourceBalanceTaskExecutor = KDThreadPoolFactory.getOrCreate((String)KDThreadPoolEnum.KDTX_TASK.getResourceName(), (int)core, (int)max);
            resourceBalanceTaskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new DiscardPolicyRejectedHandler());
        }
        catch (Exception e) {
            LOG.error("\u5f02\u6b65\u5904\u7406\u63d0\u4ea4\u7684\u670d\u52a1\u6267\u884c\u9759\u6001\u4ee3\u7801\u5757\u5f02\u5e38", (Throwable)e);
        }
    }

    private static class AsyncThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        AsyncThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = name + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    public static interface AsyncHandler {
        public void handle() throws Exception;
    }
}

