/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.compensate;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bundle.Resources;
import kd.bos.context.KdtxRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.constant.CompensateStatus;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.common.constant.LocalTxLogStatus;
import kd.bos.kdtx.common.constant.RetryType;
import kd.bos.kdtx.common.constant.Status;
import kd.bos.kdtx.common.constant.TriggerType;
import kd.bos.kdtx.common.constant.TxListType;
import kd.bos.kdtx.common.entity.BusinessEntryInfo;
import kd.bos.kdtx.common.entity.TempContextInfo;
import kd.bos.kdtx.common.entity.TxBranchSceneInfo;
import kd.bos.kdtx.common.entity.TxBusinessInfo;
import kd.bos.kdtx.common.entity.TxInfo;
import kd.bos.kdtx.common.entity.TxLogInfo;
import kd.bos.kdtx.common.entity.TxRetryInfo;
import kd.bos.kdtx.common.entity.TxSceneInfo;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.localtx.LocalTxDbHelper;
import kd.bos.kdtx.common.localtx.LocalTxLog;
import kd.bos.kdtx.common.log.DBLogger;
import kd.bos.kdtx.common.param.BusinessParam;
import kd.bos.kdtx.common.param.ListTxInfoParam;
import kd.bos.kdtx.common.param.ListTxLogParam;
import kd.bos.kdtx.common.response.CompensateResponse;
import kd.bos.kdtx.common.service.SimpleAction;
import kd.bos.kdtx.common.util.EnumUtils;
import kd.bos.kdtx.common.util.JsonUtils;
import kd.bos.kdtx.server.config.TransCoordinatorConfig;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.service.impl.TransCoordinatorServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class CompensateService {
    private static final Log LOG = LogFactory.getLog(CompensateService.class);
    private static CompensateService compensateService = new CompensateService();
    private static final String FACTROY = "kd.bos.kdtx.sdk.service.SimpleActionFactory";
    private static final String GET_ACTION_INSTANCE = "getActionInstance";
    private static final int REPAIRED_STATUS = 10;
    private static final int UNFINISHED_STATUS = 11;
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String Q_MCP = "SELECT FID,FCODE,FNAME,FADRESS,FSCENES_TX_ID FROM t_cbs_dtx_MCP CP WHERE FSCENES_TX_ID =? ";

    private CompensateService() {
    }

    public static CompensateService getCompensateService() {
        return compensateService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompensateResponse prepareTimeoutRollback(List<String> xids) {
        block19: {
            try {
                TcContext.getOrCreate().setAsyncRollback(true);
                if (xids == null) break block19;
                ArrayList<CompensateResponse.TxInfo> wrongTxList = new ArrayList<CompensateResponse.TxInfo>();
                ArrayList<CompensateResponse.TxInfo> errTxList = new ArrayList<CompensateResponse.TxInfo>();
                for (String xid : xids) {
                    ActionType actionType = null;
                    TxInfo txInfo = this.queryTx(xid);
                    if (txInfo == null) {
                        throw new KdtxException("can not find tx -- xid: " + xid);
                    }
                    try {
                        TransCoordinatorServiceImpl transCoordinatorService = new TransCoordinatorServiceImpl();
                        if (GlobalTxStatus.PREPARING == txInfo.getFtransStatus()) {
                            actionType = ActionType.TX_ROLLBACK;
                        }
                        if (actionType != null) {
                            transCoordinatorService.proxyHandleTx(actionType, null);
                            continue;
                        }
                        wrongTxList.add(new CompensateResponse.TxInfo(xid, txInfo.getTxName()));
                    }
                    catch (Exception e) {
                        if (!(e instanceof KdtxException)) {
                            LOG.error("prepareTimeoutRollback err", (Throwable)e);
                            throw new KdtxException("prepareTimeoutRollback err", (Throwable)e);
                        }
                        errTxList.add(new CompensateResponse.TxInfo(xid, txInfo.getTxName()));
                        LOG.warn("handle compensate err", (Throwable)e);
                    }
                    finally {
                        if (actionType == null) continue;
                        try {
                            this.insertOrUpdateRetryLog(xid, RetryType.PREPARE_TIMEOUT, -1L);
                        }
                        catch (Exception e) {
                            LOG.error("insertOrUpdateRetryLog err -- xid: " + xid, (Throwable)e);
                        }
                    }
                }
                CompensateResponse resp = new CompensateResponse();
                resp.setWrongTxList(wrongTxList);
                resp.setErrTxList(errTxList);
                CompensateResponse compensateResponse = resp;
                return compensateResponse;
            }
            finally {
                TcContext.remove();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public CompensateResponse manuallyRetry(List<Map<String, String>> infos) {
        block25: {
            try {
                if (infos == null) break block25;
                ArrayList<CompensateResponse.TxInfo> wrongTxList = new ArrayList<CompensateResponse.TxInfo>();
                ArrayList<CompensateResponse.TxInfo> errTxList = new ArrayList<CompensateResponse.TxInfo>();
                for (Map<String, String> info : infos) {
                    RetryType retryType;
                    TxInfo txInfo;
                    ActionType actionType;
                    long seq;
                    String xid;
                    block26: {
                        xid = info.get("xid");
                        seq = Long.parseLong(info.get("seq"));
                        boolean isSync = Boolean.parseBoolean(info.get("sync"));
                        TcContext.getOrCreate().setAsyncCommit(!isSync);
                        TcContext.getOrCreate().setAsyncRollback(!isSync);
                        actionType = null;
                        txInfo = this.queryTx(xid);
                        if (txInfo == null) {
                            throw new KdtxException("can not find tx -- xid: " + xid);
                        }
                        retryType = null;
                        if (seq == -1L || txInfo.getFtxType() != DtxType.SIMPLEEC.getCode() || this.isCompensateSuccess(xid, seq)) break block26;
                        actionType = ActionType.TX_COMMIT;
                        retryType = RetryType.COMMIT_RETRY;
                        this.resend(txInfo, seq, true);
                        if (actionType == null) break;
                        try {
                            this.insertOrUpdateRetryLog(xid, retryType, seq);
                        }
                        catch (Exception e) {
                            LOG.error("insertOrUpdateRetryLog err -- xid: " + xid, (Throwable)e);
                        }
                        break;
                    }
                    TransCoordinatorServiceImpl transCoordinatorService = new TransCoordinatorServiceImpl();
                    TcContext.getOrCreate().setXid(xid);
                    TcContext.getOrCreate().setManuallyRetry(true);
                    KdtxRequestContext.get().setXid(xid);
                    KdtxRequestContext.get().pushXidStack(xid);
                    if (GlobalTxStatus.COMMIT_FAILED == txInfo.getFtransStatus() || GlobalTxStatus.COMMITTING == txInfo.getFtransStatus()) {
                        actionType = ActionType.TX_COMMIT;
                        retryType = RetryType.COMMIT_RETRY;
                    }
                    if (GlobalTxStatus.ROLLBACK_FAILED == txInfo.getFtransStatus() || GlobalTxStatus.ROLLBACKING == txInfo.getFtransStatus()) {
                        actionType = ActionType.TX_ROLLBACK;
                        retryType = RetryType.ROLLBACK_RETRY;
                    }
                    if (GlobalTxStatus.PREPARING == txInfo.getFtransStatus()) {
                        actionType = ActionType.TX_ROLLBACK;
                        retryType = RetryType.PREPARE_TIMEOUT;
                    }
                    if (actionType != null) {
                        transCoordinatorService.proxyHandleTx(actionType, null);
                    } else {
                        wrongTxList.add(new CompensateResponse.TxInfo(xid, txInfo.getTxName()));
                    }
                    if (actionType == null) continue;
                    try {
                        this.insertOrUpdateRetryLog(xid, retryType, seq);
                    }
                    catch (Exception e) {
                        LOG.error("insertOrUpdateRetryLog err -- xid: " + xid, (Throwable)e);
                    }
                    continue;
                    catch (Exception e) {
                        try {
                            if (!(e instanceof KdtxException)) {
                                LOG.error("manuallyRetry err", (Throwable)e);
                                throw new KdtxException("manuallyRetry err", (Throwable)e);
                            }
                            errTxList.add(new CompensateResponse.TxInfo(xid, txInfo.getTxName()));
                            LOG.warn("manuallyRetry err", (Throwable)e);
                            if (actionType == null) continue;
                        }
                        catch (Throwable throwable) {
                            if (actionType != null) {
                                try {
                                    this.insertOrUpdateRetryLog(xid, retryType, seq);
                                }
                                catch (Exception e2) {
                                    LOG.error("insertOrUpdateRetryLog err -- xid: " + xid, (Throwable)e2);
                                }
                            }
                            throw throwable;
                        }
                        try {
                            this.insertOrUpdateRetryLog(xid, retryType, seq);
                        }
                        catch (Exception e3) {
                            LOG.error("insertOrUpdateRetryLog err -- xid: " + xid, (Throwable)e3);
                        }
                    }
                }
                CompensateResponse resp = new CompensateResponse();
                resp.setWrongTxList(wrongTxList);
                resp.setErrTxList(errTxList);
                CompensateResponse compensateResponse = resp;
                return compensateResponse;
            }
            finally {
                TcContext.remove();
            }
        }
        return null;
    }

    private boolean isCompensateSuccess(String xid, long seq) {
        String sql = "select fstatus from t_cbs_dtx_retry_stat where  fxid=? and fseq=? and ftrigger_type=2";
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{xid, seq}, rs -> {
            int status = 0;
            if (rs.next()) {
                status = rs.getInt(1);
            }
            return status == CompensateStatus.COMPENSATE_SUCCESS.getCode();
        });
    }

    public TxSceneInfo getTxSceneInfoById(String id) {
        List<TxSceneInfo> txSceneInfoList = this.queryAndSetTxSceneInfo(id);
        if (txSceneInfoList == null || txSceneInfoList.isEmpty()) {
            return null;
        }
        return txSceneInfoList.get(0);
    }

    public List<TxRetryInfo> listTxInfoDataSet(ListTxInfoParam listTxInfoParam) {
        String splitPageSql = "";
        if (listTxInfoParam.isSplitPage()) {
            splitPageSql = "TOP " + listTxInfoParam.getLimit() + "," + listTxInfoParam.getStart() + " ";
        }
        String sql = "SELECT " + splitPageSql + "trs.fxid as xid, trs.ftx_type as tx_type, trs.fstatus as status, trs.fcreate_time as tx_created_time, trs.fscenes_tx_id as tx_sceneid, ISNULL(rs.fcommit_retry_count, 0) as commit_retry_count, ISNULL(rs.frollback_retry_count, 0) as rollback_retry_count, rs.ftrigger_type as trigger_type, ts.fname as tx_desc, trs.fmodel as model, trs.fparent_xid as parent_xid, trs.fsecondstatus as secondstatus, ISNULL(rs.fseq, -1) as fseq, rs.fstatus as compensate_status  FROM t_cbs_dtx_transaction AS trs LEFT JOIN t_cbs_dtx_retry_stat AS rs ON trs.fxid = rs.fxid LEFT JOIN t_cbs_dtx_tx_scenes AS ts ON ts.fid = trs.fscenes_tx_id  %s ORDER BY trs.fcreate_time DESC, trs.fid DESC";
        String xidParam = listTxInfoParam.getXid();
        long sceneIdParam = Long.parseLong(listTxInfoParam.getStrTxSceneId());
        int statusParam = listTxInfoParam.getStatus();
        int secondStatusParam = listTxInfoParam.getSecondStatus();
        String createdTimeFromParam = listTxInfoParam.getTxCreatedTimeFrom();
        String createdTimeToParam = listTxInfoParam.getTxCreatedTimeTo();
        TxListType listTypeParam = listTxInfoParam.getTxListType();
        DtxType dtxTypeParam = listTxInfoParam.getDtxType();
        int txTypeParam = listTxInfoParam.getTxType();
        String bizId = listTxInfoParam.getBizId();
        Map<String, Object> whereSqlAndParams = this.getWhereSqlBy(xidParam, sceneIdParam, statusParam, secondStatusParam, createdTimeFromParam, createdTimeToParam, listTypeParam, dtxTypeParam, txTypeParam, bizId);
        sql = String.format(sql, whereSqlAndParams.get("sql"));
        Object[] params = (Object[])whereSqlAndParams.get("params");
        HashMap map = new HashMap();
        DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
            while (rs.next()) {
                String xid = rs.getString("xid");
                int status = rs.getInt("status");
                Timestamp txCreatedTime = rs.getTimestamp("tx_created_time");
                long txSceneId = rs.getLong("tx_sceneid");
                int commitRetryCount = rs.getInt("commit_retry_count");
                int rollbackRetryCount = rs.getInt("rollback_retry_count");
                int triggerType = rs.getInt("trigger_type");
                String txDesc = rs.getString("tx_desc");
                int txType = rs.getInt("tx_type");
                String model = rs.getString("model");
                String parentXid = rs.getString("parent_xid");
                int secondStatus = rs.getInt("secondstatus");
                int secondBranchSeq = rs.getInt("fseq");
                int compensateStatus = rs.getInt("compensate_status");
                TxRetryInfo txRetryInfo = (TxRetryInfo)map.get(xid + "_" + secondBranchSeq);
                if (txRetryInfo == null) {
                    txRetryInfo = new TxRetryInfo();
                    txRetryInfo.setXid(xid);
                    txRetryInfo.setTxCreatedTime((Date)txCreatedTime);
                    txRetryInfo.setTxSceneId(txSceneId);
                    this.setRetryCount(commitRetryCount, rollbackRetryCount, triggerType, txRetryInfo);
                    txRetryInfo.setStatus(status);
                    txRetryInfo.setSecondStatus(txType != DtxType.SIMPLEEC.getCode() ? -1 : secondStatus);
                    txRetryInfo.setTxDesc(txDesc);
                    txRetryInfo.setTxType(txType);
                    txRetryInfo.setMode(StringUtils.isEmpty((String)model) ? "RPC" : model);
                    txRetryInfo.setParentXid(parentXid);
                    txRetryInfo.setSecondBranchSeq(secondBranchSeq);
                    txRetryInfo.setCompensateStatus(secondBranchSeq == -1 ? CompensateStatus.NOT_NEED_SHOW.getCode() : compensateStatus);
                    map.put(xid + "_" + secondBranchSeq, txRetryInfo);
                    continue;
                }
                this.setRetryCount(commitRetryCount, rollbackRetryCount, triggerType, txRetryInfo);
            }
            return null;
        });
        List<TxRetryInfo> ret = map.values().stream().sorted(Comparator.comparing(TxRetryInfo::getTxCreatedTime).reversed()).collect(Collectors.toList());
        return ret;
    }

    private String getTxTypeName(int txType) {
        if (txType == 1) {
            return ResManager.loadKDString((String)"\u6700\u7ec8\u4e00\u81f4", (String)"tcc_tc_0", (String)"bos-kdtx-server", (Object[])new Object[0]);
        }
        if (txType == 0) {
            return "tcc";
        }
        if (txType == 2) {
            return ResManager.loadKDString((String)"\u53ef\u9760\u6d88\u606f", (String)"tcc_tc_1", (String)"bos-kdtx-server", (Object[])new Object[0]);
        }
        return "unknown";
    }

    public List<TxLogInfo> listTxLog(ListTxLogParam listTxLogParam) {
        String splitPageSql = "";
        if (listTxLogParam.isSplitPage()) {
            splitPageSql = "TOP " + listTxLogParam.getLimit() + "," + listTxLogParam.getStart() + " ";
        }
        Map<String, Object> whereSqlAndParams = this.getLogWhereSql(listTxLogParam.getXid(), listTxLogParam.getTxSceneId(), listTxLogParam.getStartTimeFrom(), listTxLogParam.getStartTimeTo(), listTxLogParam.getBranchXid(), listTxLogParam.getBranchDesc(), listTxLogParam.getBranchClazz(), listTxLogParam.getActionType(), listTxLogParam.getTriggerType(), listTxLogParam.getResult());
        String whereSql = (String)whereSqlAndParams.get("sql");
        Object[] params = (Object[])whereSqlAndParams.get("params");
        String sql = "SELECT " + splitPageSql + "tl.fxid as xid, trs.ftx_type as tx_type, ts.fname as tx_desc, tl.faction_type as action_type, tl.ftrigger_type as trigger_type, tl.fresult as result, tl.fbranch_id as branch_xid, tsb.fname as branch_desc, tb.fresource as branch_clazz, tl.fremark as remark, tl.fcreate_time as start_time, tl.fupdate_time as end_time, tl.ftraceid as traceid FROM t_cbs_dtx_logs tl LEFT JOIN t_cbs_dtx_transaction AS trs ON trs.fxid = tl.fxid LEFT JOIN t_cbs_dtx_tx_scenes AS ts ON ts.fid = trs.fscenes_tx_id LEFT JOIN t_cbs_dtx_branch AS tb ON tb.fbranch_id = tl.fbranch_id LEFT JOIN t_cbs_dtx_branch_scenes AS tsb ON tsb.fentryid = tb.fscenes_branch_id " + whereSql + "ORDER BY tl.fcreate_time desc, tl.fid desc";
        ArrayList<TxLogInfo> txLogInfos = new ArrayList<TxLogInfo>();
        DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
            while (rs.next()) {
                TxLogInfo txLogInfo = new TxLogInfo();
                txLogInfo.setXid(rs.getString("xid"));
                txLogInfo.setTxType(rs.getInt("tx_type"));
                txLogInfo.setTxDesc(rs.getString("tx_desc"));
                int actionType = rs.getInt("action_type");
                txLogInfo.setActionType(actionType);
                txLogInfo.setActionTypeDesc(ActionType.get((int)actionType).getName());
                txLogInfo.setTriggerType(rs.getString("trigger_type"));
                txLogInfo.setResult(rs.getInt("result"));
                txLogInfo.setBranchXid(rs.getString("branch_xid"));
                txLogInfo.setBranchDesc(rs.getString("branch_desc"));
                txLogInfo.setBranchClazz(rs.getString("branch_clazz"));
                txLogInfo.setRemark(rs.getString("remark"));
                txLogInfo.setTraceId(rs.getString("traceid"));
                txLogInfo.setCreateTime((Date)rs.getTimestamp("start_time"));
                txLogInfo.setUpdatedTime((Date)rs.getTimestamp("end_time"));
                txLogInfos.add(txLogInfo);
            }
            return null;
        });
        return txLogInfos;
    }

    public List<TxSceneInfo> queryTxSceneInfo() {
        return this.queryAndSetTxSceneInfo(null);
    }

    public void insertOrUpdateTxSceneInfo(TxSceneInfo txSceneInfo) {
        List branchSceneInfoList = txSceneInfo.getBranchSceneInfoList();
        if (StringUtils.isNotEmpty((String)txSceneInfo.getId())) {
            String txSceneInfoUpdateSql = "update t_cbs_dtx_tx_scenes set fname= ?, fapp = ?, fremark = ?, fupdate_time = now() where fid = ?";
            Object[] txSceneUpdateParams = new Object[]{txSceneInfo.getName(), txSceneInfo.getApp(), txSceneInfo.getRemark(), Long.parseLong(txSceneInfo.getId())};
            DB.update((DBRoute)DBRoute.base, (String)txSceneInfoUpdateSql, (Object[])txSceneUpdateParams);
            String txBranchSceneDelSql = "delete from t_cbs_dtx_branch_scenes where fid=?";
            Object[] delTxBranchSceneParam = new Object[]{Long.parseLong(txSceneInfo.getId())};
            DB.execute((DBRoute)DBRoute.base, (String)txBranchSceneDelSql, (Object[])delTxBranchSceneParam);
            String txBranchSceneInsertSql = "insert into t_cbs_dtx_branch_scenes(fid, fentryid, fcode, fname, fremark, fcreate_time) values (?,?,?,?,?,now())";
            if (branchSceneInfoList != null) {
                ArrayList<Object[]> params = new ArrayList<Object[]>(branchSceneInfoList.size());
                for (TxBranchSceneInfo branchSceneInfo : branchSceneInfoList) {
                    Object[] txBranchSceneInsertParams = new Object[]{Long.parseLong(txSceneInfo.getId()), ID.genLongId(), branchSceneInfo.getCode(), branchSceneInfo.getName(), branchSceneInfo.getRemark()};
                    params.add(txBranchSceneInsertParams);
                }
                DB.executeBatch((DBRoute)DBRoute.base, (String)txBranchSceneInsertSql, params);
            }
        } else {
            String txSceneInsertSql = "insert into t_cbs_dtx_tx_scenes(fid, fcode, fname, fapp, fremark, fcreate_time) values (?,?,?,?,?,now())";
            long txSceneId = ID.genLongId();
            Object[] txSceneInsertParams = new Object[]{txSceneId, txSceneInfo.getCode(), txSceneInfo.getName(), txSceneInfo.getApp(), txSceneInfo.getRemark()};
            DB.execute((DBRoute)DBRoute.base, (String)txSceneInsertSql, (Object[])txSceneInsertParams);
            String txBranchSceneInsertSql = "insert into t_cbs_dtx_branch_scenes(fid, fentryid, fcode, fname,fremark, fcreate_time) values (?,?,?,?,?,now())";
            if (branchSceneInfoList != null) {
                ArrayList<Object[]> params = new ArrayList<Object[]>(branchSceneInfoList.size());
                for (TxBranchSceneInfo branchSceneInfo : branchSceneInfoList) {
                    Object[] txBranchSceneInsertParams = new Object[]{txSceneId, ID.genLongId(), branchSceneInfo.getCode(), branchSceneInfo.getName(), branchSceneInfo.getRemark()};
                    params.add(txBranchSceneInsertParams);
                }
                DB.executeBatch((DBRoute)DBRoute.base, (String)txBranchSceneInsertSql, params);
            }
        }
    }

    private void insertOrUpdateRetryLog(String xid, RetryType retryType, long seq) throws Exception {
        Object[] params;
        String querySql = "SELECT COUNT(1) FROM t_cbs_dtx_retry_stat WHERE fxid = ? and ftrigger_type = 2 " + (seq == -1L ? "" : "and fseq=" + seq);
        int count = (Integer)DB.query((DBRoute)DBRoute.base, (String)querySql, (Object[])(params = new Object[]{xid}), rs -> {
            rs.next();
            return rs.getInt(1);
        });
        if (count == 0) {
            this.insertRetryLog(xid, retryType);
        } else {
            this.updateRetryLog(xid, retryType, seq);
        }
    }

    private void insertRetryLog(String xid, RetryType retryType) throws Exception {
        String sql = "INSERT INTO t_cbs_dtx_retry_stat(fid, fxid, ftrigger_type, fcommit_retry_count, frollback_retry_count, fcreate_time, fupdate_time) VALUES(?,?,?,?,?,now(),now())";
        boolean ret = false;
        if (RetryType.COMMIT_RETRY == retryType) {
            Object[] params = new Object[]{ID.genLongId(), xid, 2, 1, 0};
            ret = DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
        } else if (RetryType.ROLLBACK_RETRY == retryType) {
            Object[] params = new Object[]{ID.genLongId(), xid, 2, 0, 1};
            ret = DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
        }
        if (!ret) {
            LOG.error("insertRetryLog error xid: " + xid);
            throw new KdtxException("insertRetryLog error");
        }
    }

    private void updateRetryLog(String xid, RetryType retryType, long seq) throws Exception {
        Object[] params;
        String sql;
        boolean ret;
        String retryProp = "";
        if (RetryType.COMMIT_RETRY == retryType) {
            retryProp = "fcommit_retry_count";
        }
        if (RetryType.ROLLBACK_RETRY == retryType) {
            retryProp = "frollback_retry_count";
        }
        if (!(ret = DB.execute((DBRoute)DBRoute.base, (String)(sql = "UPDATE t_cbs_dtx_retry_stat SET " + retryProp + " = " + retryProp + " + 1, fupdate_time = now() WHERE fxid = ? AND ftrigger_type = 2" + (seq == -1L ? "" : "and fseq=" + seq)), (Object[])(params = new Object[]{xid})))) {
            LOG.error("updateRetryLog error xid: " + xid + " retryType type: " + retryType.getName());
            throw new KdtxException("updateRetryLog error.");
        }
    }

    private TxInfo queryTx(String xid) {
        String sql = "SELECT trs.fstatus, tst.fname,trs.ftx_type,trs.fserializer ,trs.froutekey, trs.fcontext   FROM t_cbs_dtx_transaction trs LEFT JOIN t_cbs_dtx_tx_scenes tst on tst.fid = trs.fscenes_tx_id WHERE trs.fxid = ?";
        Object[] params = new Object[]{xid};
        return (TxInfo)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
            boolean flag = rs.next();
            if (flag) {
                TxInfo txInfo = new TxInfo();
                txInfo.setFxid(xid);
                int dbStatus = rs.getInt(1);
                if (GlobalTxStatus.get((int)dbStatus) != null) {
                    txInfo.setFtransStatus(dbStatus);
                }
                txInfo.setTxName(rs.getString(2));
                txInfo.setFtxType(rs.getInt(3));
                txInfo.setSerializer(rs.getString(4));
                txInfo.setRouteKey(rs.getString(5));
                this.convertContextInfoToRequest(rs.getString(6));
                return txInfo;
            }
            return null;
        });
    }

    private Map<String, Object> getWhereSqlBy(String xid, long txSceneId, int status, int secondStatus, String txCreatedFrom, String txCreatedTo, TxListType listType, DtxType dtxType, int txType, String bizId) {
        String wherePrefix = "WHERE (1 = 1)";
        StringBuilder wherePart = new StringBuilder(wherePrefix);
        HashMap<String, Object> sqlAndParams = new HashMap<String, Object>(2);
        ArrayList<Object> params = new ArrayList<Object>();
        switch (listType) {
            case EXCEPTION_TX_ALL: {
                wherePart.append(this.getExceptionAllWhereSql());
                break;
            }
            case EXCEPTION_TX_TO_HANDLE: {
                wherePart.append(this.getToHandleExceptionalTxListWhereSql());
                break;
            }
            case EXCEPTION_TX_HANDEL_SUCCESS: {
                wherePart.append(this.getCompensatedTxListWhereSql());
                break;
            }
            case EXCEPTION_TX_HANDEL_FAIL: {
                wherePart.append(this.getCompensateFailedTxListWhereSql());
                break;
            }
            case TX_ALL: {
                wherePart.append(this.getAllTxListWhereSql());
                break;
            }
            default: {
                throw new KdtxException("listType inValid! txListType:" + listType);
            }
        }
        if (StringUtils.isNotEmpty((String)xid)) {
            if (this.isNeedFuzzyQuery(xid)) {
                wherePart.append(" AND trs.fxid like ? ");
                params.add("%" + xid + "%");
            } else {
                wherePart.append(" AND trs.fxid=? ");
                params.add(xid);
            }
        }
        if (txSceneId != 0L) {
            wherePart.append(" AND trs.fscenes_tx_id=? ");
            params.add(txSceneId);
        }
        if (status != 0) {
            if (status == 10) {
                wherePart.append(" AND (trs.fstatus = 4 AND rs.fcommit_retry_count != 0)");
            } else if (status == 11) {
                wherePart.append(" AND trs.fstatus not in (4,5,8)");
            } else {
                wherePart.append(" AND trs.fstatus=? ");
                params.add(status);
            }
        }
        if (txType != -1) {
            wherePart.append(" AND trs.ftx_type=? ");
            params.add(txType);
        }
        if (StringUtils.isNotEmpty((String)txCreatedFrom)) {
            LocalDateTime createdFrom = LocalDateTime.parse(txCreatedFrom, dateTimeFormatter);
            wherePart.append(" AND trs.fcreate_time >= ? ");
            params.add(createdFrom);
        }
        if (StringUtils.isNotEmpty((String)txCreatedTo)) {
            LocalDateTime createdTo = LocalDateTime.parse(txCreatedTo, dateTimeFormatter);
            wherePart.append(" AND trs.fcreate_time <= ? ");
            params.add(createdTo);
        }
        if (StringUtils.isNotEmpty((String)bizId)) {
            wherePart.append(" AND trs.fxid in (select br.fxid from t_cbs_dtx_branch br where br.fbizid=?) ");
            params.add(bizId);
        }
        if (secondStatus != -1) {
            wherePart.append(" AND trs.fsecondstatus=? ");
            params.add(secondStatus);
            wherePart.append(" AND trs.ftx_type=2 ");
        }
        if (wherePrefix.contentEquals(wherePart)) {
            wherePart.delete(0, wherePart.length());
        }
        sqlAndParams.put("sql", wherePart.toString());
        sqlAndParams.put("params", params.toArray());
        return sqlAndParams;
    }

    private String getExceptionAllWhereSql() {
        return " AND rs.ftrigger_type = 2 ";
    }

    private String getToHandleExceptionalTxListWhereSql() {
        String exceptionalSqlPrefix = " AND ((trs.fstatus IN ( %s ) and  rs.fseq=-1) or(rs.fseq!=-1 and rs.fstatus=0)) AND rs.fcommit_retry_count = 0 AND rs.frollback_retry_count = 0 AND  rs.ftrigger_type = 2 ";
        return String.format(exceptionalSqlPrefix, EnumUtils.toString((Status[])GlobalTxStatus.getCompensateEnable()));
    }

    private String getCompensatedTxListWhereSql() {
        String sql = " AND ((trs.fstatus IN ( %s ) and rs.fseq=-1) or (rs.fseq!=-1 and rs.fstatus=1)) AND (rs.fcommit_retry_count > 0 or rs.frollback_retry_count > 0) AND rs.ftrigger_type = 2 ";
        return String.format(sql, EnumUtils.toString((Status[])GlobalTxStatus.getFinished()));
    }

    private String getCompensateFailedTxListWhereSql() {
        String sql = " AND ((trs.fstatus NOT IN ( %s ) and rs.fseq=-1) or (rs.fseq!=-1 and rs.fstatus=0)) AND (rs.fcommit_retry_count > 0 or rs.frollback_retry_count > 0) AND rs.ftrigger_type = 2 ";
        return String.format(sql, EnumUtils.toString((Status[])GlobalTxStatus.getFinished()));
    }

    private String getAllTxListWhereSql() {
        return "";
    }

    private void setRetryCount(int commitRetryCount, int rollbackRetryCount, int triggerType, TxRetryInfo txRetryInfo) {
        if (triggerType == 3) {
            txRetryInfo.setTaskCommitRetryCount(commitRetryCount);
            txRetryInfo.setTaskRollbackRetryCount(rollbackRetryCount);
        } else if (triggerType == 2) {
            txRetryInfo.setManCommitRetryCount(commitRetryCount);
            txRetryInfo.setManRollbackRetryCount(rollbackRetryCount);
        }
    }

    private Map<String, Object> getLogWhereSql(String xid, long txSceneId, String startTimeFrom, String startTimeTo, String branchXid, String branchDesc, String branchClazz, int actionType, int triggerType, int result) {
        String wherePrefix = "WHERE (1 = 1)";
        StringBuilder wherePart = new StringBuilder(wherePrefix);
        HashMap<String, Object> sqlAndParams = new HashMap<String, Object>(2);
        ArrayList<Object> params = new ArrayList<Object>();
        if (StringUtils.isNotEmpty((String)xid)) {
            if (this.isNeedFuzzyQuery(xid)) {
                wherePart.append(" AND trs.fxid like ? ");
                params.add("%" + xid + "%");
            } else {
                wherePart.append(" AND trs.fxid=? ");
                params.add(xid);
            }
        }
        if (txSceneId != 0L) {
            wherePart.append(" AND trs.fscenes_tx_id=? ");
            params.add(txSceneId);
        }
        if (StringUtils.isNotEmpty((String)startTimeFrom)) {
            LocalDateTime dateTimeFrom = LocalDateTime.parse(startTimeFrom, dateTimeFormatter);
            wherePart.append(" AND tl.fcreate_time >= ? ");
            params.add(dateTimeFrom);
        }
        if (StringUtils.isNotEmpty((String)startTimeTo)) {
            LocalDateTime dateTimeTo = LocalDateTime.parse(startTimeTo, dateTimeFormatter);
            wherePart.append(" AND tl.fcreate_time <= ? ");
            params.add(dateTimeTo);
        }
        if (StringUtils.isNotEmpty((String)branchXid)) {
            wherePart.append(" AND tl.fbranch_id=? ");
            params.add(branchXid);
        }
        if (StringUtils.isNotEmpty((String)branchDesc)) {
            wherePart.append(" AND tsb.fname like ? ");
            params.add("%" + branchDesc + "%");
        }
        if (StringUtils.isNotEmpty((String)branchClazz)) {
            wherePart.append(" AND tb.fresource like ? ");
            params.add("%" + branchClazz + "%");
        }
        if (actionType != 0) {
            wherePart.append(" AND tl.faction_type=? ");
            params.add(actionType);
        }
        if (triggerType != 0) {
            wherePart.append(" AND tl.ftrigger_type=? ");
            params.add(triggerType);
        }
        if (result != 0) {
            wherePart.append(" AND tl.fresult=? ");
            params.add(result);
        }
        if (wherePrefix.contentEquals(wherePart)) {
            wherePart.delete(0, wherePart.length());
        }
        sqlAndParams.put("sql", wherePart.toString());
        sqlAndParams.put("params", params.toArray());
        return sqlAndParams;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<TxSceneInfo> queryAndSetTxSceneInfo(String id) {
        HashMap<String, TxSceneInfo> map = new HashMap<String, TxSceneInfo>(16);
        ArrayList<TxSceneInfo> ret = new ArrayList<TxSceneInfo>(16);
        Object[] params = null;
        if (StringUtils.isNotEmpty((String)id)) {
            params = new Object[]{id};
        }
        QFilter[] filters = null;
        if (params != null && params.length > 0) {
            filters = new QFilter[]{new QFilter("id", "=", (Object)id)};
        }
        try (DataSet dataSet = ORM.create().queryDataSet("CompensateService.queryAndSetTxSceneInfo", "bos_kdtx_scenes", "id,code,tx_desc as name,app,remark,entryentity.id as b_id,entryentity.b_code as b_code,entryentity.b_desc as b_name,entryentity.b_remark as b_remark", filters, "tx_desc,entryentity.b_desc");){
            while (dataSet.hasNext()) {
                TxBranchSceneInfo branchSceneInfo;
                Row row = dataSet.next();
                String txSceneId = row.getString("id");
                TxSceneInfo txSceneInfo = (TxSceneInfo)map.get(txSceneId);
                if (txSceneInfo == null) {
                    txSceneInfo = new TxSceneInfo();
                    txSceneInfo.setId(txSceneId);
                    txSceneInfo.setCode(row.getString("code"));
                    txSceneInfo.setName(row.getString("name"));
                    txSceneInfo.setApp(row.getString("app"));
                    txSceneInfo.setRemark(row.getString("remark"));
                    branchSceneInfo = new TxBranchSceneInfo();
                    branchSceneInfo.setId(row.getString("b_id"));
                    branchSceneInfo.setScenesTxId(row.getString("id"));
                    branchSceneInfo.setCode(row.getString("b_code"));
                    branchSceneInfo.setName(row.getString("b_name"));
                    branchSceneInfo.setRemark(row.getString("b_remark"));
                    ArrayList<TxBranchSceneInfo> branchSceneInfoList = new ArrayList<TxBranchSceneInfo>(4);
                    branchSceneInfoList.add(branchSceneInfo);
                    txSceneInfo.setBranchSceneInfoList(branchSceneInfoList);
                    map.put(txSceneId, txSceneInfo);
                    continue;
                }
                branchSceneInfo = new TxBranchSceneInfo();
                branchSceneInfo.setId(row.getString("b_id"));
                branchSceneInfo.setScenesTxId(row.getString("id"));
                branchSceneInfo.setCode(row.getString("b_code"));
                branchSceneInfo.setName(row.getString("b_name"));
                branchSceneInfo.setRemark(row.getString("b_remark"));
                txSceneInfo.getBranchSceneInfoList().add(branchSceneInfo);
            }
            ret.addAll(map.values());
            ArrayList<TxSceneInfo> arrayList = ret;
            return arrayList;
        }
        catch (Throwable e) {
            ExceptionLogger.error(CompensateService.class, (String)"queryAndSetTxSceneInfo error", (Throwable)e);
            return (List)DB.query((DBRoute)DBRoute.base, (String)this.getTxSceneInfoQuerySql(id), (Object[])params, rs -> {
                while (rs.next()) {
                    TxBranchSceneInfo branchSceneInfo;
                    String txSceneId = rs.getString(1);
                    TxSceneInfo txSceneInfo = (TxSceneInfo)map.get(txSceneId);
                    if (txSceneInfo == null) {
                        txSceneInfo = new TxSceneInfo();
                        txSceneInfo.setId(txSceneId);
                        txSceneInfo.setCode(rs.getString(2));
                        txSceneInfo.setName(rs.getString(3));
                        txSceneInfo.setApp(rs.getString(4));
                        txSceneInfo.setRemark(rs.getString(5));
                        branchSceneInfo = new TxBranchSceneInfo();
                        branchSceneInfo.setId(rs.getString(6));
                        branchSceneInfo.setScenesTxId(rs.getString(7));
                        branchSceneInfo.setCode(rs.getString(8));
                        branchSceneInfo.setName(rs.getString(9));
                        branchSceneInfo.setRemark(rs.getString(10));
                        ArrayList<TxBranchSceneInfo> branchSceneInfoList = new ArrayList<TxBranchSceneInfo>(4);
                        branchSceneInfoList.add(branchSceneInfo);
                        txSceneInfo.setBranchSceneInfoList(branchSceneInfoList);
                        map.put(txSceneId, txSceneInfo);
                        continue;
                    }
                    branchSceneInfo = new TxBranchSceneInfo();
                    branchSceneInfo.setId(rs.getString(6));
                    branchSceneInfo.setScenesTxId(rs.getString(7));
                    branchSceneInfo.setCode(rs.getString(8));
                    branchSceneInfo.setName(rs.getString(9));
                    branchSceneInfo.setRemark(rs.getString(10));
                    txSceneInfo.getBranchSceneInfoList().add(branchSceneInfo);
                }
                ret.addAll(map.values());
                return ret;
            });
        }
    }

    private String getTxSceneInfoQuerySql(String id) {
        String idConSql = "";
        if (StringUtils.isNotEmpty((String)id)) {
            idConSql = "WHERE ts.fid = ? ";
        }
        return "SELECT ts.fid as id, ts.fcode as code, ts.fname as name, ts.fapp as app, ts.fremark as remark, tsb.fentryid as b_id, tsb.fid as b_scenes_tx_id, tsb.fcode as b_code, tsb.fname as b_name, tsb.fremark as b_remark FROM t_cbs_dtx_tx_scenes ts LEFT JOIN t_cbs_dtx_branch_scenes tsb ON ts.fid = tsb.fid " + idConSql + "ORDER BY ts.fname, tsb.fname";
    }

    public List<TxBusinessInfo> queryBusinessInfo(String businessType, List<String> businessIds) {
        String limitSql = "";
        int limit = Integer.getInteger("kdtx.queryBusinessInfo.sql.limit", 1000);
        if (limit > 0) {
            limitSql = "TOP " + limit + ",0";
        }
        String sql = "SELECT %s ctb.fxid, ctb.fbusiness_id, ctb.fbusiness_type ,ctt.froutekey, ctt.ftx_type FROM t_cbs_dtx_business ctb JOIN t_cbs_dtx_transaction ctt ON ctb.fxid=ctt.fxid WHERE ctt.fstatus in (1,2,3,6,7) ";
        sql = String.format(sql, limitSql);
        HashMap<String, TxBusinessInfo> businessInfos = new HashMap<String, TxBusinessInfo>();
        HashMap<String, List<String>> routeKeyXIds = new HashMap<String, List<String>>();
        List distinctList = businessIds.stream().distinct().collect(Collectors.toList());
        List partition = Lists.partition(distinctList, (int)1000);
        for (List list : partition) {
            StringBuilder builder = new StringBuilder(sql);
            if (StringUtils.isNotEmpty((String)businessType)) {
                builder.append("AND ctb.fbusiness_type='").append(businessType).append("'");
            }
            builder.append("AND ctb.fbusiness_id in(");
            for (int i = 0; i < list.size(); ++i) {
                builder.append("'").append((String)list.get(i)).append("'");
                if (i == list.size() - 1) continue;
                builder.append(",");
            }
            builder.append(")");
            DB.query((DBRoute)DBRoute.base, (String)builder.toString(), rs -> {
                while (rs.next()) {
                    String xid = rs.getString("fxid");
                    String bizId = rs.getString("fbusiness_id");
                    String type = rs.getString("fbusiness_type");
                    String routeKey = rs.getString("froutekey");
                    int txType = rs.getInt("ftx_type");
                    TxBusinessInfo businessInfo = businessInfos.computeIfAbsent(xid + "_" + type, key -> new TxBusinessInfo());
                    businessInfo.setFxid(xid);
                    businessInfo.setFbusinessType(type);
                    ArrayList<String> ids = businessInfo.getBusinessIds();
                    if (ids == null) {
                        ids = new ArrayList<String>();
                        businessInfo.setBusinessIds(ids);
                    }
                    ids.add(bizId);
                    if (txType != DtxType.EC.getCode()) continue;
                    List xids = routeKeyXIds.computeIfAbsent(routeKey, k -> new ArrayList());
                    xids.add(xid);
                }
                return null;
            });
        }
        return this.filterUnValidTxInfo(businessInfos, routeKeyXIds);
    }

    private List<TxBusinessInfo> filterUnValidTxInfo(Map<String, TxBusinessInfo> businessInfos, Map<String, List<String>> routeKeyXIds) {
        ArrayList<TxBusinessInfo> businessList = new ArrayList<TxBusinessInfo>(10);
        HashSet unValidXid = new HashSet();
        for (Map.Entry<String, List<String>> entry : routeKeyXIds.entrySet()) {
            if (StringUtils.isEmpty((String)entry.getKey())) continue;
            HashSet unValidXidTemp = new HashSet(entry.getValue());
            SqlBuilder builder = new SqlBuilder();
            builder.append("select fxid from t_dtx_local_tx_log where ", new Object[0]);
            builder.appendIn("fxid", entry.getValue().toArray());
            DB.query((DBRoute)DBRoute.of((String)entry.getKey()), (SqlBuilder)builder, rs -> {
                while (rs.next()) {
                    String id = rs.getString("fxid");
                    unValidXidTemp.remove(id);
                }
                return null;
            });
            unValidXid.addAll(unValidXidTemp);
        }
        for (TxBusinessInfo businessInfo : businessInfos.values()) {
            if (unValidXid.contains(businessInfo.getFxid())) continue;
            businessList.add(businessInfo);
        }
        return businessList;
    }

    public List<BusinessEntryInfo> queryBusinessEntry(BusinessParam param) {
        String splitPageSql = "";
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (param.getLimitSize() != 0) {
            splitPageSql = "TOP " + param.getLimitSize() + ",0 ";
        }
        String sql = "select " + splitPageSql + "fxid,fbranch_id,fbusiness_id,fbusiness_type,fcreate_time from t_cbs_dtx_business where 1=1 ";
        if (StringUtils.isNotEmpty((String)param.getXid())) {
            if (this.isNeedFuzzyQuery(param.getXid())) {
                sql = sql + " AND fxid like ?";
                paramList.add("%" + param.getXid() + "%");
            } else {
                sql = sql + " AND fxid = ?";
                paramList.add(param.getXid());
            }
        }
        if (StringUtils.isNotEmpty((String)param.getBusinessType())) {
            sql = sql + " AND fbusiness_type = ?";
            paramList.add(param.getBusinessType());
        }
        if (StringUtils.isNotEmpty((String)param.getBusinessId())) {
            sql = sql + " AND fbusiness_id = ?";
            paramList.add(param.getBusinessId());
        }
        if (StringUtils.isNotEmpty((String)param.getCreateTimeFrom())) {
            LocalDateTime dateTimeFrom = LocalDateTime.parse(param.getCreateTimeFrom(), dateTimeFormatter);
            sql = sql + " AND fcreate_time >= ? ";
            paramList.add(dateTimeFrom);
        }
        if (StringUtils.isNotEmpty((String)param.getCreateTimeTo())) {
            LocalDateTime dateTimeTo = LocalDateTime.parse(param.getCreateTimeTo(), dateTimeFormatter);
            sql = sql + " AND fcreate_time <= ? ";
            paramList.add(dateTimeTo);
        }
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])paramList.toArray(), rs -> {
            ArrayList<BusinessEntryInfo> businessInfoS = new ArrayList<BusinessEntryInfo>(10);
            while (rs.next()) {
                BusinessEntryInfo businessInfo = new BusinessEntryInfo();
                businessInfo.setXid(rs.getString("fxid"));
                businessInfo.setBranchId(rs.getString("fbranch_id"));
                businessInfo.setBusinessType(rs.getString("fbusiness_type"));
                businessInfo.setBusinessId(rs.getString("fbusiness_id"));
                businessInfo.setCreateTime(rs.getString("fcreate_time"));
                businessInfoS.add(businessInfo);
            }
            return businessInfoS;
        });
    }

    public void resend(TxInfo txInfo, Long seq, boolean isManaulRetry) throws Exception {
        TreeSet localTxLogs = null;
        try {
            localTxLogs = LocalTxDbHelper.getLocalTxLogList((DBRoute)DBRoute.of((String)txInfo.getRouteKey()), (String)txInfo.getFxid(), (Long)seq);
        }
        catch (Exception e) {
            ExceptionLogger.error(CompensateService.class, (String)"KdtxMonitorLog query local tx table error. tenant [{}], xid [{}] ", (Object[])new Object[]{RequestContext.get().getTenantId(), txInfo.getFxid(), e});
        }
        if (localTxLogs != null && localTxLogs.size() > 0 && StringUtils.isNotEmpty((String)txInfo.getRouteKey())) {
            HashMap<String, String> dto = new HashMap<String, String>();
            dto.put("serializer", txInfo.getSerializer());
            dto.put("routeKey", (String)DBRoute.of((String)txInfo.getRouteKey()));
            dto.put("onlyInvoke", "true");
            dto.put("xid", txInfo.getFxid());
            ArrayList<DtxParas> dtxParas = new ArrayList<DtxParas>();
            for (LocalTxLog localTxLog : localTxLogs) {
                if (!isManaulRetry && LocalTxLogStatus.RECEIVED.getCode() == localTxLog.getStatus()) continue;
                DtxParas dtxPara = new DtxParas();
                dtxPara.setXid(localTxLog.getXid());
                dtxPara.setCloudId(localTxLog.getCloudId());
                dtxPara.setAppId(localTxLog.getAppId());
                dtxPara.setResource(localTxLog.getResource());
                dtxPara.setParamType(localTxLog.getParaType());
                dtxPara.setParam(localTxLog.getParas());
                dtxPara.setBranchCode(localTxLog.getCode());
                dtxPara.setBizId(localTxLog.getBizId());
                dtxPara.setSeq(localTxLog.getSeq());
                dtxPara.setTotalBranch(!isManaulRetry ? localTxLogs.size() : 0);
                dtxPara.setTaskRetry(true);
                dtxPara.setParasBytes(localTxLog.getParaBytes());
                dtxPara.setLocalStatus(localTxLog.getStatus());
                dtxParas.add(dtxPara);
            }
            if (dtxParas.size() != 0) {
                try {
                    DBLogger.insertActionLog((String)txInfo.getFxid(), (long)(isManaulRetry ? ((DtxParas)dtxParas.get(0)).getSeq() : -1L), (ActionType)ActionType.TX_EXECUTE_DIRECT, (int)1, (String)"", (int)(isManaulRetry ? TriggerType.MANUALLY.getCode() : TriggerType.TASK.getCode()));
                }
                catch (Exception e) {
                    LOG.error("insertActionLog fail", (Throwable)e);
                }
                this.handleCommit().handle(dto, dtxParas);
            } else if (!isManaulRetry) {
                LocalTxDbHelper.allReceived(null, (String)txInfo.getFxid());
            }
        }
    }

    private SimpleAction handleCommit() {
        try {
            return (SimpleAction)Class.forName(FACTROY).getMethod(GET_ACTION_INSTANCE, ActionType.class).invoke(null, ActionType.TX_COMMIT);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("PublishedTask getActionInstance forName(kd.bos.kdtx.sdk.service.SimpleActionFactory#getActionInstance) fail:" + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            String msg = String.format("getActionInstance fail:%s", e.getTargetException().getMessage());
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(msg, e.getTargetException());
        }
    }

    public static boolean mqSecondCompensate(String xid, long seq) {
        boolean isMaxCount = false;
        String queryCount = "SELECT rs.fid as fid,ISNULL(rs.fcommit_retry_count, 0) as commit_retry_count FROM  t_cbs_dtx_retry_stat rs  where fxid=? and rs.ftrigger_type = 1 and fseq=?";
        long fid = 0L;
        int commitCount = 0;
        try (DataSet dataSet = DB.queryDataSet((String)"secondCompensate", (DBRoute)DBRoute.basedata, (String)queryCount, (Object[])new Object[]{xid, seq});){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                fid = row.getLong("fid");
                commitCount = row.getInteger("commit_retry_count");
            }
        }
        if (commitCount >= TransCoordinatorConfig.getPublishRetryMax()) {
            return true;
        }
        String insert_task_commit_retry = "INSERT INTO t_cbs_dtx_retry_stat(fid, fxid, ftrigger_type, fcommit_retry_count, frollback_retry_count, fseq, fcreate_time, fupdate_time) VALUES(?,?,?,?,?,?,now(),now())";
        String update_commit_retry_state = "UPDATE t_cbs_dtx_retry_stat SET fcommit_retry_count = fcommit_retry_count + 1, fupdate_time = NOW() WHERE fid = ? ";
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (fid == 0L) {
                    DB.execute((DBRoute)DBRoute.base, (String)insert_task_commit_retry, (Object[])new Object[]{ID.genLongId(), xid, 1, 1, 0, seq});
                } else {
                    DB.execute((DBRoute)DBRoute.base, (String)update_commit_retry_state, (Object[])new Object[]{fid});
                }
                if (commitCount + 1 >= TransCoordinatorConfig.getPublishRetryMax()) {
                    CompensateService.toManual(xid, seq);
                }
            }
            catch (Exception e) {
                tx.markRollback();
            }
        }
        return isMaxCount;
    }

    private static void toManual(String xid, long seq) {
        String sql_to_manual = "INSERT INTO t_cbs_dtx_RETRY_STAT( FID,FXID,FTRIGGER_TYPE,FCOMMIT_RETRY_COUNT,FROLLBACK_RETRY_COUNT,fseq,FCREATE_TIME,FUPDATE_TIME) VALUES(?,?,2,0,0,?,NOW(),NOW())";
        Object[] params = new Object[]{ID.genLongId(), xid, seq};
        DB.execute((DBRoute)DBRoute.base, (String)sql_to_manual, (Object[])params);
    }

    public static boolean isManual(String xid, long seq) {
        String sql = "select 1 from t_cbs_dtx_RETRY_STAT where fxid=? and ftrigger_type=2 and fseq=?";
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{xid, seq}, ResultSet::next);
    }

    public static void compensateSuccess(String xid, long seq) {
        String update_commit_retry_state = "UPDATE t_cbs_dtx_retry_stat SET fstatus = ?, fupdate_time = NOW() WHERE fxid = ? and fseq=?";
        DB.execute((DBRoute)DBRoute.base, (String)update_commit_retry_state, (Object[])new Object[]{CompensateStatus.COMPENSATE_SUCCESS.getCode(), xid, seq});
    }

    private boolean isNeedFuzzyQuery(String xid) {
        return xid.length() < 19;
    }

    public void unlockBusinessOrder(String xid) {
        block13: {
            int timeout = Integer.getInteger("kdtx.unlock.business.order.timeout", 3600);
            try (TXHandle txHandle = TX.requiresNew();){
                String lockedDataSql = "select fbusiness_id from t_cbs_dtx_business where fxid=? and  DATEADD(now(), -" + timeout + ") > fcreate_time";
                Boolean canUnlock = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)lockedDataSql, (Object[])new Object[]{xid}, ResultSet::next);
                if (canUnlock.booleanValue()) {
                    String deleteSql = "delete from t_cbs_dtx_business where fxid=?";
                    DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])new Object[]{xid});
                    String sql = "INSERT INTO t_cbs_dtx_logs (fid, fxid, fbranch_id, faction_type, ftrigger_type, fresult, fremark, ftraceid, fcreate_time)VALUES (?,?,?,?,?,?,?,?,NOW())";
                    long id = ID.genLongId();
                    Object[] params = new Object[]{id, xid, 0, 11, 1, 1, "unlockBusinessOrder:delete t_cbs_dtx_business for " + xid, RequestContext.get().getTraceId()};
                    DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
                    break block13;
                }
                throw new KdtxException(Resources.get((String)"bos-kdtx-server", (String)"unlockOrder", (String)("Already unlocked or not yet reached the unlocking time [" + timeout + " seconds]"), (Object[])new Object[0]));
            }
        }
    }

    private void convertContextInfoToRequest(String contextStr) {
        if (StringUtils.isEmpty((String)contextStr)) {
            return;
        }
        TempContextInfo tempContextInfo = (TempContextInfo)JsonUtils.parseJson((String)contextStr, TempContextInfo.class);
        String traceId = RequestContext.get().getTraceId();
        RequestContext rc = RequestContext.create((boolean)true);
        rc.setUserName(tempContextInfo.getUserName());
        rc.setUserId(String.valueOf(tempContextInfo.getUserId()));
        rc.setAccountId(tempContextInfo.getAccountId());
        rc.setTenantCode(tempContextInfo.getTenantId());
        rc.setTenantId(tempContextInfo.getTenantId());
        rc.setTraceId(traceId);
    }
}

