/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.compensate;

import java.lang.reflect.InvocationTargetException;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.kdtx.common.constant.DtxModel;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.common.constant.LocalTxLogStatus;
import kd.bos.kdtx.common.constant.TriggerType;
import kd.bos.kdtx.common.entity.TxSceneInfo;
import kd.bos.kdtx.common.mq.ReliableCommonService;
import kd.bos.kdtx.server.config.TransCoordinatorConfig;

public class ReliableMqCompensateService {
    private static final String LOCAL_TABLE_INIT_CLASS_NAME = "kd.bos.kdtx.sdk.init.TableInitConfig";
    private static final String LOCAL_TABLE_INIT_METHOD = "initLocalTable";
    private static final String BIZTYPE = "kdtx-branch-bizId";

    public static void createMqManualTrans(String routeKey, String xid, String cloudId, String appId, String resource, String bizId, String sceneCode, String serializer, byte[] paramBytes) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                ReliableMqCompensateService.initLocalTable(routeKey);
                ReliableMqCompensateService.insertManualLocalTranTable(routeKey, xid, cloudId, appId, resource, bizId, paramBytes);
                try (TXHandle handle = TX.requiresNew();){
                    try {
                        ReliableMqCompensateService.insertManualTransactionTable(xid, routeKey, sceneCode, serializer);
                        ReliableMqCompensateService.insertManualRetryStatTale(xid);
                        ReliableMqCompensateService.insertManualBusinessTable(xid, bizId);
                    }
                    catch (Exception e) {
                        handle.markRollback();
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }

    private static void insertManualLocalTranTable(String routeKey, String xid, String cloudId, String appId, String resource, String bizId, byte[] paramBytes) {
        String insertLocal = "INSERT INTO t_dtx_local_tx_log(fid,fxid,fseq,fcloud_id,fapp_id,fresource,fpara_type,fparas,fcode,fbizid, fcreate_time , fparas_bytes,fstatus) VALUES (?,?,?,?,?,?,?,?,?,?,now() ,?,?)";
        Object[] params = new Object[]{ID.genLongId(), xid, 0, cloudId, appId, resource, "", "", "", bizId, paramBytes, LocalTxLogStatus.RECEIVED.getCode()};
        DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)insertLocal, (Object[])params);
    }

    private static void initLocalTable(String routeKey) {
        try {
            Class.forName(LOCAL_TABLE_INIT_CLASS_NAME).getMethod(LOCAL_TABLE_INIT_METHOD, Integer.TYPE, DBRoute.class).invoke(null, DtxType.SIMPLEEC.getCode(), DBRoute.of((String)routeKey));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("CompensateService initLocalTable forName(kd.bos.kdtx.sdk.init.TableInitConfig#initLocalTable) fail:" + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            String msg = String.format("initLocalTable fail:%s", e.getTargetException().getMessage());
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(msg, e.getTargetException());
        }
    }

    private static void insertManualTransactionTable(String xid, String routeKey, String sceneCode, String serializer) {
        TxSceneInfo txSceneInfo = ReliableCommonService.createMqSceneIfNeed((String)sceneCode);
        String sql = "INSERT INTO t_cbs_dtx_transaction(fid, fxid, ftx_type, fscenes_tx_id, fstatus, ftenant_id, faccount_id, frollback_reason, fmodel, fparent_xid, fsource_branch_id, fserializer, froutekey, fsecondstatus, fcreate_time, fupdate_time) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,now(),now())";
        Object[] params = new Object[]{ID.genLongId(), xid, DtxType.SIMPLEEC.getCode(), Long.parseLong(txSceneInfo.getId()), GlobalTxStatus.COMMITTED.getCode(), RequestContext.get().getTenantId(), Long.parseLong(RequestContext.get().getAccountId()), "", DtxModel.RPC.getCode(), Character.valueOf(' '), Character.valueOf(' '), serializer, routeKey, LocalTxLogStatus.RECEIVED.getCode()};
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
    }

    private static void insertManualRetryStatTale(String xid) {
        String insert_task_commit_retry = "INSERT INTO t_cbs_dtx_retry_stat(fid, fxid, ftrigger_type, fcommit_retry_count, frollback_retry_count, fseq, fcreate_time, fupdate_time) VALUES(?,?,?,?,?,?,now(),now())";
        Object[] normalParam = new Object[]{ID.genLongId(), xid, TriggerType.NORMAL.getCode(), TransCoordinatorConfig.getPublishRetryMax(), 0, 0};
        DB.execute((DBRoute)DBRoute.base, (String)insert_task_commit_retry, (Object[])normalParam);
        Object[] manualParam = new Object[]{ID.genLongId(), xid, TriggerType.MANUALLY.getCode(), 0, 0, 0};
        DB.execute((DBRoute)DBRoute.base, (String)insert_task_commit_retry, (Object[])manualParam);
    }

    private static void insertManualBusinessTable(String xid, String businessId) {
        String busSql = "INSERT INTO t_cbs_dtx_business(fid,fxid,fbranch_id,fbusiness_id,fbusiness_type,fcreate_time) VALUES(?,?,?,?,?,now())";
        try {
            Object[] busParams = new Object[]{ID.genLongId(), xid, "", businessId, BIZTYPE};
            DB.execute((DBRoute)DBRoute.base, (String)busSql, (Object[])busParams);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

