/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.context;

import java.util.List;
import kd.bos.kdtx.common.constant.ActionType;

public class TcContext {
    private static ThreadLocal<TcContext> current = new ThreadLocal();
    private boolean taskRetry;
    private boolean manuallyRetry;
    private boolean autoManuallyRetry;
    private String xid;
    private String txType;
    private String txCode;
    private String branchCode;
    private ActionType actionType;
    private String branchId;
    private String resource;
    private String paras;
    private String contextBranchSeq;
    private String contextBusinessType;
    private List<String> contextBusinessIds;
    private boolean asyncCommit;
    private boolean asyncRollback;
    private String bizId;
    private boolean runMqModel;
    private int localStatus;
    private String dbRoute;
    private String parentBranchId;
    private Long cascadeSeq;
    private byte[] parasBytes;
    private String parentXid;

    public static TcContext getOrCreate() {
        TcContext tc = TcContext.get();
        if (tc == null) {
            tc = TcContext.create();
        }
        return tc;
    }

    public static TcContext create() {
        return TcContext.create(true);
    }

    public static TcContext create(boolean setCurrent) {
        TcContext tc = new TcContext();
        if (setCurrent) {
            TcContext.set(tc);
        }
        return tc;
    }

    public static TcContext get() {
        return current.get();
    }

    public static void set(TcContext rc) {
        current.set(rc);
    }

    public static TcContext copy(TcContext tc) {
        TcContext copy = TcContext.create(false);
        if (tc != null) {
            copy.setTaskRetry(tc.taskRetry);
            copy.setManuallyRetry(tc.manuallyRetry);
            copy.setAutoManuallyRetry(tc.autoManuallyRetry);
            copy.setXid(tc.xid);
            copy.setTxType(tc.txType);
            copy.setTxCode(tc.txCode);
            copy.setBranchCode(tc.branchCode);
            copy.setActionType(tc.actionType);
            copy.setBranchId(tc.branchId);
            copy.setResource(tc.resource);
            copy.setParas(tc.paras);
            copy.setContextBranchSeq(tc.contextBranchSeq);
            copy.setContextBusinessType(tc.contextBusinessType);
            copy.setContextBusinessIds(tc.contextBusinessIds);
            copy.setAsyncCommit(tc.asyncCommit);
            copy.setAsyncRollback(tc.asyncRollback);
            copy.setBizId(tc.bizId);
            copy.setRunMqModel(tc.runMqModel);
            copy.setParentBranchId(tc.parentBranchId);
            copy.setCascadeSeq(tc.cascadeSeq);
            copy.setParasBytes(tc.parasBytes);
            copy.setLocalStatus(tc.localStatus);
            copy.setDbRoute(tc.dbRoute);
        }
        return copy;
    }

    public static TcContext copyAndSet(TcContext tc) {
        TcContext copy = TcContext.copy(tc);
        TcContext.set(copy);
        return copy;
    }

    public static void remove() {
        current.remove();
    }

    public boolean isRetry() {
        return this.isTaskRetry() || this.isManuallyRetry();
    }

    public boolean isTaskRetry() {
        return this.taskRetry;
    }

    public void setTaskRetry(boolean taskRetry) {
        this.taskRetry = taskRetry;
    }

    public boolean isManuallyRetry() {
        return this.manuallyRetry;
    }

    public void setManuallyRetry(boolean manuallyRetry) {
        this.manuallyRetry = manuallyRetry;
    }

    public boolean isAutoManuallyRetry() {
        return this.autoManuallyRetry;
    }

    public void setAutoManuallyRetry(boolean autoManuallyRetry) {
        this.autoManuallyRetry = autoManuallyRetry;
    }

    public String getXid() {
        return this.xid;
    }

    public void setXid(String xid) {
        this.xid = xid;
    }

    public String getTxType() {
        return this.txType;
    }

    public void setTxType(String txType) {
        this.txType = txType;
    }

    public String getTxCode() {
        return this.txCode;
    }

    public void setTxCode(String txCode) {
        this.txCode = txCode;
    }

    public String getBranchCode() {
        return this.branchCode;
    }

    public void setBranchCode(String branchCode) {
        this.branchCode = branchCode;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public void setActionType(ActionType actionType) {
        this.actionType = actionType;
    }

    public String getBranchId() {
        return this.branchId;
    }

    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getParas() {
        return this.paras;
    }

    public void setParas(String paras) {
        this.paras = paras;
    }

    public String getContextBranchSeq() {
        return this.contextBranchSeq;
    }

    public void setContextBranchSeq(String contextBranchSeq) {
        this.contextBranchSeq = contextBranchSeq;
    }

    public String getContextBusinessType() {
        return this.contextBusinessType;
    }

    public void setContextBusinessType(String contextBusinessType) {
        this.contextBusinessType = contextBusinessType;
    }

    public List<String> getContextBusinessIds() {
        return this.contextBusinessIds;
    }

    public void setContextBusinessIds(List<String> contextBusinessIds) {
        this.contextBusinessIds = contextBusinessIds;
    }

    public boolean isAsyncCommit() {
        return this.asyncCommit;
    }

    public void setAsyncCommit(boolean asyncCommit) {
        this.asyncCommit = asyncCommit;
    }

    public boolean isAsyncRollback() {
        return this.asyncRollback;
    }

    public void setAsyncRollback(boolean asyncRollback) {
        this.asyncRollback = asyncRollback;
    }

    public String getBizId() {
        return this.bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public boolean isRunMqModel() {
        return this.runMqModel;
    }

    public void setRunMqModel(boolean runModel) {
        this.runMqModel = runModel;
    }

    public String getParentBranchId() {
        return this.parentBranchId;
    }

    public void setParentBranchId(String parentBranchId) {
        this.parentBranchId = parentBranchId;
    }

    public Long getCascadeSeq() {
        return this.cascadeSeq;
    }

    public void setCascadeSeq(Long cascadeSeq) {
        this.cascadeSeq = cascadeSeq;
    }

    public byte[] getParasBytes() {
        return this.parasBytes;
    }

    public void setParasBytes(byte[] parasBytes) {
        this.parasBytes = parasBytes;
    }

    public int getLocalStatus() {
        return this.localStatus;
    }

    public void setLocalStatus(int localStatus) {
        this.localStatus = localStatus;
    }

    public String getDbRoute() {
        return this.dbRoute;
    }

    public void setDbRoute(String dbRoute) {
        this.dbRoute = dbRoute;
    }

    public String getParentXid() {
        return this.parentXid;
    }

    public void setParentXid(String parentXid) {
        this.parentXid = parentXid;
    }
}

