/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.dao;

import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.entity.TxInfo;

public class BranchDao {
    private static final String COUNT_SQL = "select count(*) from t_cbs_dtx_branch  where fxid=?";
    private static final String COMMIT_COUNT_SQL = "select count(*) from t_cbs_dtx_branch  where fxid=? and fstatus=4";
    private static final String EXIST_SQL = "select fid from t_cbs_dtx_branch where fxid = ? AND fseq = ?";
    private static final String HAS_COMMITED_SQL = "select fid from t_cbs_dtx_branch where fxid = ? AND fseq = ? and fstatus=4";
    private static final String QUERY_TX_BY_BRANCH_ID_SQL = "select tr.fxid,tr.ftx_type  from t_cbs_dtx_transaction tr join t_cbs_dtx_branch br on tr.fxid=br.fxid where br.fbranch_id=?";

    public static int getCount(String xid) {
        return BranchDao.count(xid, COUNT_SQL);
    }

    public static boolean registered(String xid, long seq) {
        return BranchDao.exist(xid, seq, EXIST_SQL);
    }

    public static boolean committed(String xid, long seq) {
        return BranchDao.exist(xid, seq, HAS_COMMITED_SQL);
    }

    public static int getCommitCount(String xid) {
        return BranchDao.count(xid, COMMIT_COUNT_SQL);
    }

    private static int count(String xid, String sql) {
        return (Integer)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{xid}, rs -> {
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            return count;
        });
    }

    private static boolean exist(String xid, long seq, String sql) {
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{xid, seq}, rs -> {
            boolean exist = false;
            if (rs.next()) {
                exist = true;
            }
            return exist;
        });
    }

    public static TxInfo getTxInfoByBranchId(String branchId) {
        return (TxInfo)DB.query((DBRoute)DBRoute.basedata, (String)QUERY_TX_BY_BRANCH_ID_SQL, (Object[])new Object[]{branchId}, rs -> {
            if (rs.next()) {
                TxInfo txInfo = new TxInfo();
                txInfo.setFxid(rs.getString(1));
                txInfo.setFtxType(2);
                return txInfo;
            }
            return null;
        });
    }
}

