/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.factory;

import java.util.HashMap;
import java.util.Map;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.server.state.BaseTcState;
import kd.bos.kdtx.server.state.impl.CommitFailedState;
import kd.bos.kdtx.server.state.impl.CommittedState;
import kd.bos.kdtx.server.state.impl.CommittingState;
import kd.bos.kdtx.server.state.impl.NotFoundState;
import kd.bos.kdtx.server.state.impl.PreparingState;
import kd.bos.kdtx.server.state.impl.RollbackFailedState;
import kd.bos.kdtx.server.state.impl.RollbackedState;
import kd.bos.kdtx.server.state.impl.RollbackingState;

public class StateFactory {
    private static Map<Integer, BaseTcState> transCoordinatorMap = new HashMap<Integer, BaseTcState>();

    public static BaseTcState getInstance(int stateType) {
        return transCoordinatorMap.get(stateType);
    }

    static {
        transCoordinatorMap.put(GlobalTxStatus.NOT_FOUND.getCode(), new NotFoundState());
        transCoordinatorMap.put(GlobalTxStatus.PREPARING.getCode(), new PreparingState());
        transCoordinatorMap.put(GlobalTxStatus.COMMITTING.getCode(), new CommittingState());
        transCoordinatorMap.put(GlobalTxStatus.COMMITTED.getCode(), new CommittedState());
        transCoordinatorMap.put(GlobalTxStatus.COMMIT_FAILED.getCode(), new CommitFailedState());
        transCoordinatorMap.put(GlobalTxStatus.ROLLBACKING.getCode(), new RollbackingState());
        transCoordinatorMap.put(GlobalTxStatus.ROLLBACKED.getCode(), new RollbackedState());
        transCoordinatorMap.put(GlobalTxStatus.ROLLBACK_FAILED.getCode(), new RollbackFailedState());
    }
}

