/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.log;

import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.constant.TriggerType;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.tx.MultiDBWriteHandler;
import kd.bos.util.StringUtils;

public class TCCDBLogger {
    public static final String HAS_COMMITED_SQL = "select fid from t_cbs_dtx_logs where fxid=? and faction_type=30 and fresult=1";

    public static void updateActionLog(long logId, ActionType ActionType2, int result, String remark) {
        if (!StringUtils.isEmpty((String)remark) && remark.length() > 1000) {
            remark = remark.substring(0, 1000);
        }
        if (logId != 0L) {
            Object[] params;
            String sql;
            if (ActionType.TX_BEGIN == ActionType2) {
                sql = "UPDATE t_cbs_dtx_logs SET  fxid = ?,  fremark = ?,  fresult = ?,  fupdate_time = NOW() WHERE  fid = ?";
                params = new Object[]{TcContext.get().getXid(), remark, result, logId};
            } else if (ActionType.BRANCH_REGISTER == ActionType2) {
                sql = "UPDATE t_cbs_dtx_logs SET  fbranch_id = ?,  fremark = ?,  fresult = ?,  fupdate_time = NOW() WHERE  fid = ?";
                params = new Object[]{TcContext.get().getBranchId(), remark, result, logId};
            } else {
                sql = "UPDATE t_cbs_dtx_logs SET  fremark = ?,  fresult = ?,  fupdate_time = NOW() WHERE  fid = ?";
                params = new Object[]{remark, result, logId};
            }
            MultiDBWriteHandler.execute(() -> DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params));
        }
    }

    public static long insertActionLog(ActionType actionType) {
        return TCCDBLogger.insertActionLog(actionType, TcContext.get().getBranchId());
    }

    public static long insertActionLog(ActionType actionType, String branchId) {
        return TCCDBLogger.insertActionLog(actionType, branchId, 0, "");
    }

    public static long insertActionLog(ActionType actionType, String branchId, int result, String remark) {
        if (!StringUtils.isEmpty((String)remark) && remark.length() > 1000) {
            remark = remark.substring(0, 1000);
        }
        String sql = "INSERT INTO t_cbs_dtx_logs (fid, fxid, fbranch_id, faction_type, ftrigger_type, fresult, fremark, ftraceid, fcreate_time)VALUES (?,?,?,?,?,?,?,?,NOW())";
        long id = ID.genLongId();
        Object[] params = new Object[]{id, TcContext.get().getXid(), branchId, actionType.getCode(), TCCDBLogger.getTriggerType(), result, remark, RequestContext.get().getTraceId()};
        MultiDBWriteHandler.execute(() -> DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params));
        return id;
    }

    public static boolean hasTxCommited(String xid) {
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)HAS_COMMITED_SQL, (Object[])new Object[]{xid}, rs -> {
            boolean exist = false;
            if (rs.next()) {
                exist = true;
            }
            return exist;
        });
    }

    private static int getTriggerType() {
        if (TcContext.get().isTaskRetry()) {
            return TriggerType.TASK.getCode();
        }
        if (TcContext.get().isAutoManuallyRetry()) {
            return TriggerType.AUTO_COMPENSATE.getCode();
        }
        if (TcContext.get().isManuallyRetry()) {
            return TriggerType.MANUALLY.getCode();
        }
        return TriggerType.NORMAL.getCode();
    }
}

