/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.monitor.alarm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bundle.Resources;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.instance.Instance;
import kd.bos.kdtx.common.config.DtxConfig;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.server.config.TransCoordinatorConfig;
import kd.bos.kdtx.server.monitor.alarm.AlarmMessageChannels;
import kd.bos.kdtx.server.monitor.alarm.AlarmMessageInfo;
import kd.bos.kdtx.server.tasks.CommitTask;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class AlarmUtils {
    private static final String PROJECT_NAME = "bos-kdtx-server";
    private static final String MESSAGE_TAG = "kdtx-server";
    private static final String ENTITY_NUMBER = "biz_scenes";
    public static final String ACTION_COMMIT = "COMMIT";
    public static final String ACTION_ROLLBACK = "ROLLBACK";
    public static final String ALARM_PREFIX = "kdtx-alarmed-";
    private static final String ALARM_SQL = "select dts.falarm_type,dts.fnotice_operator,dts.fid,dt.fcreator from t_cbs_dtx_transaction dt left join t_cbs_dtx_tx_scenes dts on dt.fscenes_tx_id=dts.fid where dt.fxid=?";
    private static final String ALARM_USER_SQL = "select dau.fbasedataid from t_cbs_dtx_alarm_user dau where dau.fid=?";

    public static void sendAlarmMessage(String xid, String sceneName, String actionType) {
        if (!DtxConfig.isAlarmMessageEnable()) {
            return;
        }
        String messageTitle = Resources.get((String)PROJECT_NAME, (String)"alarmTitle", (String)"", (Object[])new Object[0]);
        String messageContent = "";
        if (ACTION_COMMIT.equals(actionType)) {
            messageContent = Resources.get((String)PROJECT_NAME, (String)"commitFailAlarm", (String)"", (Object[])new Object[]{Instance.getClusterName(), sceneName, xid});
        } else if (ACTION_ROLLBACK.equals(actionType)) {
            messageContent = Resources.get((String)PROJECT_NAME, (String)"rollbackFailAlarm", (String)"", (Object[])new Object[]{Instance.getClusterName(), sceneName, xid});
        }
        AlarmMessageInfo alarmMessageInfo = AlarmUtils.buildMessage(xid, "alarm", messageTitle, messageContent);
        AlarmUtils.sendMessage(alarmMessageInfo);
    }

    public static void sendWarnMessage(String xid, String sceneName, String actionType) {
        if (!DtxConfig.isAlarmMessageEnable()) {
            return;
        }
        String messageTitle = Resources.get((String)PROJECT_NAME, (String)"warningTitle", (String)"", (Object[])new Object[0]);
        String messageContent = null;
        if (ACTION_COMMIT.equals(actionType)) {
            messageContent = Resources.get((String)PROJECT_NAME, (String)"commitRetryWarn", (String)"", (Object[])new Object[]{Instance.getClusterName(), sceneName, xid, TransCoordinatorConfig.getTaskRollbackRetryMax()});
        } else if (ACTION_ROLLBACK.equals(actionType)) {
            messageContent = Resources.get((String)PROJECT_NAME, (String)"rollbackRetryWarn", (String)"", (Object[])new Object[]{Instance.getClusterName(), sceneName, xid, TransCoordinatorConfig.getTaskRollbackRetryMax()});
        }
        AlarmMessageInfo alarmMessageInfo = AlarmUtils.buildMessage(xid, "warning", messageTitle, messageContent);
        AlarmUtils.sendMessage(alarmMessageInfo);
    }

    public static void sendNoticeMessage(String xid, String sceneName, String actionType) {
        if (!DtxConfig.isAlarmMessageEnable()) {
            return;
        }
        String messageTitle = Resources.get((String)PROJECT_NAME, (String)"warningTitle", (String)"", (Object[])new Object[0]);
        String messageContent = null;
        if (ACTION_COMMIT.equals(actionType)) {
            messageContent = Resources.get((String)PROJECT_NAME, (String)"commitRetrySuccess", (String)"", (Object[])new Object[]{Instance.getClusterName(), sceneName, xid});
        } else if (ACTION_ROLLBACK.equals(actionType)) {
            messageContent = Resources.get((String)PROJECT_NAME, (String)"rollbackRetrySuccess", (String)"", (Object[])new Object[]{Instance.getClusterName(), sceneName, xid});
        }
        AlarmMessageInfo alarmMessageInfo = AlarmUtils.buildMessage(xid, "message", messageTitle, messageContent);
        AlarmUtils.sendMessage(alarmMessageInfo);
    }

    private static Map<String, String> getAlarmInfo(String xid) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        try (DataSet ds = DB.queryDataSet((String)"GetAlarmInfo", (DBRoute)DBRoute.base, (String)ALARM_SQL, (Object[])new Object[]{xid});){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                map.put("alarmType", row.getString("falarm_type"));
                map.put("noticeOperator", row.getString("fnotice_operator"));
                map.put("fid", String.valueOf(row.getLong("fid")));
                map.put("creator", String.valueOf(row.getLong("fcreator")));
            }
        }
        return map;
    }

    private static List<Long> getAlarmUserIds(String fid) {
        ArrayList<Long> list = new ArrayList<Long>(6);
        try (DataSet ds = DB.queryDataSet((String)"GetAlarmUserIds", (DBRoute)DBRoute.base, (String)ALARM_USER_SQL, (Object[])new Object[]{Long.parseLong(fid)});){
            while (ds.hasNext()) {
                Row next = ds.next();
                list.add(next.getLong("fbasedataid"));
            }
        }
        return list;
    }

    private static AlarmMessageInfo buildMessage(String xid, String type, String messageTitle, String messageContent) {
        String creator;
        AlarmMessageInfo message = new AlarmMessageInfo();
        message.setXid(xid);
        Map<String, String> alarmInfo = AlarmUtils.getAlarmInfo(xid);
        if (alarmInfo == null || alarmInfo.isEmpty()) {
            throw new KdtxException("Alarm information is not configured, xid is =" + xid);
        }
        StringBuilder sb = new StringBuilder(AlarmMessageChannels.MCCENTER.getNumber());
        if (StringUtils.isNotEmpty((String)alarmInfo.get("alarmType"))) {
            sb.append(",").append(alarmInfo.get("alarmType"));
        }
        message.setNotifyType(sb.toString());
        List<Long> userIds = AlarmUtils.getAlarmUserIds(alarmInfo.get("fid"));
        if ("1".equals(alarmInfo.get("noticeOperator")) && RequestContext.get().getCurrUserId() != 0L && StringUtils.isNotEmpty((String)(creator = alarmInfo.get("creator")))) {
            userIds.add(Long.parseLong(creator));
        }
        if (userIds.isEmpty()) {
            ExceptionLogger.info(CommitTask.class, (String)"The userId of alarm notification is null , xid is ={}", (Object[])new Object[]{xid});
            return null;
        }
        message.setUserIds(userIds);
        if (StringUtils.isEmpty((String)messageTitle)) {
            throw new KdtxException("param messageTitle must be not null");
        }
        message.setMessageTitle((ILocaleString)new LocaleString(messageContent));
        if (StringUtils.isEmpty((String)messageContent)) {
            throw new KdtxException("param messageContent must be not null");
        }
        message.setMessageContent((ILocaleString)new LocaleString(messageContent));
        if (StringUtils.isEmpty((String)type)) {
            throw new KdtxException("param type must be not null");
        }
        message.setAlarmType(type);
        message.setEntityNumber(ENTITY_NUMBER);
        message.setTag(MESSAGE_TAG);
        return message;
    }

    public static void sendMessage(AlarmMessageInfo alarmInfo) {
        AlarmUtils.checkLimit(alarmInfo);
        if (CollectionUtils.isEmpty(alarmInfo.getUserIds())) {
            ExceptionLogger.info(AlarmUtils.class, (String)"kdtxserver all users have reached the maximum number of times to send");
            return;
        }
        try {
            AlarmUtils.doSend(alarmInfo);
        }
        catch (Exception e) {
            ExceptionLogger.error(AlarmUtils.class, (String)"kdtxserver send alarm message error", (Throwable)e);
        }
    }

    private static void checkLimit(AlarmMessageInfo alarmInfo) {
        DistributeSessionlessCache redisCache = AlarmUtils.getRedisCache();
        List<Long> userIds = alarmInfo.getUserIds();
        int interval = DtxConfig.getAlarmInterval();
        if (interval <= 0) {
            return;
        }
        ArrayList<Long> removeIds = new ArrayList<Long>(4);
        for (Long userId : userIds) {
            String key = ALARM_PREFIX + userId;
            String timeStr = (String)redisCache.get(key);
            if (StringUtils.isEmpty((String)timeStr)) {
                redisCache.inc(key);
                redisCache.expireAfter(key, DtxConfig.getAlarmIntervalTime());
                continue;
            }
            if (interval > Integer.parseInt(timeStr)) {
                redisCache.inc(key);
                continue;
            }
            removeIds.add(userId);
        }
        alarmInfo.setUserIds(userIds.stream().filter(o -> !removeIds.contains(o)).collect(Collectors.toList()));
    }

    private static void doSend(AlarmMessageInfo alarmMessageInfo) throws Exception {
        Class<?> msgSendService = Class.forName("kd.bos.servicehelper.workflow.MessageCenterServiceHelper");
        Class<?> clazz = Class.forName("kd.bos.workflow.engine.msg.info.MessageInfo");
        Object obj = clazz.newInstance();
        Method setTypeMethod = clazz.getMethod("setType", String.class);
        setTypeMethod.invoke(obj, alarmMessageInfo.getAlarmType());
        Method setMessageTitleMethod = clazz.getMethod("setMessageTitle", ILocaleString.class);
        setMessageTitleMethod.invoke(obj, alarmMessageInfo.getMessageTitle());
        Method setMessageContentMethod = clazz.getMethod("setMessageContent", ILocaleString.class);
        setMessageContentMethod.invoke(obj, alarmMessageInfo.getMessageContent());
        Method setUserIdsMethod = clazz.getMethod("setUserIds", List.class);
        setUserIdsMethod.invoke(obj, alarmMessageInfo.getUserIds());
        Method setEntityNumberMethod = clazz.getMethod("setEntityNumber", String.class);
        setEntityNumberMethod.invoke(obj, alarmMessageInfo.getEntityNumber());
        Method setTagMethod = clazz.getMethod("setTag", String.class);
        setTagMethod.invoke(obj, alarmMessageInfo.getTag());
        Method setNotifyTypeMethod = clazz.getMethod("setNotifyType", String.class);
        setNotifyTypeMethod.invoke(obj, alarmMessageInfo.getNotifyType());
        Method setPubaccNumberMethod = clazz.getMethod("setPubaccNumber", String.class);
        setPubaccNumberMethod.invoke(obj, "systempubacc");
        Method sendMessageMethod = msgSendService.getMethod("sendMessage", clazz);
        sendMessageMethod.invoke(null, obj);
    }

    private static DistributeSessionlessCache getRedisCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("kdtx");
    }
}

