/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.monitor.alarm.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.server.monitor.alarm.AlarmActionService;
import kd.bos.kdtx.server.monitor.alarm.impl.SmsUtils;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.util.StringUtils;

public class SmsActionServiceImpl
implements AlarmActionService {
    public static final String CONFIG_SMS = "kdtx.alarm.smsconfig";
    public static final String CONFIG_PHONE = "kdtx.alarm.phone";
    public static final String CONFIG_PHONE_DISABLE = "kdtx.alarm.disable";
    public static final int INTERVAL_DEFAULT = 0;
    public static final String INTERVAL = "kdtx.alarm.interval";
    public static final String PHONE_PREFIX = "kdtx-alarmed-phone-";
    private JedisClient timeCache = this.getJedisClient();

    @Override
    public boolean doAlarm(String phones, String message) {
        boolean rs = true;
        try {
            if (!"true".equals(System.getProperty(CONFIG_PHONE_DISABLE, "false"))) {
                phones = this.getNotifyPhone(phones);
                SmsUtils.sendSmsMessage(phones, message, this.getSmsApiConfig());
            }
        }
        catch (Exception e) {
            rs = false;
        }
        return rs;
    }

    private String getNotifyPhone(String phones) {
        String rootPhone = System.getProperty(CONFIG_PHONE, "");
        if (StringUtils.isNotEmpty((String)phones)) {
            phones = phones.replace(",", ";").replace(" ", ";");
            rootPhone = rootPhone + ";" + phones;
        }
        StringBuilder validPhone = new StringBuilder();
        if (StringUtils.isNotEmpty((String)rootPhone)) {
            String[] ps = rootPhone.split(";");
            for (int i = 0; i < ps.length; ++i) {
                int time;
                if (StringUtils.isEmpty((String)ps[i]) || !StringUtils.isEmpty((String)this.timeCache.get(PHONE_PREFIX + ps[i]))) continue;
                validPhone.append(ps[i]);
                if (i < ps.length - 1) {
                    validPhone.append(";");
                }
                if ((time = Integer.getInteger(INTERVAL, 0).intValue()) <= 0) continue;
                this.timeCache.setex(PHONE_PREFIX + ps[i], time, ps[i]);
            }
        }
        return validPhone.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getSmsApiConfig() {
        Map<String, String> tempMap;
        HashMap<String, String> smsConfig = new HashMap<String, String>();
        String providers = System.getProperty(CONFIG_SMS, "");
        if (StringUtils.isNotEmpty((String)providers)) {
            tempMap = this.zkConfigConvertMap(providers);
        } else {
            tempMap = new HashMap<String, String>();
            InputStream inputStream = null;
            try {
                Properties prop = new Properties();
                inputStream = this.getClass().getClassLoader().getResourceAsStream("kdtxSmsConfig.properties");
                prop.load(inputStream);
                for (String key : prop.stringPropertyNames()) {
                    tempMap.put(key, prop.getProperty(key));
                }
            }
            catch (Exception ex) {
                ExceptionLogger.error(SmsActionServiceImpl.class, (String)("kdtx-Error when load config from kdtxSmsConfig.properties: " + ex.getMessage()));
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        ExceptionLogger.error(SmsActionServiceImpl.class, (String)("kdtx-Error when load config from kdtxSmsConfig.properties: " + e.getMessage()));
                    }
                }
            }
        }
        if (tempMap != null) {
            for (Map.Entry<String, String> entry : tempMap.entrySet()) {
                String value = entry.getKey().contains("clientPwd") ? EncrypterFactory.getEncrypter().decode(entry.getValue()) : entry.getValue();
                smsConfig.put(entry.getKey().replace("kd.sms.", ""), value);
            }
        }
        return smsConfig;
    }

    private Map<String, String> zkConfigConvertMap(String providers) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        Pattern pattern = Pattern.compile(",");
        String[] matcher = pattern.split(providers.replace("\n", ""));
        for (int i = 0; i < matcher.length; ++i) {
            String value;
            String key;
            if (matcher[i].contains("kd.sms.clientPwd")) {
                key = "kd.sms.clientPwd";
                value = matcher[i].substring(17);
            } else {
                String[] trunk = matcher[i].split("=");
                key = trunk[0];
                value = trunk[1];
            }
            map.put(key, value);
        }
        return map;
    }

    private JedisClient getJedisClient() {
        return RedisFactory.getJedisClient((String)this.getRedisUrl());
    }

    private String getRedisUrl() {
        String configKey = CacheConfigKeys.getSessionlessConfigKey((String)"kdtx");
        String url = System.getProperty(configKey);
        if (url == null) {
            configKey = CacheConfigKeys.getSessionlessConfigKey(null);
            url = System.getProperty(configKey);
        }
        return url;
    }
}

