/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.mq;

import kd.bos.context.KdtxRequestContext;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.context.DtxContext;
import kd.bos.kdtx.common.param.BranchActionParam;
import kd.bos.kdtx.common.util.JsonUtils;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.dao.BranchDao;
import kd.bos.kdtx.server.log.TCCDBLogger;
import kd.bos.kdtx.server.service.TransCoordinatorService;
import kd.bos.kdtx.server.service.impl.TransCoordinatorServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;

public class BranchConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(BranchConsumer.class);
    TransCoordinatorService transCoordinatorService = new TransCoordinatorServiceImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        try {
            DtxParas dtxParas = (DtxParas)body;
            String xid = dtxParas.getXid();
            KdtxRequestContext.get().setXid(xid);
            String branchId = dtxParas.getBranchId();
            KdtxRequestContext.get().setBranchId(branchId);
            TcContext.getOrCreate().setRunMqModel(true);
            DtxContext.setRunMqModel((boolean)true);
            TcContext.getOrCreate().setXid(xid);
            TcContext.getOrCreate().setTaskRetry(dtxParas.isTaskRetry());
            TcContext.getOrCreate().setTxType(dtxParas.getTxType());
            BranchActionParam branchActionParam = this.assembleParam(dtxParas);
            this.branchRegistry(branchActionParam, xid, dtxParas.getTotalBranch(), dtxParas.getSeq());
            KdtxRequestContext.get().setDtxType(Integer.parseInt(TcContext.get().getTxType()));
            KdtxRequestContext.get().pushXidStack(xid);
            this.branchCommit(branchActionParam, xid, dtxParas.getSeq());
            acker.ack(messageId);
        }
        catch (Exception e) {
            if (resend) {
                acker.discard(messageId);
            } else {
                acker.deny(messageId);
            }
        }
        finally {
            TcContext.remove();
            DtxContext.remove();
        }
    }

    private BranchActionParam assembleParam(DtxParas dtxParas) {
        BranchActionParam param = new BranchActionParam();
        param.setResource(dtxParas.getResource());
        param.setTxCode(dtxParas.getSceneCode());
        param.setBranchCode(dtxParas.getBranchCode());
        param.setSeq(dtxParas.getSeq());
        param.setBizId(dtxParas.getBizId());
        param.setParasBytes(dtxParas.getParasBytes());
        dtxParas.setParasBytes(null);
        param.setParas(JsonUtils.getParasStr((Object)dtxParas));
        param.setLocalStatus(dtxParas.getLocalStatus());
        return param;
    }

    private void branchRegistry(BranchActionParam branchActionParam, String xid, int totalBranch, long seq) throws Exception {
        if (!BranchDao.registered(xid, seq)) {
            this.transCoordinatorService.proxyHandleBranch(ActionType.BRANCH_REGISTER, branchActionParam);
        }
        if (totalBranch == BranchDao.getCount(xid) && !TCCDBLogger.hasTxCommited(xid)) {
            this.transCoordinatorService.proxyHandleTx(ActionType.TX_COMMIT, null);
        }
    }

    private void branchCommit(BranchActionParam branchActionParam, String xid, long seq) throws Exception {
        if (!BranchDao.committed(xid, seq)) {
            this.transCoordinatorService.proxyHandleBranch(ActionType.BRANCH_COMMIT, branchActionParam);
        }
    }
}

