/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.service.impl;

import java.util.Collection;
import kd.bos.context.KdtxRequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.entity.TxBusinessInfo;
import kd.bos.kdtx.common.exception.DtxErrorCodeConstants;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.param.BranchActionParam;
import kd.bos.kdtx.common.param.TxActionParam;
import kd.bos.kdtx.server.action.branch.BranchActionContext;
import kd.bos.kdtx.server.action.tx.TxActionContext;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.log.TCCDBLogger;
import kd.bos.kdtx.server.service.TransCoordinatorService;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class TransCoordinatorServiceImpl
implements TransCoordinatorService {
    @Override
    public void proxyHandleTx(ActionType actionType, TxActionParam param) throws Exception {
        String txCode = null;
        String txType = null;
        TxBusinessInfo txBusinessInfo = null;
        if (param != null) {
            txCode = param.getTxCode();
            txType = param.getTxType();
            txBusinessInfo = param.getTxBusinessInfo();
        }
        this.setContext(actionType, txCode, null, txType, txBusinessInfo);
        this.proxyHandle(actionType, () -> this.handleTx(actionType, param));
    }

    @Override
    public void proxyHandleBranch(ActionType actionType, BranchActionParam param) throws Exception {
        this.setContext(actionType, param.getTxCode(), param.getBranchCode(), null, null);
        this.proxyHandle(actionType, () -> this.handleBranch(actionType, param));
    }

    @Override
    public void handleTx(ActionType actionType, TxActionParam param) throws Exception {
        this.assertActionTypeNotNull(actionType);
        TxActionContext txActionContext = new TxActionContext();
        txActionContext.handle(actionType);
    }

    @Override
    public void handleBranch(ActionType actionType, BranchActionParam param) throws Exception {
        this.assertActionTypeNotNull(actionType);
        BranchActionContext branchActionContext = new BranchActionContext();
        branchActionContext.handle(actionType, param);
    }

    private void proxyHandle(ActionType actionType, TcHandler handler) throws Exception {
        long logId = 0L;
        int result = 0;
        String remark = null;
        try {
            this.assertActionTypeNotNull(actionType);
            logId = TCCDBLogger.insertActionLog(actionType);
            handler.doHandle();
            result = 1;
        }
        catch (Exception e) {
            try {
                result = -1;
                remark = e.getMessage();
                ExceptionLogger.error(TransCoordinatorServiceImpl.class, (String)("KdtxMonitorLog TransCoordinatorService handel err -- actionType: " + actionType + " xid: " + this.getXid()));
                throw e;
            }
            catch (Throwable throwable) {
                TCCDBLogger.updateActionLog(logId, actionType, result, remark);
                throw throwable;
            }
        }
        TCCDBLogger.updateActionLog(logId, actionType, result, remark);
    }

    private void setContext(ActionType actionType, String txCode, String branchCode, String txType, TxBusinessInfo txBusinessInfo) throws Exception {
        TcContext tcContext = TcContext.getOrCreate();
        if (actionType != null) {
            tcContext.setActionType(actionType);
        }
        if (!StringUtils.isEmpty((String)txCode)) {
            tcContext.setTxCode(txCode);
        }
        if (!StringUtils.isEmpty((String)branchCode)) {
            tcContext.setBranchCode(branchCode);
        }
        if (!StringUtils.isEmpty((String)txType)) {
            tcContext.setTxType(txType);
        }
        if (txBusinessInfo != null) {
            if (!CollectionUtils.isEmpty((Collection)txBusinessInfo.getBusinessIds())) {
                tcContext.setContextBusinessIds(txBusinessInfo.getBusinessIds());
            }
            if (!StringUtils.isEmpty((String)txBusinessInfo.getFbusinessType())) {
                tcContext.setContextBusinessType(txBusinessInfo.getFbusinessType());
            }
        }
        if (ActionType.TX_BEGIN == actionType) {
            return;
        }
        if (ActionType.BRANCH_REGISTER == actionType || ActionType.BRANCH_REPORT == actionType || ActionType.CASCADE_BRANCH_REGISTER == actionType) {
            String bid = KdtxRequestContext.get().getBranchId();
            if (bid == null) {
                throw new KdtxException(DtxErrorCodeConstants.BRANCHID_EMPTY.getErrorMessage() + "txCode: " + txCode + " branchCode: " + branchCode);
            }
            tcContext.setBranchId(bid);
        }
        if (TcContext.get().getXid() == null) {
            String xid = KdtxRequestContext.get().getXid();
            if (xid == null) {
                throw new KdtxException(DtxErrorCodeConstants.XID_EMPTY.getErrorMessage() + "actionType: " + actionType);
            }
            this.assertXIDIfExist(xid);
            tcContext.setXid(xid);
        }
    }

    private void assertXIDIfExist(String xid) throws Exception {
        if (!this.isExist(xid)) {
            throw new KdtxException(DtxErrorCodeConstants.XID_NOT_EXISTS.getErrorMessage() + "xid: " + xid);
        }
    }

    private boolean isExist(String xid) {
        String querySql = "SELECT COUNT(1) FROM t_cbs_dtx_transaction WHERE fxid = ?";
        Object[] params = new Object[]{xid};
        int count = (Integer)DB.query((DBRoute)DBRoute.base, (String)querySql, (Object[])params, rs -> {
            rs.next();
            return rs.getInt(1);
        });
        return count > 0;
    }

    private String getXid() {
        TcContext tcContext = TcContext.get();
        String xid = tcContext != null && StringUtils.isNotEmpty((String)TcContext.get().getXid()) ? TcContext.get().getXid() : KdtxRequestContext.get().getXid();
        return xid;
    }

    private static interface TcHandler {
        public void doHandle() throws Exception;
    }
}

