/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.KdtxRequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.common.dto.TxInvokerAttachment;
import kd.bos.kdtx.common.entity.BranchExecuteInfo;
import kd.bos.kdtx.common.entity.CallbackInfo;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.invoke.DtxBranch;
import kd.bos.kdtx.common.invoke.DtxGlobalResult;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.common.invoke.DtxResult;
import kd.bos.kdtx.common.util.JsonUtils;
import kd.bos.kdtx.server.tx.MultiDBWriteHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.support.partition.PartitionStrategy;
import kd.bos.util.StringUtils;

public class TxCommonService {
    private static final Log logger = LogFactory.getLog(TxCommonService.class);
    private static final String CALLBACK_PATTERN = "#";

    public static void setCallback(TxInvokerAttachment txInvokerAttachment) {
        String xid = KdtxRequestContext.get().getXid();
        CallbackInfo callbackInfo = txInvokerAttachment == null ? null : txInvokerAttachment.getCallbackInfo();
        try {
            if (callbackInfo != null) {
                String callbackStr = (callbackInfo.isInnerClass() ? 1 : 0) + CALLBACK_PATTERN + callbackInfo.getAppId() + CALLBACK_PATTERN + callbackInfo.getClassName();
                MultiDBWriteHandler.execute(() -> {
                    String sql = "update t_cbs_dtx_transaction set fcallback=? where fxid=?";
                    DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{callbackStr, xid});
                    return 1;
                });
            }
        }
        catch (Exception e) {
            logger.error("save callback info error:", (Throwable)e);
            throw new KdtxException("save callback info error:" + e.getMessage(), (Throwable)e);
        }
    }

    public static String getCallbackInfo(String xid) {
        String sql = "select fcallback from t_cbs_dtx_transaction where fxid=?";
        return (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{xid}, rs -> {
            String callbackInfo = null;
            if (rs.next()) {
                callbackInfo = rs.getString(1);
            }
            return callbackInfo;
        });
    }

    public static void callback(String xid, boolean commited, boolean rollbacked) {
        String callbackInfo = TxCommonService.getCallbackInfo(xid);
        if (StringUtils.isNotEmpty((String)callbackInfo)) {
            try (MessagePublisher publisher = MQFactory.get().createPartitionPublisher("kdtx", "callback", PartitionStrategy.APP_ID);){
                String isInnerClass = callbackInfo.split(CALLBACK_PATTERN)[0];
                String appId = callbackInfo.split(CALLBACK_PATTERN)[1];
                String className = callbackInfo.split(CALLBACK_PATTERN)[2];
                DtxResult result = new DtxResult();
                result.setCallbackClassName(className);
                result.setInnerClass("1".equals(isInnerClass));
                result.setXid(xid);
                DtxGlobalResult globalResult = new DtxGlobalResult();
                globalResult.setCommitted(commited);
                globalResult.setRollbacked(rollbacked);
                result.setDtxGlobalResult(globalResult);
                String branchSql = "SELECT fseq,fresource,fresult FROM t_cbs_dtx_branch WHERE fxid = ? ";
                List branches = (List)DB.query((DBRoute)DBRoute.basedata, (String)branchSql, (Object[])new Object[]{xid}, rs -> {
                    ArrayList<DtxBranch> tempBrancs = new ArrayList<DtxBranch>(4);
                    while (rs.next()) {
                        DtxBranch branch = new DtxBranch();
                        branch.setRegistrySeq(rs.getInt("fseq"));
                        branch.setResource(rs.getString("fresource"));
                        byte[] param = rs.getBytes("fresult");
                        DtxResponse response = null;
                        if (param != null) {
                            response = (DtxResponse)JsonUtils.deSerialization((byte[])param);
                        }
                        branch.setDtxResponse(response);
                        tempBrancs.add(branch);
                    }
                    return tempBrancs;
                });
                result.setBranchList(branches);
                publisher.publish((Object)result, appId);
                logger.info("kdtx callback success for xid " + xid);
            }
        }
    }

    public static Map<String, List<BranchExecuteInfo>> queryRelativeTxBranchExecuteInfos(String businessId) {
        HashMap<String, List<BranchExecuteInfo>> xidBranchExecuteInfo = new HashMap<String, List<BranchExecuteInfo>>(8);
        List<String> relativeTxs = TxCommonService.queryRelativeTx(businessId);
        for (String xid : relativeTxs) {
            List<BranchExecuteInfo> branchExecuteInfo = TxCommonService.queryTxBranchExecuteInfo(xid);
            xidBranchExecuteInfo.put(xid, branchExecuteInfo);
        }
        return xidBranchExecuteInfo;
    }

    private static List<BranchExecuteInfo> queryTxBranchExecuteInfo(String xid) {
        ArrayList<BranchExecuteInfo> branchExecuteInfos = new ArrayList<BranchExecuteInfo>(4);
        if (StringUtils.isEmpty((String)xid)) {
            return branchExecuteInfos;
        }
        String branchSql = "select br.fxid, br.fbranch_id, br.fstatus, br.fseq, sc.fcode, sc.fname, lo.fremark, lo.fresult from t_cbs_dtx_branch br left join t_cbs_dtx_branch_scenes sc on br.fscenes_branch_id = sc.fentryid left join t_cbs_dtx_logs lo on br.fbranch_id = lo.fbranch_id where br.fxid = ? order by lo.fcreate_time desc,lo.fresult";
        DB.query((DBRoute)DBRoute.basedata, (String)branchSql, (Object[])new Object[]{xid}, rs -> {
            HashSet<String> branchIds = new HashSet<String>(4);
            while (rs.next()) {
                String branchId = rs.getString("fbranch_id");
                if (!branchIds.add(branchId)) continue;
                BranchExecuteInfo branchExecuteInfo = new BranchExecuteInfo();
                branchExecuteInfo.setXid(rs.getString("fxid"));
                branchExecuteInfo.setBranchId(branchId);
                int status = rs.getInt("fstatus");
                String statusDes = "";
                try {
                    GlobalTxStatus globalTxStatus = GlobalTxStatus.get((int)status);
                    statusDes = globalTxStatus.getName();
                }
                catch (Exception globalTxStatus) {
                    // empty catch block
                }
                branchExecuteInfo.setBranchStatus(status);
                branchExecuteInfo.setBranchStatusDesc(statusDes);
                branchExecuteInfo.setSeq(rs.getInt("fseq"));
                branchExecuteInfo.setBranchSceneCode(rs.getString("fcode"));
                branchExecuteInfo.setBranchSceneName(rs.getString("fname"));
                int logResult = rs.getInt("fresult");
                String logLastedRemark = rs.getString("fremark");
                if (logResult == -1 && StringUtils.isNotEmpty((String)logLastedRemark)) {
                    branchExecuteInfo.setBranchError(logLastedRemark);
                }
                branchExecuteInfos.add(branchExecuteInfo);
            }
            return null;
        });
        return branchExecuteInfos;
    }

    private static List<String> queryRelativeTx(String businessId) {
        if (StringUtils.isEmpty((String)businessId)) {
            return null;
        }
        String sql = "select fxid from t_cbs_dtx_business where fbusiness_id = ? order by fcreate_time desc";
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{businessId}, rs -> {
            ArrayList<String> xids = new ArrayList<String>(1);
            while (rs.next()) {
                xids.add(rs.getString("fxid"));
            }
            return xids;
        });
    }
}

