/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.state.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import kd.bos.context.KdtxRequestContext;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.constant.BranchStatus;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.common.constant.InvokeType;
import kd.bos.kdtx.common.entity.TxBranchInfo;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.invoke.factory.InvokerFactory;
import kd.bos.kdtx.server.log.TCCDBLogger;
import kd.bos.kdtx.server.state.adapter.UpdateBranchAdapter;

public class RollbackingState
extends UpdateBranchAdapter {
    public RollbackingState() {
        this.name = GlobalTxStatus.ROLLBACKING.getName();
        this.state = GlobalTxStatus.ROLLBACKING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws Exception {
        String rollbackingXid = KdtxRequestContext.get().getXid();
        try {
            this.rollbackingMapAdd(rollbackingXid);
            boolean shouldFail = false;
            ArrayList<String> failBranchIds = new ArrayList<String>(4);
            BranchStatus[] prrStatus = new BranchStatus[]{BranchStatus.PREPARING, BranchStatus.ROLLBACK_FAILED, BranchStatus.ROLLBACKING};
            BranchStatus[] rollbackingStatus = new BranchStatus[]{BranchStatus.ROLLBACKING};
            for (TxBranchInfo txBranchInfo : this.queryBranches(BranchStatus.PREPARING, BranchStatus.ROLLBACK_FAILED, BranchStatus.ROLLBACKING)) {
                long sid = txBranchInfo.getId();
                this.updateBranch(sid, BranchStatus.ROLLBACKING, prrStatus);
                long logId = TCCDBLogger.insertActionLog(ActionType.BRANCH_ROLLBACK, txBranchInfo.getBranchId());
                KdtxRequestContext.get().setBranchId(txBranchInfo.getBranchId());
                int result = 0;
                String remark = null;
                try {
                    if (DtxType.TCC.getCode() == this.getTxType()) {
                        this.invoke(txBranchInfo.getParas(), txBranchInfo.getParasBytes());
                    }
                    result = 1;
                }
                catch (Exception e) {
                    try {
                        result = -1;
                        remark = e.getMessage();
                        this.updateBranch(sid, BranchStatus.ROLLBACK_FAILED, rollbackingStatus);
                        shouldFail = true;
                        failBranchIds.add(txBranchInfo.getBranchId());
                        ExceptionLogger.error(RollbackingState.class, (String)("KdtxMonitorLog branch rollback! xid: " + txBranchInfo.getXid() + " branchId: " + txBranchInfo.getBranchId()), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        TCCDBLogger.updateActionLog(logId, ActionType.BRANCH_ROLLBACK, result, remark);
                        throw throwable;
                    }
                    TCCDBLogger.updateActionLog(logId, ActionType.BRANCH_ROLLBACK, result, remark);
                    continue;
                }
                TCCDBLogger.updateActionLog(logId, ActionType.BRANCH_ROLLBACK, result, remark);
                this.updateBranch(sid, BranchStatus.ROLLBACKED, rollbackingStatus);
            }
            KdtxRequestContext.get().setBranchId(null);
            if (shouldFail) {
                throw new KdtxException("branch rollback failed! Fail branch id: " + ((Object)failBranchIds).toString());
            }
        }
        finally {
            this.rollbackingMapRemove(rollbackingXid);
        }
    }

    private void invoke(String paras, byte[] parasBytes) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        DtxParas tccParas = (DtxParas)objectMapper.readValue(paras, DtxParas.class);
        tccParas.setParasBytes(parasBytes);
        InvokerFactory.getTCCInvoker((InvokeType)InvokeType.BRANCH_ROLLBACK).doInvoke(tccParas);
    }
}

