/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.tasks;

import com.google.common.base.Joiner;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.server.config.TransCoordinatorConfig;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class HistoryCleaner {
    private static final long LIMIT = 1000L;
    private static final Log logger = LogFactory.getLog(HistoryCleaner.class);

    public void clean() throws Exception {
        this.clean((routeKey, expiredList) -> {
            String deleteSql;
            boolean ret;
            if (expiredList != null && ((Object[])expiredList).length > 0 && (ret = this.deleteExpiredData((Object[])expiredList, deleteSql = "DELETE FROM t_cbs_dtx_transaction WHERE fxid IN (%s)", DBRoute.basedata))) {
                deleteSql = "DELETE FROM t_cbs_dtx_branch WHERE fxid IN (%s)";
                this.deleteExpiredData((Object[])expiredList, deleteSql, DBRoute.basedata);
                deleteSql = "DELETE FROM t_cbs_dtx_logs WHERE fxid IN (%s)";
                this.deleteExpiredData((Object[])expiredList, deleteSql, DBRoute.basedata);
                deleteSql = "DELETE FROM t_cbs_dtx_retry_stat WHERE fxid IN (%s)";
                this.deleteExpiredData((Object[])expiredList, deleteSql, DBRoute.basedata);
                deleteSql = "DELETE FROM t_cbs_dtx_tcc_section WHERE fxid IN (%s)";
                this.deleteExpiredData((Object[])expiredList, deleteSql, DBRoute.basedata);
                deleteSql = "DELETE FROM t_cbs_dtx_business WHERE fxid IN (%s)";
                this.deleteExpiredData((Object[])expiredList, deleteSql, DBRoute.basedata);
                deleteSql = "DELETE FROM t_dtx_local_tx_log WHERE fxid IN (%s)";
                if (StringUtils.isNotEmpty((String)routeKey)) {
                    try {
                        this.deleteExpiredData((Object[])expiredList, deleteSql, DBRoute.of((String)routeKey));
                    }
                    catch (Exception e) {
                        logger.warn((Throwable)e);
                    }
                }
                deleteSql = "DELETE FROM t_dtx_local_tcc WHERE fxid IN (%s)";
                if (StringUtils.isNotEmpty((String)routeKey)) {
                    try {
                        this.deleteExpiredData((Object[])expiredList, deleteSql, DBRoute.of((String)routeKey));
                    }
                    catch (Exception e) {
                        logger.warn((Throwable)e);
                    }
                }
            }
        });
    }

    private void clean(BiConsumer<String, Object[]> cleaner) {
        String whereSql = "WHERE (DATEADD(now(), -" + this.getExpiredSeconds() + ") > ts.fupdate_time) and((ts.fstatus in (4, 5, 8) and ts.ftx_type !=2)  or (ts.ftx_type =2 and fsecondstatus in(2,5) and  ts.fxid not in (select rs.fxid from t_cbs_dtx_retry_stat  rs where rs.fseq>=0 and rs.fstatus=0)))";
        String countSql = "SELECT count(ts.fid) FROM t_cbs_dtx_transaction ts " + whereSql;
        String selectSql = "SELECT TOP 1000, %d ts.fxid ,ts.froutekey FROM t_cbs_dtx_transaction ts " + whereSql + "ORDER BY fupdate_time";
        this.clean(countSql, selectSql, cleaner);
    }

    private void clean(String countSql, String selectSql, BiConsumer<String, Object[]> cleaner) {
        long count = (Long)DB.query((DBRoute)DBRoute.base, (String)countSql, null, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getLong(1);
                }
                return 0L;
            }
        });
        if (count == 0L) {
            return;
        }
        long totalPage = (count - 1L) / 1000L + 1L;
        for (long curPage = 1L; curPage <= totalPage; ++curPage) {
            String exeSql = String.format(selectSql, 0);
            HashMap<String, List> transactionInfo = new HashMap<String, List>();
            try (DataSet ds = DB.queryDataSet((String)"HistoryCleaner", (DBRoute)DBRoute.base, (String)exeSql, null);){
                for (Row row : ds) {
                    String routeKey = row.getString("froutekey");
                    transactionInfo.computeIfAbsent(routeKey, key -> new ArrayList()).add(row.getString("fxid"));
                }
            }
            catch (Exception e) {
                ExceptionLogger.error(HistoryCleaner.class, (String)"SELECT t_cbs_dtx_transaction error. loop continue", (Throwable)e);
                continue;
            }
            if (transactionInfo.size() == 0) continue;
            for (String routeKey : transactionInfo.keySet()) {
                cleaner.accept(routeKey, ((List)transactionInfo.get(routeKey)).toArray());
            }
        }
    }

    private String constructPlaceHolder(int len) {
        ArrayList<String> placeHolders = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            placeHolders.add("?");
        }
        return Joiner.on((String)",").join(placeHolders);
    }

    private boolean deleteExpiredData(Object[] expiredList, String deleteSql, DBRoute dbRoute) {
        String exeSql = String.format(deleteSql, this.constructPlaceHolder(expiredList.length));
        DB.execute((DBRoute)dbRoute, (String)exeSql, (Object[])expiredList);
        return true;
    }

    private long getExpiredSeconds() {
        return (long)TransCoordinatorConfig.getTaskClearExpiredTime() * TimeUnit.DAYS.toSeconds(1L);
    }

    public static void cleanSimpleECHistory(String xid) {
        String needDeleteSql = "SELECT ts.froutekey FROM t_cbs_dtx_transaction ts where ts.fxid=? and ts.ftx_type =2 and ts.fsecondstatus in(2,5) and ts.fxid not in (select rs.fxid from t_cbs_dtx_retry_stat  rs where rs.fseq>=0  and rs.fstatus=0)";
        String routeKey = (String)DB.query((DBRoute)DBRoute.basedata, (String)needDeleteSql, (Object[])new Object[]{xid}, rs -> rs.next() ? rs.getString(1) : null);
        if (routeKey != null) {
            HistoryCleaner.clean(routeKey, xid);
        }
    }

    private static void clean(String routeKey, String xid) {
        String deleteSql = "DELETE FROM t_cbs_dtx_transaction WHERE fxid =?";
        boolean ret = DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])new Object[]{xid});
        if (ret) {
            deleteSql = "DELETE FROM t_dtx_local_tx_log WHERE fxid = ?";
            DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)deleteSql, (Object[])new Object[]{xid});
            deleteSql = "DELETE FROM t_cbs_dtx_branch WHERE fxid = ?";
            DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])new Object[]{xid});
            deleteSql = "DELETE FROM t_cbs_dtx_logs WHERE fxid = ?";
            DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])new Object[]{xid});
            deleteSql = "DELETE FROM t_cbs_dtx_retry_stat WHERE fxid = ?";
            DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])new Object[]{xid});
            deleteSql = "DELETE FROM t_cbs_dtx_tcc_section WHERE fxid = ?";
            DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])new Object[]{xid});
            deleteSql = "DELETE FROM t_cbs_dtx_business WHERE fxid= ?";
            DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])new Object[]{xid});
        }
    }
}

