/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.tasks;

import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.idemponent.storage.IdempotentStorageHelper;
import kd.bos.kdtx.server.tasks.template.LockTemplate;
import kd.bos.util.StringUtils;

public class IdempotentRecordCleaner
extends LockTemplate {
    private static final String MC_IDEM_DBROUTE_LIST_KEY = "idem.dbroute.list";
    private static final String THREAD_NAME = "IdempotentRecordCleaner-Thread";
    private static final String LOCK_KEY = "kdtx.clean.idempotent-task";

    public IdempotentRecordCleaner() {
        super.setThreadName(THREAD_NAME);
        super.setLockKey(LOCK_KEY);
    }

    @Override
    protected void execute() {
        String[] dbRoutes;
        String tenantId = RequestContext.get().getTenantId();
        String key = tenantId + "_" + MC_IDEM_DBROUTE_LIST_KEY;
        String property = System.getProperty(key);
        if (StringUtils.isEmpty((String)property)) {
            return;
        }
        for (String dbRoute : dbRoutes = property.split(",")) {
            try {
                IdempotentStorageHelper.cleanHistory((DBRoute)DBRoute.of((String)dbRoute));
            }
            catch (Exception e) {
                ExceptionLogger.error(IdempotentRecordCleaner.class, (String)"delete idempotent record error.", (Throwable)e);
            }
        }
    }
}

