/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.tasks;

import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.framework.lifecycle.Service;
import kd.bos.kdtx.common.util.AppUtils;
import kd.bos.kdtx.server.config.TransCoordinatorConfig;
import kd.bos.kdtx.server.tasks.ArchiveReporterTask;
import kd.bos.kdtx.server.tasks.AutoCompensateTask;
import kd.bos.kdtx.server.tasks.CleanUpTask;
import kd.bos.kdtx.server.tasks.CommitTask;
import kd.bos.kdtx.server.tasks.PrepareTask;
import kd.bos.kdtx.server.tasks.RollbackTask;

public class KdtxTaskService
implements Service {
    private static final int THREAD_POOL_COUNT = 6;
    private static final int DELAY = 60;
    private static final String SWITCH = "kdtx.task.force.on";

    public String getName() {
        return "kdtx-task-service";
    }

    public void start() {
        if (!this.shouldFireTask()) {
            return;
        }
        ScheduledExecutorService ses = Executors.newScheduledThreadPool(6);
        ses.scheduleWithFixedDelay(new PrepareTask(), 0L, TransCoordinatorConfig.getTaskDelay(), TimeUnit.SECONDS);
        ses.scheduleWithFixedDelay(new CommitTask(), 20L, TransCoordinatorConfig.getTaskDelay(), TimeUnit.SECONDS);
        ses.scheduleWithFixedDelay(new RollbackTask(), TransCoordinatorConfig.getTaskDelay() * 2 / 3, TransCoordinatorConfig.getTaskDelay(), TimeUnit.SECONDS);
        ses.scheduleAtFixedRate(new CleanUpTask(), this.getInitialDelay(), TimeUnit.DAYS.toSeconds(1L), TimeUnit.SECONDS);
        ses.scheduleAtFixedRate(new ArchiveReporterTask(), this.getInitialDelay(), TimeUnit.DAYS.toSeconds(1L), TimeUnit.SECONDS);
        if (Boolean.parseBoolean(System.getProperty("kdtx.homeless.on", "true"))) {
            ses.scheduleAtFixedRate(new AutoCompensateTask(), TransCoordinatorConfig.getAutoCompensateTaskDelay(), TransCoordinatorConfig.getAutoCompensateTaskDelay(), TimeUnit.SECONDS);
        }
    }

    public void stop() {
    }

    public boolean isStarted() {
        return true;
    }

    private long getInitialDelay() {
        ZonedDateTime nextRun;
        ZonedDateTime now = ZonedDateTime.now();
        if (now.compareTo(nextRun = now.withHour(TransCoordinatorConfig.getTriggerHour()).withMinute(0).withSecond(0)) > 0) {
            nextRun = nextRun.plusDays(1L);
        }
        Duration duration = Duration.between(now, nextRun);
        return duration.getSeconds();
    }

    private boolean isLocalEvnDebug() {
        List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String arg : args) {
            if (!arg.startsWith("-agentlib:jdwp")) continue;
            return true;
        }
        return false;
    }

    private boolean shouldFireTask() {
        boolean forceFire;
        boolean fire = AppUtils.isTCCServer();
        if (fire && !(forceFire = Boolean.parseBoolean(System.getProperty(SWITCH, "false"))) && this.isLocalEvnDebug()) {
            fire = false;
        }
        return fire;
    }
}

