/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.tasks;

import java.util.Map;
import java.util.TreeSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.KdtxRequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.constant.DtxModel;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.entity.TxInfo;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.localtx.LocalTxDbHelper;
import kd.bos.kdtx.common.localtx.LocalTxLog;
import kd.bos.kdtx.common.mq.PublishManager;
import kd.bos.kdtx.common.param.BranchActionParam;
import kd.bos.kdtx.common.util.JsonUtils;
import kd.bos.kdtx.server.config.TransCoordinatorConfig;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.service.impl.TransCoordinatorServiceImpl;
import kd.bos.kdtx.server.tasks.template.StatusTemplate;
import kd.bos.mq.MessagePublisher;
import kd.bos.util.StringUtils;

public class PrepareTask
extends StatusTemplate {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("kdtx", new DistributeCacheHAPolicy(true, false));
    private static final String THREAD_NAME = "PrepareTask-Thread";
    private static final String LOCK_KEY = "kdtx.prepare-task";
    private static final String SQL_ROUTE_KEY = "select ts.froutekey from t_cbs_dtx_transaction  tc left join t_cbs_dtx_tx_scenes  ts on tc.fscenes_tx_id=ts.fid where tc.fxid=?";

    public PrepareTask() {
        super.setThreadName(THREAD_NAME);
        super.setLockKey(LOCK_KEY);
        this.setSql();
    }

    @Override
    protected final void setSql() {
        this.selectSql = "SELECT trs.fid as trs_fid, trs.fxid as fxid, trs.ftx_type as ftx_type, trs.ftenant_id as ftenant_id, trs.faccount_id as faccount_id, trs.fcreate_time as fcreate_time, trs.fupdate_time as fupdate_time, trs.froutekey as froutekey, trs.fserializer as fserializer, trs.fcontext as fcontext, rs.fid as rs_fid, ISNULL(rs.fcommit_retry_count, 0) as commit_retry_count, ISNULL(rs.frollback_retry_count, 0) as rollback_retry_count FROM t_cbs_dtx_transaction trs LEFT JOIN t_cbs_dtx_retry_stat rs on rs.fxid = trs.fxid and rs.ftrigger_type = 3 WHERE trs.fstatus = 1 and (DATEADD(now(), -" + TransCoordinatorConfig.getTaskPrepareTimeout() + ") > trs.fupdate_time)";
    }

    @Override
    protected void recordRetryInfo(TxInfo txDo) {
    }

    @Override
    protected void doJob(TxInfo txInfo) {
        KdtxRequestContext.get().setXid(txInfo.getFxid());
        TcContext.getOrCreate().setXid(txInfo.getFxid());
        TcContext.getOrCreate().setTaskRetry(true);
        TcContext.getOrCreate().setTxType(txInfo.getFtxType() + "");
        if (txInfo.getFtxType() == DtxType.TCC.getCode()) {
            TransCoordinatorServiceImpl transCoordinatorService = new TransCoordinatorServiceImpl();
            try {
                if (this.isTccLocalTxCommitted(txInfo)) {
                    transCoordinatorService.proxyHandleTx(ActionType.TX_COMMIT, null);
                } else {
                    String longTryFlag = (String)cache.get("kdtx_branchLongTry_" + txInfo.getFxid());
                    if (StringUtils.isEmpty((String)longTryFlag)) {
                        transCoordinatorService.proxyHandleTx(ActionType.TX_ROLLBACK, null);
                    }
                }
            }
            catch (Exception e) {
                ExceptionLogger.error(PrepareTask.class, (String)"handle kdtx rollback error.", (Throwable)e);
            }
        } else if (txInfo.getFtxType() == DtxType.EC.getCode() || txInfo.getFtxType() == DtxType.SIMPLEEC.getCode()) {
            Map<String, String> sceneInfo = this.getSceneInfo(txInfo.getFxid());
            String routeKey = sceneInfo.get("routeKey");
            this.doConsistent(routeKey, txInfo.getFxid(), sceneInfo.get("txCode"), sceneInfo.get("model"), txInfo.getFtxType() + "");
        }
    }

    @Override
    protected void warn(TxInfo txDo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConsistent(String routeKey, String xid, String txCode, String model, String txType) {
        try (MessagePublisher publisher = null;){
            TransCoordinatorServiceImpl transCoordinatorService = new TransCoordinatorServiceImpl();
            if (StringUtils.isEmpty((String)routeKey)) {
                transCoordinatorService.proxyHandleTx(ActionType.TX_ROLLBACK, null);
                ExceptionLogger.error(PrepareTask.class, (String)"dtx doConsistent error. routeKey is null, xid [{}] ,will rollback ", (Object[])new Object[]{xid});
                return;
            }
            TreeSet localTxLogs = LocalTxDbHelper.getLocalTxLogList((DBRoute)DBRoute.of((String)routeKey), (String)xid, null);
            if (localTxLogs != null && localTxLogs.size() > 0 && StringUtils.isNotEmpty((String)routeKey)) {
                for (LocalTxLog localTxLog : localTxLogs) {
                    String branchId = Long.toString(ID.genLongId());
                    KdtxRequestContext.get().setBranchId(branchId);
                    DtxParas dtxParas = new DtxParas();
                    dtxParas.setCloudId(localTxLog.getCloudId());
                    dtxParas.setAppId(localTxLog.getAppId());
                    dtxParas.setResource(localTxLog.getResource());
                    dtxParas.setParamType(localTxLog.getParaType());
                    dtxParas.setParam(localTxLog.getParas());
                    dtxParas.setSceneCode(txCode);
                    dtxParas.setBranchCode(localTxLog.getCode());
                    dtxParas.setBizId(localTxLog.getBizId());
                    dtxParas.setSeq(localTxLog.getSeq());
                    dtxParas.setTotalBranch(localTxLogs.size());
                    dtxParas.setTaskRetry(true);
                    dtxParas.setTxType(txType);
                    dtxParas.setParasBytes(localTxLog.getParaBytes());
                    dtxParas.setLocalStatus(localTxLog.getStatus());
                    if (DtxModel.MQ.getCode().equals(model)) {
                        if (publisher == null) {
                            publisher = PublishManager.getPublisher((String)txCode);
                        }
                        dtxParas.setXid(xid);
                        publisher.publish((Object)dtxParas, dtxParas.getAppId());
                        continue;
                    }
                    BranchActionParam param = new BranchActionParam();
                    param.setResource(localTxLog.getResource());
                    param.setTxCode(txCode);
                    param.setBranchCode(localTxLog.getCode());
                    param.setSeq(localTxLog.getSeq());
                    param.setBizId(localTxLog.getBizId());
                    param.setParasBytes(localTxLog.getParaBytes());
                    dtxParas.setParasBytes(null);
                    param.setParas(JsonUtils.getParasStr((Object)dtxParas));
                    param.setLocalStatus(localTxLog.getStatus());
                    transCoordinatorService.proxyHandleBranch(ActionType.BRANCH_REGISTER, param);
                }
                if (!DtxModel.MQ.getCode().equals(model)) {
                    transCoordinatorService.proxyHandleTx(ActionType.TX_COMMIT, null);
                }
            } else {
                transCoordinatorService.proxyHandleTx(ActionType.TX_ROLLBACK, null);
            }
        }
    }

    private boolean isTccLocalTxCommitted(TxInfo txInfo) {
        String routeKey = txInfo.getRouteKey();
        if (StringUtils.isEmpty((String)routeKey)) {
            return false;
        }
        String sql = "SELECT fid FROM t_dtx_local_tcc WHERE fxid = ?";
        Object[] param = new Object[]{txInfo.getFxid()};
        return (Boolean)DB.query((DBRoute)DBRoute.of((String)routeKey), (String)sql, (Object[])param, rs -> {
            if (rs.next()) {
                return true;
            }
            return false;
        });
    }
}

