/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.tasks;

import java.util.concurrent.ConcurrentHashMap;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.server.state.AccountInfo;
import kd.bos.kdtx.server.state.BaseTcState;
import kd.bos.kdtx.server.tasks.AbstractReportTask;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ReportRollbackingTask
extends AbstractReportTask {
    private static final Log logger = LogFactory.getLog(ReportRollbackingTask.class);

    @Override
    public void run() {
        try {
            ConcurrentHashMap<String, AccountInfo> rollbackingMap = BaseTcState.getRollbackingMap();
            if (rollbackingMap == null || rollbackingMap.size() == 0) {
                return;
            }
            ConcurrentHashMap<String, AccountInfo> reportMap = new ConcurrentHashMap<String, AccountInfo>();
            reportMap.putAll(rollbackingMap);
            this.report(reportMap, GlobalTxStatus.ROLLBACKING);
        }
        catch (Exception e) {
            logger.error("ReportRollbackingTask error.", (Throwable)e);
        }
    }
}

