/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.tasks;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.kdtx.server.constant.SqlFragment;

public class ReporterArchivist {
    public void archive() {
        try (TXHandle txHandle = TX.required();){
            try {
                this.fixCrossDayNotRepair();
                this.saveNotRepairXid();
                this.saveArchiveInfo();
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }

    private void fixCrossDayNotRepair() {
        ArrayList fixOpParam = new ArrayList(10);
        ArrayList delOpParam = new ArrayList(10);
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)SqlFragment.CROSS_DAY_REPAIR, rs -> {
            while (rs.next()) {
                String xid = rs.getString("xid");
                Timestamp createDate = rs.getTimestamp("create_date");
                LocalDate archiveDate = LocalDate.from(createDate.toLocalDateTime());
                long sceneId = rs.getLong("sceneId");
                delOpParam.add(new Object[]{xid});
                fixOpParam.add(new Object[]{sceneId, archiveDate});
            }
            return null;
        });
        if (!fixOpParam.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)SqlFragment.FIX_NOT_REPAIR, fixOpParam);
            DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)SqlFragment.DELETE_REPAIRED, delOpParam);
        }
    }

    private List<Object[]> getNotRepairXid() {
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        Object[] dateRange = this.getDateRange();
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)SqlFragment.NOT_REPAIR_XID, (Object[])dateRange, rs -> {
            while (rs.next()) {
                long id = this.generateFid(SqlFragment.NOT_REPAIR_TABLE);
                String xid = rs.getString("xid");
                Timestamp createDate = rs.getTimestamp("create_date");
                Object[] result = new Object[]{id, xid, createDate};
                results.add(result);
            }
            return null;
        });
        return results;
    }

    private Object[] getDateRange() {
        LocalDate nowDate = LocalDate.now();
        LocalDate preDate = nowDate.minusDays(1L);
        Timestamp lastArchiveDate = (Timestamp)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)SqlFragment.LAST_ARCHIVE_DATE, rs -> {
            Timestamp timestamp = null;
            while (rs.next()) {
                timestamp = rs.getTimestamp("lastDate");
            }
            return timestamp;
        });
        if (lastArchiveDate != null) {
            preDate = LocalDate.from(lastArchiveDate.toLocalDateTime().plusDays(1L));
        }
        return new Object[]{preDate, nowDate};
    }

    private Map<String, ArchiveInfo> getSceneViewInfo() {
        HashMap<String, ArchiveInfo> resultMap = new HashMap<String, ArchiveInfo>();
        Object[] params = this.getDateRange();
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)SqlFragment.TOTAL_COUNT, (Object[])params, rs -> {
            while (rs.next()) {
                String sceneId = rs.getString("sceneId");
                if (resultMap.containsKey(sceneId)) {
                    ((ArchiveInfo)resultMap.get(sceneId)).setTotal(rs.getInt("totals"));
                    continue;
                }
                ArchiveInfo archiveInfo = new ArchiveInfo();
                archiveInfo.setTotal(rs.getInt("totals"));
                resultMap.put(sceneId, archiveInfo);
            }
            return null;
        });
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)SqlFragment.SUCCESS_COUNT, (Object[])params, rs -> {
            while (rs.next()) {
                String sceneId = rs.getString("sceneId");
                if (resultMap.containsKey(sceneId)) {
                    ((ArchiveInfo)resultMap.get(sceneId)).setSuccess(rs.getInt("successes"));
                    continue;
                }
                ArchiveInfo archiveInfo = new ArchiveInfo();
                archiveInfo.setSuccess(rs.getInt("successes"));
                resultMap.put(sceneId, archiveInfo);
            }
            return null;
        });
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)SqlFragment.EXCEPTION_COUNT, (Object[])params, rs -> {
            while (rs.next()) {
                String sceneId = rs.getString("sceneId");
                if (resultMap.containsKey(sceneId)) {
                    ((ArchiveInfo)resultMap.get(sceneId)).setException(rs.getInt("exceptions"));
                    continue;
                }
                ArchiveInfo archiveInfo = new ArchiveInfo();
                archiveInfo.setException(rs.getInt("exceptions"));
                resultMap.put(sceneId, archiveInfo);
            }
            return null;
        });
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)SqlFragment.ROLLBACK_COUNT, (Object[])params, rs -> {
            while (rs.next()) {
                String sceneId = rs.getString("sceneId");
                if (resultMap.containsKey(sceneId)) {
                    ((ArchiveInfo)resultMap.get(sceneId)).setRollback(rs.getInt("rollbacks"));
                    continue;
                }
                ArchiveInfo archiveInfo = new ArchiveInfo();
                archiveInfo.setRollback(rs.getInt("rollbacks"));
                resultMap.put(sceneId, archiveInfo);
            }
            return null;
        });
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)SqlFragment.AUTO_REPAIR_COUNT, (Object[])params, rs -> {
            while (rs.next()) {
                String sceneId = rs.getString("sceneId");
                if (resultMap.containsKey(sceneId)) {
                    ((ArchiveInfo)resultMap.get(sceneId)).setAutoRepair(rs.getInt("autoRepairs"));
                    continue;
                }
                ArchiveInfo archiveInfo = new ArchiveInfo();
                archiveInfo.setAutoRepair(rs.getInt("autoRepairs"));
                resultMap.put(sceneId, archiveInfo);
            }
            return null;
        });
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)SqlFragment.MANUAL_REPAIR_COUNT, (Object[])params, rs -> {
            while (rs.next()) {
                String sceneId = rs.getString("sceneId");
                if (resultMap.containsKey(sceneId)) {
                    ((ArchiveInfo)resultMap.get(sceneId)).setManualRepair(rs.getInt("manualRepairs"));
                    continue;
                }
                ArchiveInfo archiveInfo = new ArchiveInfo();
                archiveInfo.setManualRepair(rs.getInt("manualRepairs"));
                resultMap.put(sceneId, archiveInfo);
            }
            return null;
        });
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)SqlFragment.NOT_REPAIR_COUNT, (Object[])params, rs -> {
            while (rs.next()) {
                String sceneId = rs.getString("sceneId");
                if (resultMap.containsKey(sceneId)) {
                    ((ArchiveInfo)resultMap.get(sceneId)).setNotRepair(rs.getInt("notRepairs"));
                    continue;
                }
                ArchiveInfo archiveInfo = new ArchiveInfo();
                archiveInfo.setNotRepair(rs.getInt("notRepairs"));
                resultMap.put(sceneId, archiveInfo);
            }
            return null;
        });
        return resultMap;
    }

    private void saveNotRepairXid() {
        List<Object[]> xids = this.getNotRepairXid();
        if (!xids.isEmpty()) {
            List filterXids = xids.stream().filter(objects -> !this.isExistedXid(objects[1])).collect(Collectors.toList());
            DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)SqlFragment.SAVE_NOT_REPAIR_XID, filterXids);
        }
    }

    private boolean isExistedXid(Object xid) {
        String sql = "select fxid from t_cbs_dtx_not_repair where fxid = ?";
        return (Boolean)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{xid}, ResultSet::next);
    }

    private void saveArchiveInfo() {
        Map<String, ArchiveInfo> archiveInfoMap = this.getSceneViewInfo();
        ArrayList<Object[]> values = new ArrayList<Object[]>(10);
        for (Map.Entry<String, ArchiveInfo> entry : archiveInfoMap.entrySet()) {
            String sceneId = entry.getKey();
            ArchiveInfo archiveInfo = entry.getValue();
            Date nowDate = Date.valueOf(LocalDate.now().minusDays(1L));
            Object[] value = new Object[]{this.generateFid(SqlFragment.ARCHIVE_TABLE), archiveInfo.getTotal(), archiveInfo.getSuccess(), archiveInfo.getException(), archiveInfo.getRollback(), archiveInfo.getAutoRepair(), archiveInfo.getManualRepair(), archiveInfo.getNotRepair(), Long.parseLong(sceneId), nowDate};
            values.add(value);
        }
        if (!values.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)SqlFragment.SAVE_ARCHIVE_DATA, values);
        }
    }

    private long generateFid(String table) {
        return DB.genLongId((String)table);
    }

    private static class ArchiveInfo {
        private Integer total = 0;
        private Integer success = 0;
        private Integer rollback = 0;
        private Integer exception = 0;
        private Integer autoRepair = 0;
        private Integer manualRepair = 0;
        private Integer notRepair = 0;

        ArchiveInfo() {
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getSuccess() {
            return this.success;
        }

        public void setSuccess(Integer success) {
            this.success = success;
        }

        public Integer getRollback() {
            return this.rollback;
        }

        public void setRollback(Integer rollback) {
            this.rollback = rollback;
        }

        public Integer getException() {
            return this.exception;
        }

        public void setException(Integer exception) {
            this.exception = exception;
        }

        public Integer getAutoRepair() {
            return this.autoRepair;
        }

        public void setAutoRepair(Integer autoRepair) {
            this.autoRepair = autoRepair;
        }

        public Integer getManualRepair() {
            return this.manualRepair;
        }

        public void setManualRepair(Integer manualRepair) {
            this.manualRepair = manualRepair;
        }

        public Integer getNotRepair() {
            return this.notRepair;
        }

        public void setNotRepair(Integer notRepair) {
            this.notRepair = notRepair;
        }
    }
}

