/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.tasks.homeless;

import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.constant.AssignType;
import kd.bos.kdtx.server.tasks.homeless.CompensateStrategy;

public class CompensateStrategyFactory {
    private static final int UNATTENDED_DAYS = Integer.getInteger("kdtx.unattended.days", 10);
    private static final int INITIAL_TIMES = Integer.getInteger("kdtx.unattended.initial.times", 1);
    private static final int DECLINE_INTERVAL = Integer.getInteger("kdtx.unattended.decline.interval", 1);
    private static final String DEFAULT = "defaultCompensateStrategy";
    private static final int DEFAULT_ID = 0;

    public static CompensateStrategy getDefaultCompensateStrategy() {
        StringBuilder builder = new StringBuilder();
        builder.append(UNATTENDED_DAYS).append(";");
        for (int i = 0; i < UNATTENDED_DAYS; ++i) {
            int times = INITIAL_TIMES - i * DECLINE_INTERVAL;
            builder.append(i + 1).append(":").append(times > 0 ? times : 1);
            if (i == UNATTENDED_DAYS) continue;
            builder.append(",");
        }
        String express = builder.toString();
        CompensateStrategy sceneCompensateStrategy = new CompensateStrategy();
        sceneCompensateStrategy.setCode(DEFAULT);
        sceneCompensateStrategy.setName(DEFAULT);
        sceneCompensateStrategy.setAssignType(AssignType.ASSIGN_SCENE.getCode());
        sceneCompensateStrategy.setTotalDay(UNATTENDED_DAYS);
        sceneCompensateStrategy.setAssignedTarget(0L);
        sceneCompensateStrategy.setExpress(express);
        return sceneCompensateStrategy;
    }

    public static CompensateStrategy getCustomSceneCompensateStrategy(long targetId) {
        String sql = "select rs.fcode strategy_code,rs.fname,rs.ftotal_days,rs.fexpress,da.fassign_type,da.ftarget_id from t_cbs_dtx_retry_strategy rs  join t_cbs_dtx_retry_assign da on rs.fid=da.fstrategy_id where da.ftarget_id=?";
        return (CompensateStrategy)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{targetId}, rs -> {
            if (rs.next()) {
                CompensateStrategy sceneCompensateStrategy = new CompensateStrategy();
                sceneCompensateStrategy.setAssignedTarget(rs.getLong("ftarget_id"));
                sceneCompensateStrategy.setCode(rs.getString("strategy_code"));
                sceneCompensateStrategy.setName("fname");
                sceneCompensateStrategy.setTotalDay(rs.getInt("ftotal_days"));
                sceneCompensateStrategy.setExpress(rs.getString("fexpress"));
                sceneCompensateStrategy.setAssignType(rs.getInt("fassign_type"));
                return sceneCompensateStrategy;
            }
            return null;
        });
    }
}

