/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.tasks.homeless;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.kdtx.common.constant.AssignType;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.common.constant.Status;
import kd.bos.kdtx.common.constant.TriggerType;
import kd.bos.kdtx.common.util.EnumUtils;
import kd.bos.kdtx.server.tasks.homeless.CompensateStrategy;
import kd.bos.kdtx.server.tasks.homeless.CompensateStrategyFactory;
import kd.bos.kdtx.server.tx.MultiDBWriteHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.Pair;

public class CompensateStrategyScheduler {
    private static final Log LOGGER = LogFactory.getLog(CompensateStrategyScheduler.class);
    private static final String PATTER = "\\d+;(\\d+:\\d+,?)+";
    private static final int WHOLE_TIME = 1440;
    public static final String ON_OFF = "kdtx.homeless.on";

    public void joinAutoCompensate(String xid) {
        if (!Boolean.parseBoolean(System.getProperty(ON_OFF, "true"))) {
            return;
        }
        if (!this.isAssigned(xid)) {
            Object[] sceneIdCreateTime = this.querySceneIdCreateTime(xid);
            if (sceneIdCreateTime != null) {
                long sceneId = (Long)sceneIdCreateTime[0];
                Date createTime = (Date)sceneIdCreateTime[1];
                CompensateStrategy defaultCompensateStrategy = CompensateStrategyFactory.getDefaultCompensateStrategy();
                CompensateStrategy customSceneCompensateStrategy = CompensateStrategyFactory.getCustomSceneCompensateStrategy(sceneId);
                if (customSceneCompensateStrategy == null) {
                    customSceneCompensateStrategy = defaultCompensateStrategy;
                }
                Map<Integer, Pair<Integer, Integer>> dayRetryIntervals = CompensateStrategyScheduler.parseExpress(customSceneCompensateStrategy.getExpress());
                if (customSceneCompensateStrategy.getAssignType() == AssignType.ASSIGN_SCENE.getCode()) {
                    this.insertSceneScheduleData(xid, sceneId, createTime, dayRetryIntervals);
                }
            } else {
                LOGGER.warn("join auto compensate fail:xid={} not in manual compensation phrase");
            }
        }
    }

    private void joinAutoCompensate(String xid, CompensateStrategy customSceneCompensateStrategy) {
        if (!this.isAssigned(xid)) {
            Object[] sceneIdCreateTime = this.querySceneIdCreateTime(xid);
            if (sceneIdCreateTime != null) {
                long sceneId = (Long)sceneIdCreateTime[0];
                Date createTime = (Date)sceneIdCreateTime[1];
                Map<Integer, Pair<Integer, Integer>> dayRetryIntervals = CompensateStrategyScheduler.parseExpress(customSceneCompensateStrategy.getExpress());
                if (customSceneCompensateStrategy.getAssignType() == AssignType.ASSIGN_SCENE.getCode()) {
                    this.insertSceneScheduleData(xid, sceneId, createTime, dayRetryIntervals);
                }
            } else {
                LOGGER.warn("join auto compensate fail:xid={} not in manual compensation phrase");
            }
        }
    }

    public void autoCompensateComplete(String xid) {
        String sql = "delete from t_cbs_dtx_retry_schedule where fxid=?";
        MultiDBWriteHandler.execute(() -> DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{xid}));
    }

    public void updateScheduleTask(long sceneId) {
        if (!Boolean.parseBoolean(System.getProperty(ON_OFF, "true"))) {
            return;
        }
        CompensateStrategy defaultCompensateStrategy = CompensateStrategyFactory.getDefaultCompensateStrategy();
        CompensateStrategy customSceneCompensateStrategy = CompensateStrategyFactory.getCustomSceneCompensateStrategy(sceneId);
        if (customSceneCompensateStrategy == null) {
            customSceneCompensateStrategy = defaultCompensateStrategy;
        }
        CompensateStrategy effectCompensateStrategy = customSceneCompensateStrategy;
        try (TXHandle tx = TX.requiresNew();){
            try {
                String deleteSql = "delete from t_cbs_dtx_retry_schedule where ftarget_id=?";
                DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])new Object[]{sceneId});
                String queryNeedCompensateXidSql = "select rs.fxid from t_cbs_dtx_retry_stat rs join t_cbs_dtx_transaction trs on rs.fxid = trs.fxid where rs.ftrigger_type = ? and DATEDIFF(rs.fcreate_time,now())< ? and trs.fscenes_tx_id = ?  AND ((trs.fstatus IN ( %s ) and  rs.fseq=-1) or (rs.fseq!=-1 and rs.fstatus=0))";
                queryNeedCompensateXidSql = String.format(queryNeedCompensateXidSql, EnumUtils.toString((Status[])GlobalTxStatus.getCompensateEnable()));
                DB.query((DBRoute)DBRoute.basedata, (String)queryNeedCompensateXidSql, (Object[])new Object[]{TriggerType.MANUALLY.getCode(), effectCompensateStrategy.getTotalDay() * 86400, sceneId}, rs -> {
                    while (rs.next()) {
                        this.joinAutoCompensate(rs.getString(1), effectCompensateStrategy);
                    }
                    return null;
                });
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private boolean isAssigned(String xid) {
        String sql = "select fid from t_cbs_dtx_retry_schedule where fxid=?";
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{xid}, rs -> {
            if (rs.next()) {
                return true;
            }
            return false;
        });
    }

    private void insertSceneScheduleData(String xid, long sceneId, Date createTime, Map<Integer, Pair<Integer, Integer>> dayRetryIntervals) {
        String insertSql = "insert into t_cbs_dtx_retry_schedule(fid,fxid,ftarget_id,fschedule_time,fassign_type,fcreate_time) values(?,?,?,?,?,now())";
        ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>();
        for (Map.Entry<Integer, Pair<Integer, Integer>> entry : dayRetryIntervals.entrySet()) {
            int day = entry.getKey();
            Pair<Integer, Integer> pair = entry.getValue();
            List<Date> scheduleTimes = this.calcScheduleTime(createTime, day, (Integer)pair.getKey(), (Integer)pair.getValue());
            for (Date scheduleTime : scheduleTimes) {
                insertParamsList.add(new Object[]{ID.genLongId(), xid, sceneId, scheduleTime, AssignType.ASSIGN_SCENE.getCode()});
            }
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, insertParamsList);
    }

    private Object[] querySceneIdCreateTime(String xid) {
        String queryCreateTimeSql = "select trs.fscenes_tx_id,rs.fcreate_time from t_cbs_dtx_transaction trs left join t_cbs_dtx_retry_stat rs on rs.fxid = trs.fxid and rs.ftrigger_type = ? where trs.fxid =?";
        Object[] sceneIdCreateTime = (Object[])DB.query((DBRoute)DBRoute.basedata, (String)queryCreateTimeSql, (Object[])new Object[]{TriggerType.MANUALLY.getCode(), xid}, rs -> {
            if (rs.next()) {
                Object[] data = new Object[]{rs.getLong(1), rs.getTimestamp(2)};
                return data;
            }
            return null;
        });
        return sceneIdCreateTime;
    }

    private List<Date> calcScheduleTime(Date createTime, int day, int retry, int interval) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createTime);
        if (day > 1) {
            calendar.add(5, day - 1);
        }
        ArrayList<Date> dates = new ArrayList<Date>(8);
        for (int i = 0; i < retry; ++i) {
            calendar.add(12, interval);
            dates.add(calendar.getTime());
        }
        return dates;
    }

    private static Map<Integer, Pair<Integer, Integer>> parseExpress(String express) {
        HashMap<Integer, Pair<Integer, Integer>> dayRetryIntervals = new HashMap<Integer, Pair<Integer, Integer>>();
        if (express.matches(PATTER)) {
            String[] dayRetrys;
            int delimiter = express.indexOf(";");
            String totalDayStr = express.substring(0, delimiter);
            String detailStr = express.substring(delimiter + 1);
            int totalDays = Integer.parseInt(totalDayStr);
            for (String dayRetryStr : dayRetrys = detailStr.split(",")) {
                String[] dayRetry = dayRetryStr.split(":");
                int day = Integer.parseInt(dayRetry[0]);
                int retry = Integer.parseInt(dayRetry[1]);
                if (retry <= 0) continue;
                int interval = 1440 / retry;
                dayRetryIntervals.put(day, (Pair<Integer, Integer>)new Pair((Object)retry, (Object)interval));
            }
        } else {
            throw new RuntimeException("express format error! [" + express + "]");
        }
        return dayRetryIntervals;
    }
}

