/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor;

import java.io.IOException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.config.MonitorConfig;
import kd.bos.monitor.httpserver.MonitorHttpServer;
import kd.bos.monitor.httpserver.MonitorInstaller;
import kd.bos.monitor.postfunction.PostFuncInstaller;
import kd.bos.util.NetAddressUtils;

public class MonitorServerMain {
    private static final Log logger = LogFactory.getLog(MonitorHttpServer.class);

    public static void start() throws IOException {
        String str = MonitorConfig.getMonitorPort();
        if (str == null) {
            MonitorServerMain.startByDynamicPort();
        } else {
            int port = Integer.parseInt(str);
            MonitorServerMain.start(port);
        }
    }

    public static void startByDynamicPort() throws IOException {
        int max = 20;
        int index = 0;
        int port = 9997;
        while (index++ < max) {
            try {
                port = NetAddressUtils.getAvailablePort((int)(port + 1));
                MonitorServerMain.start0(port);
                break;
            }
            catch (IOException e) {
                logger.error("monitor start exception", (Throwable)e);
            }
        }
        if (index == max) {
            throw new IOException("Can't start MonitorServerMain, please config MONITOR_HTTP_PORT");
        }
        System.setProperty("MONITOR_HTTP_PORT", String.valueOf(port));
    }

    public static void start(int port) throws IOException {
        if (port == -1) {
            MonitorServerMain.startByDynamicPort();
        } else {
            MonitorServerMain.start0(port);
        }
    }

    public static void start0(int port) throws IOException {
        MonitorHttpServer httpServer = new MonitorHttpServer(port);
        MonitorInstaller.install(httpServer);
        PostFuncInstaller.install();
        httpServer.start();
    }
}

