/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.algox;

import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Map;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.metric.MetricHandler;

public class FlinkResourceHandler
extends AbstractHttpHandler {
    private final String path;
    private String context;
    private static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";

    public FlinkResourceHandler(String path, String context) {
        this.path = path;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle0(HttpExchange pExchange) throws IOException {
        InputStream in;
        URI uri = pExchange.getRequestURI();
        Map<String, String> params = this.getParams(pExchange, false);
        String reqPath = uri.getPath();
        int pos = reqPath.indexOf(this.context);
        if (!(reqPath = reqPath.substring(pos + this.context.length())).startsWith("/")) {
            reqPath = "/" + reqPath;
        }
        if ("/".equals(reqPath) || "/index".equals(reqPath)) {
            reqPath = "/i.html";
        }
        if ((in = MetricHandler.class.getResourceAsStream(this.path + reqPath)) == null) {
            pExchange.sendResponseHeaders(404, 0L);
            pExchange.close();
            return;
        }
        try {
            if (reqPath.endsWith(".js")) {
                pExchange.getResponseHeaders().set(HTTP_HEADER_CONTENT_TYPE, "text/javascript; charset=UTF-8");
            } else if (reqPath.endsWith(".jsx")) {
                pExchange.getResponseHeaders().set(HTTP_HEADER_CONTENT_TYPE, "text/javascript; charset=UTF-8");
            } else if (reqPath.endsWith(".css")) {
                pExchange.getResponseHeaders().set(HTTP_HEADER_CONTENT_TYPE, "text/css; charset=UTF-8");
            } else if (reqPath.endsWith(".html") || reqPath.endsWith(".htm")) {
                pExchange.getResponseHeaders().set(HTTP_HEADER_CONTENT_TYPE, "text/html; charset=UTF-8");
            }
            byte[] response = this.readBytes(in);
            if (reqPath.endsWith("/i.html")) {
                response = this.replaceIndex(response, params);
            }
            pExchange.sendResponseHeaders(202, response.length);
            OutputStream os = pExchange.getResponseBody();
            os.write(response);
            pExchange.close();
        }
        finally {
            in.close();
        }
    }

    private byte[] replaceIndex(byte[] response, Map<String, String> params) throws UnsupportedEncodingException {
        String text = new String(response, "UTF-8");
        String flinkServer = params.get("server");
        int pos = flinkServer.indexOf("/eye");
        flinkServer = ".." + flinkServer.substring(pos + 4);
        text = text.replace("{flinkServer}", flinkServer);
        if (this.isFlyDBService()) {
            text = text.replace("{titleName}", "SuperQuery Monitor");
            text = text.replace("{navbarHeaderName}", "SuperQuery Monitor");
        } else {
            text = text.replace("{titleName}", "AlgoX Monitor");
            text = text.replace("{navbarHeaderName}", "AlgoX Monitor");
        }
        return text.getBytes("UTF-8");
    }

    private boolean isFlyDBService() {
        String flyDBServer = System.getProperty("flydb.service");
        if (flyDBServer != null && flyDBServer.trim().length() > 0) {
            String[] split;
            for (String service : split = flyDBServer.split(",")) {
                String server = service.trim();
                if (!"flydb-server".equals(server) && !"flydb-worker".equals(server) && !"flydb-proxy".equals(server)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytes(InputStream str) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int thisLine;
            while ((thisLine = str.read()) != -1) {
                bos.write(thisLine);
            }
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

