/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.auth;

import com.sun.net.httpserver.HttpExchange;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.encrypt.Encrypters;
import kd.bos.instance.Instance;
import kd.bos.monitor.auth.SessionStore;
import kd.bos.monitor.proxy.ProxyHandler;
import kd.bos.util.StringUtils;

public class Auther {
    public static final String SESSIONKEY = "KD_MONITOR_SESSION";
    private static final String KEY_MONITOR_USER = "monitor.user";
    private static final String KEY_MONITOR_PD = "monitor.password";
    private static final String KEY_HEALTHCHECK_URI = "/monitor/service/healthcheckk8s";
    private static final String AUTH_TOKEN = Instance.getClusterName() + "-Auth_Token";
    private static final String AUTH_CHECK_CLASS = "kd.bos.eye.auth.EyeAuther";
    private static final String AUTH_CHECK_METHOD = "proxyPermissionCheck";

    public static boolean check(HttpExchange exchange) {
        if (Instance.getClusterName() == null) {
            return true;
        }
        if (Auther.checkURIRequest(exchange.getRequestURI())) {
            return true;
        }
        if (Auther.checkProxyHeader(exchange)) {
            return true;
        }
        return Auther.checkSession(exchange);
    }

    private static boolean checkURIRequest(URI requestURI) {
        return requestURI.getPath().equals(KEY_HEALTHCHECK_URI);
    }

    public static boolean checkUser(String user, String password) {
        String mp;
        return user.equals(System.getProperty(KEY_MONITOR_USER)) ? (mp = System.getProperty(KEY_MONITOR_PD)) != null && password.equals(mp = Encrypters.decode((String)mp)) : user.equals(System.getProperty("monitor.guest.user")) && (mp = System.getProperty("monitor.guest.password")) != null && password.equals(mp = Encrypters.decode((String)mp));
    }

    public static boolean isGuestUser(HttpExchange exchange) {
        String sessionId = Auther.getSessionId(exchange);
        String token = Auther.getToken(exchange);
        if (sessionId == null && token == null) {
            return false;
        }
        return Auther.checkSession(token) || Auther.checkSession(sessionId);
    }

    private static boolean checkSession(String token) {
        String guestUser = System.getProperty("monitor.guest.user");
        String guestPassword = System.getProperty("monitor.guest.password");
        SessionStore sessionStore = SessionStore.get();
        if (!sessionStore.exists(token)) {
            return false;
        }
        Map<String, String> map = sessionStore.get(token);
        String user = map.get("user");
        String password = map.get("password");
        if (StringUtils.isNotEmpty((String)guestUser) && StringUtils.isNotEmpty((String)user) && user.equals(guestUser) && guestPassword != null && password != null) {
            guestPassword = Encrypters.decode((String)guestPassword);
            return password.equals(guestPassword);
        }
        return false;
    }

    private static boolean checkSession(HttpExchange exchange) {
        String sessionId = Auther.getSessionId(exchange);
        String token = Auther.getToken(exchange);
        if (sessionId == null && token == null) {
            return false;
        }
        return Auther.checkExists(sessionId) || Auther.checkToken(token);
    }

    private static boolean checkToken(String token) {
        return SessionStore.get().exists(token);
    }

    public static String getToken(HttpExchange exchange) {
        String authToken = exchange.getRequestHeaders().getFirst(AUTH_TOKEN);
        if (StringUtils.isEmpty((String)authToken)) {
            String[] cookiearry;
            String cookies = exchange.getRequestHeaders().getFirst("Cookie");
            if (StringUtils.isEmpty((String)cookies)) {
                return null;
            }
            for (String cookie : cookiearry = cookies.split(";")) {
                if (!(cookie = cookie.replaceAll(" ", "")).startsWith(AUTH_TOKEN + "=")) continue;
                authToken = cookie.replace(AUTH_TOKEN + "=", "").replace(";", "");
            }
        }
        return authToken;
    }

    private static boolean checkProxyHeader(HttpExchange exchange) {
        if (exchange.getClass().toString().endsWith(".ServletExchangeImpl")) {
            return false;
        }
        String value = exchange.getRequestHeaders().getFirst(ProxyHandler.PROXY_HEADER_KEY);
        return ProxyHandler.PROXY_HEADER_VALUE.equals(value);
    }

    private static boolean checkExists(String sessionId) {
        return SessionStore.get().exists(sessionId);
    }

    public static String getSessionId(HttpExchange exchange) {
        String[] cookiearry;
        String cookies = exchange.getRequestHeaders().getFirst("Cookie");
        if (StringUtils.isEmpty((String)cookies)) {
            return null;
        }
        String sessionId = null;
        for (String cookie : cookiearry = cookies.split(";")) {
            if (!(cookie = cookie.replaceAll(" ", "")).startsWith("KD_MONITOR_SESSION=")) continue;
            sessionId = cookie.replace("KD_MONITOR_SESSION=", "").replace(";", "");
        }
        return sessionId;
    }

    public static void newSession(HttpExchange exchange, String user, String password) {
        String sessionId = UUID.randomUUID().toString();
        Auther.setCookieSessionId(exchange, sessionId);
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("user", user);
        info.put("password", password);
        SessionStore.get().store(sessionId, info);
    }

    private static void setCookieSessionId(HttpExchange exchange, String sessionId) {
        exchange.getResponseHeaders().add("Set-Cookie", "KD_MONITOR_SESSION=" + sessionId);
    }

    public static boolean checkPermission(HttpExchange exchange) {
        try {
            Class<?> clazz = Class.forName(AUTH_CHECK_CLASS);
            Method method = clazz.getDeclaredMethod(AUTH_CHECK_METHOD, HttpExchange.class);
            Boolean ret = (Boolean)method.invoke(clazz.newInstance(), exchange);
            return ret;
        }
        catch (Exception e) {
            return true;
        }
    }
}

