/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.auth;

import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionableCache;
import kd.bos.monitor.auth.SessionStore;

public class DistributeSessionStore
extends SessionStore {
    private static final int TIMEOUT_SECONDS = 28800;
    private static final String SESSION_KEY_PRE = "monitor-session-";
    private DistributeSessionableCache cache = CacheFactory.getCommonCacheFactory().$getDistributeSessionableCache();

    private String makeKey(String sessionId) {
        return SESSION_KEY_PRE + sessionId;
    }

    @Override
    public void store(String sessionId, Map<String, String> sessionInfo) {
        this.cache.put(this.makeKey(sessionId), sessionInfo);
        this.cache.expireAfter(this.makeKey(sessionId), 28800);
    }

    @Override
    public boolean exists(String sessionId) {
        Map all = this.cache.getAll(this.makeKey(sessionId));
        return all != null && !all.isEmpty();
    }

    @Override
    public Map<String, String> get(String sessionId) {
        return this.cache.getAll(this.makeKey(sessionId));
    }

    @Override
    public void remove(String sessionId) {
        this.cache.remove(this.makeKey(sessionId));
    }
}

