/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.auth;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import kd.bos.monitor.auth.SessionStore;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.util.TemplateUtil;
import kd.bos.util.StringUtils;

public class LoginOutHandler
extends AbstractHttpHandler {
    public static final String SESSIONKEY = "KD_MONITOR_SESSION";
    public static final LoginOutHandler instance = new LoginOutHandler();
    private String template = TemplateUtil.loadTemplate("/bos-monitor/login/login.html");

    private LoginOutHandler() {
    }

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        String token = LoginOutHandler.getToken(exchange);
        if (!StringUtils.isEmpty((String)token)) {
            SessionStore.get().remove(token);
        }
        SessionStore.get().remove(LoginOutHandler.getSessionId(exchange));
        this.renderHtml(exchange, "", "");
    }

    private void renderHtml(HttpExchange exchange, String message, String user) throws IOException {
        String html = this.template.replace("{message}", message);
        html = html.replace("{user}", user == null ? "" : user);
        this.writeHtml(html, exchange);
    }

    private static String getSessionId(HttpExchange exchange) {
        String[] cookiearry;
        String cookies = exchange.getRequestHeaders().getFirst("Cookie");
        if (StringUtils.isEmpty((String)cookies)) {
            return null;
        }
        String sessionId = null;
        for (String cookie : cookiearry = cookies.split(";")) {
            if (!(cookie = cookie.replaceAll(" ", "")).startsWith("KD_MONITOR_SESSION=")) continue;
            sessionId = cookie.replace("KD_MONITOR_SESSION=", "").replace(";", "");
        }
        return sessionId;
    }

    private static String getToken(HttpExchange exchange) {
        String authToken = exchange.getRequestHeaders().getFirst("Auth_Token");
        if (StringUtils.isEmpty((String)authToken)) {
            String[] cookiearry;
            String cookies = exchange.getRequestHeaders().getFirst("Cookie");
            if (StringUtils.isEmpty((String)cookies)) {
                return null;
            }
            for (String cookie : cookiearry = cookies.split(";")) {
                if (!(cookie = cookie.replaceAll(" ", "")).startsWith("Auth_Token=")) continue;
                authToken = cookie.replace("Auth_Token=", "").replace(";", "");
            }
        }
        return authToken;
    }
}

