/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.auth;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.UUID;
import javax.imageio.ImageIO;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.monitor.auth.MonitorVerifyCode;
import kd.bos.util.JSONUtils;
import org.apache.commons.codec.binary.Base64;

public class VerifyCodeHandler
implements HttpHandler {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        MonitorVerifyCode vc = new MonitorVerifyCode();
        BufferedImage bim = vc.getImage();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bim, "JPEG", out);
        String content = Base64.encodeBase64String((byte[])out.toByteArray());
        String loginId = UUID.randomUUID().toString();
        cache.put("monitor_login_verifyCode" + loginId, (Object)vc.getText(), 1800);
        HashMap<String, String> vCode = new HashMap<String, String>();
        vCode.put("verifyCode", "data:image/jpeg;base64," + content);
        vCode.put("loginId", loginId);
        this.writeResponseJson(exchange, JSONUtils.toString(vCode));
    }

    private void writeResponseJson(HttpExchange exchange, CharSequence result) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.print(result.toString());
        String str = sw.toString();
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
        exchange.sendResponseHeaders(200, bytes.length);
        exchange.getResponseBody().write(bytes);
        out.close();
        sw.close();
        exchange.close();
    }
}

