/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.config;

import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.home.NodeInfo;
import kd.bos.mservice.config.MserviceAssemblyConfig;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.SystemProperties;
import kd.bos.util.WebPortUtil;

public class MonitorConfig {
    private static final boolean isPreferIPv6 = NetAddressUtils.isPreferIPv6();
    private static final Log logger = LogFactory.getLog(MonitorConfig.class);
    private static NodeInfo nodeInfo;

    public static String getMonitorPort() {
        return SystemProperties.getProperty((String)"MONITOR_HTTP_PORT", (String)"9999");
    }

    public static String getMonitorIp() {
        String ip = NetAddressUtils.getLocalIpAddress();
        if (isPreferIPv6 && !ip.startsWith("[")) {
            ip = "[" + ip + "]";
        }
        return ip;
    }

    public static NodeInfo getNodeInfo() {
        if (nodeInfo == null) {
            NodeInfo info = new NodeInfo();
            info.setClusterName(Instance.getClusterName());
            String appName = Instance.getAppName();
            info.setAppName(appName);
            if (MonitorConfig.isGateway()) {
                if ("web".equals(appName)) {
                    info.setShowAppName("web(gateway)");
                } else {
                    info.setShowAppName(appName + "(gateway)");
                }
            }
            StringBuilder configAppName = new StringBuilder();
            String[] configAppNames = Instance.getConfigAppName();
            for (int i = 0; i < configAppNames.length; ++i) {
                configAppName.append(configAppNames[i]).append(",");
            }
            info.setConfigAppName(configAppName.toString());
            info.setInstanceId(Instance.getInstanceId());
            info.setAppIds(Instance.getAppIds());
            String ip = MonitorConfig.getMonitorIp();
            String monitorPort = MonitorConfig.getMonitorPort();
            info.setIp(ip);
            info.setMonitorPort(monitorPort);
            info.setHostIp(System.getProperty("MONITOR_HTTP_HOST_IP"));
            info.setHostMonitorPort(System.getProperty("MONITOR_HTTP_HOST_PORT"));
            try {
                info.setHostName(NetAddressUtils.getLocalHostName());
            }
            catch (Exception e) {
                logger.error("get local hostName exception", (Throwable)e);
            }
            String port = WebPortUtil.getWebPort(null);
            if (port != null) {
                info.setWebPort(port);
            }
            if ((port = System.getProperty("SERVICE_PORT")) != null) {
                info.setMservicePort(port);
                String s = System.getProperty("dubbo.registry.register");
                if (s != null) {
                    info.setDubboRegister(Boolean.parseBoolean(s));
                }
                if ((s = System.getProperty("mq.consumer.register")) != null) {
                    info.setMqConsumerRegister(Boolean.parseBoolean(s));
                }
            }
            info.setRpcPort(MonitorConfig.getRpcPort());
            info.setWebNode(WebPortUtil.isWebNode());
            info.setGateWay(MonitorConfig.isGateway());
            nodeInfo = info;
        }
        return nodeInfo;
    }

    public static String getRpcPort() {
        String rpcPort = "dubbo".equals(MserviceAssemblyConfig.getMserviceRpcType()) ? System.getProperty("dubbo.protocol.port", "20880") : ("feign".equals(MserviceAssemblyConfig.getMserviceRpcType()) ? WebPortUtil.getWebPort((String)WebPortUtil.getServerPort()) : ("assembly".equals(MserviceAssemblyConfig.getMserviceRpcType()) ? System.getProperty("monitor.custom.rpc.port", System.getProperty("dubbo.protocol.port", "20880")) : System.getProperty("monitor.custom.rpc.port", WebPortUtil.getWebPort((String)WebPortUtil.getServerPort()))));
        return rpcPort;
    }

    private static boolean isGateway() {
        String TRUE = "true";
        String WEBSTR = "web";
        String appName = SystemProperties.getWithEnv((String)"appName");
        String configAppName = SystemProperties.getWithEnv((String)"configAppName");
        String webmserviceinone = SystemProperties.getWithEnv((String)"webmserviceinone");
        String isMserviceNode = SystemProperties.getWithEnv((String)"isMserviceNode");
        boolean isWebNode = WEBSTR.equals(appName) ? true : (TRUE.equals(webmserviceinone) ? false : (TRUE.equals(isMserviceNode) ? false : (configAppName != null && configAppName.indexOf("mservice") >= 0 ? false : configAppName != null && configAppName.indexOf(WEBSTR) >= 0)));
        return isWebNode;
    }
}

