/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.httpserver;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import kd.bos.monitor.auth.Auther;
import kd.bos.monitor.util.ExchangeUtils;
import kd.bos.monitor.util.UriQuery;
import kd.bos.util.JSONUtils;

public abstract class AbstractHttpHandler
implements HttpHandler {
    private static final String MONITORVERSION = System.getProperty("monitor.version", "new");

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        if (!this.checkAuth(exchange)) {
            this.noPermission(exchange);
        } else if (!this.checkPermission(exchange)) {
            this.noAuth(exchange);
        } else {
            this.handle0(exchange);
        }
    }

    private void noAuth(HttpExchange exchange) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("code", 50009);
        map.put("msg", "No permission");
        String str = JSONUtils.toString(map);
        this.writeJson(str, exchange);
    }

    private void noPermission(HttpExchange exchange) throws IOException {
        String url = exchange.getRequestURI().getRawPath();
        int monitor = url.indexOf("monitor");
        int length = "monitor".length();
        url = url.endsWith("/") ? url.substring(0, monitor + 1 + length) : url.substring(0, monitor + length);
        String suffix = "new".equalsIgnoreCase(MONITORVERSION) ? "eye/" : "login";
        url = url.endsWith("/") ? url + suffix : url + "/" + suffix;
        ExchangeUtils.redirect(exchange, url);
    }

    private boolean checkAuth(HttpExchange exchange) {
        return Auther.check(exchange);
    }

    private boolean checkPermission(HttpExchange exchange) {
        return Auther.checkPermission(exchange);
    }

    protected abstract void handle0(HttpExchange var1) throws IOException;

    protected Map<String, String> getParams(HttpExchange exchange, boolean rawQuery) {
        URI uri = exchange.getRequestURI();
        String query = rawQuery ? uri.getRawQuery() : uri.getQuery();
        Map<String, String> params = UriQuery.toMap(query);
        for (Map.Entry<String, String> param : params.entrySet()) {
            params.put(param.getKey(), this.cleanXSSParam(param.getValue()));
        }
        return params;
    }

    protected String cleanXSSParam(String value) {
        String cleanValue = value;
        cleanValue = cleanValue.replaceAll("\"", "&quot;");
        cleanValue = cleanValue.replaceAll("'", "&#39;");
        cleanValue = cleanValue.replaceAll("<", "&lt;");
        cleanValue = cleanValue.replaceAll(">", "&gt;");
        return cleanValue;
    }

    protected String cleanXSSResponse(String value) {
        String cleanValue = value;
        cleanValue = cleanValue.replaceAll("<script>", "&lt;script&gt;").replaceAll("</script>", "&lt;/script&gt;");
        return cleanValue;
    }

    protected void writeJson(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "text/json; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    protected void writeHtml(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }
}

