/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.httpserver;

import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extension.ExtensionFactory;
import kd.bos.monitor.algox.IerpFlinkProxyHandler;
import kd.bos.monitor.algox.IerpFlinkResourceHandler;
import kd.bos.monitor.home.HomeHandler;
import kd.bos.monitor.httpserver.HttpServerHandler;
import kd.bos.monitor.httpserver.MonitorHttpServer;
import kd.bos.monitor.proxy.IerpProxyHandler;
import kd.bos.monitor.service.ClusterNodeHealthHandler;
import kd.bos.monitor.service.ServiceCatalogHandler;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.jvmagent.handler.JolokiaHttpHandler;

public class MonitorInstaller {
    private static final String JMXAPIURL = "jmxapiUrl";
    private static final String CHARTJSONURL = "chartJsonUrl";
    private static final String MONITOR_JMX_WEB = "/bos-monitor/jmx/web";
    private static final Map<String, HttpHandler> handlerMap = new ConcurrentHashMap<String, HttpHandler>(8);
    public static JolokiaHttpHandler jolokiaHttpHandler;
    private static final List<Object> serverList;
    private static final ExtensionFactory<HttpServerHandler> httpServerFactory;

    public static void install(Object server) throws IOException {
        MonitorInstaller.install1(server, "");
        serverList.add(server);
    }

    public static void install(Object server, String contextPath) throws IOException {
        MonitorInstaller.install1(server, contextPath);
    }

    public static void installIerp(Object server) throws IOException {
        MonitorInstaller.installIerp0(server, "");
    }

    public static synchronized void installIerp0(Object server, String contextPath) {
        MonitorInstaller.addHandler(server, contextPath + "/cbs/rt/ax", () -> new IerpFlinkResourceHandler("/bos-monitor/flink", contextPath + "/cbs/rt/ax"));
        MonitorInstaller.addHandler(server, contextPath + "/cbs/rt/ax/*", () -> new IerpFlinkResourceHandler("/bos-monitor/flink", contextPath + "/cbs/rt/ax"));
        MonitorInstaller.addHandler(server, contextPath + "/cbs/algoxfp/", IerpFlinkProxyHandler::new);
        MonitorInstaller.addHandler(server, contextPath + "/cbs/algoxfp/*", IerpFlinkProxyHandler::new);
        MonitorInstaller.addHandler(server, contextPath + "/cbs/rt/ax/proxy3/*", IerpProxyHandler::new);
    }

    private static synchronized void install1(Object server, String contextPath) {
        MonitorInstaller.addHandler(server, contextPath + "/monitor/eye/old/", HomeHandler::new);
        MonitorInstaller.addHandler(server, contextPath + "/monitor/eye/old", HomeHandler::new);
        MonitorInstaller.addHandler(server, contextPath + "/monitor/", HomeHandler::new);
        MonitorInstaller.addHandler(server, contextPath + "/monitor", HomeHandler::new);
        if ("true".equals(System.getProperty("servicecatalog.monitor.enable"))) {
            MonitorInstaller.addHandler(server, contextPath + "/monitor/service/servicecatalog", () -> new ServiceCatalogHandler("/monitor/servicecatalog"));
            MonitorInstaller.addHandler(server, contextPath + "/monitor0/service/servicecatalog", () -> new ServiceCatalogHandler("/monitor0/servicecatalog"));
        }
        if ("true".equals(System.getProperty("node.malfunction.simulation.enable"))) {
            MonitorInstaller.addHandler(server, contextPath + "/monitor/clusternodehealth", () -> new ClusterNodeHealthHandler("/monitor/clusternodehealth"));
        }
    }

    public static synchronized void registyHandler(String contextPath, Supplier<HttpHandler> handlerSupplier) {
        if (!serverList.isEmpty()) {
            serverList.forEach(v -> MonitorInstaller.addHandler(v, contextPath, handlerSupplier));
        }
    }

    private static void addHandler(Object server, String context, Supplier<HttpHandler> handlerSupplier) {
        HttpHandler handler = exchange -> {
            try {
                HttpHandler lazyHandler = handlerMap.computeIfAbsent(context, arg_0 -> MonitorInstaller.lambda$null$6((Supplier)handlerSupplier, arg_0));
                lazyHandler.handle(exchange);
            }
            catch (Exception e) {
                throw new KDException(BosErrorCode.bOS, new Object[]{e});
            }
        };
        MonitorInstaller.addHandler(server, context, handler);
    }

    private static void addHandler(Object server, String context, HttpHandler handler) {
        if (server instanceof MonitorHttpServer) {
            ((MonitorHttpServer)server).addHandler(context, handler);
            return;
        }
        HttpServerHandler httpServerHandler = (HttpServerHandler)httpServerFactory.getExtension(System.getProperty("webserver.type", "jetty"));
        httpServerHandler.addHandler(server, context, handler);
    }

    private static /* synthetic */ HttpHandler lambda$null$6(Supplier handlerSupplier, String key) {
        return (HttpHandler)handlerSupplier.get();
    }

    static {
        serverList = new ArrayList<Object>();
        httpServerFactory = ExtensionFactory.getExtensionFacotry(HttpServerHandler.class);
        try {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(ConfigKey.AGENT_CONTEXT);
            list.add("/jmx");
            list.add(ConfigKey.POLICY_LOCATION);
            list.add(MonitorInstaller.class.getResource("/bos-monitor/jmx/jolokia-restrictions.xml").toString());
            list.add(ConfigKey.AGENT_ID);
            list.add("monitor");
            list.add(ConfigKey.DISCOVERY_ENABLED);
            list.add("false");
            Configuration configuration = new Configuration(list.toArray());
            jolokiaHttpHandler = new JolokiaHttpHandler(configuration);
            jolokiaHttpHandler.start(false);
        }
        catch (Exception e) {
            jolokiaHttpHandler = null;
        }
    }
}

