/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.jmx.chart;

import java.util.Arrays;
import java.util.List;
import kd.bos.monitor.jmx.chart.Chart;
import kd.bos.monitor.jmx.chart.ChartProvider;
import kd.bos.monitor.jmx.chart.Jmx;
import kd.bos.monitor.jmx.chart.Serie;
import kd.bos.util.resource.Resources;

public class ChartContents {
    private static final String HEAPMEMORYUSAGE = "HeapMemoryUsage";
    private static final String MEMORY = "java.lang:type=Memory";

    public static ChartProvider getChartProvider() {
        return new ChartProvider(){

            @Override
            public List<Chart> getCharts() {
                return Arrays.asList(ChartContents.createHeapChart(), ChartContents.createCpuChart());
            }
        };
    }

    private static Chart createCpuChart() {
        Chart chart = new Chart(Resources.getString((String)"Cpu\u8d1f\u8f7d(%)", (String)"ChartContents_0", (String)"bos-monitor", (Object[])new Object[0]), new Serie(new Jmx("java.lang:type=OperatingSystem", "ProcessCpuLoad", null)));
        chart.setYaxisFormatter("percent");
        return chart;
    }

    private static Chart createHeapChart() {
        Serie used = new Serie("used", new Jmx(MEMORY, HEAPMEMORYUSAGE, "used"));
        Serie committed = new Serie("committed", new Jmx(MEMORY, HEAPMEMORYUSAGE, "committed"));
        Serie max = new Serie("max", new Jmx(MEMORY, HEAPMEMORYUSAGE, "max"));
        Chart chart = new Chart(Resources.getString((String)"\u5806\u5185\u5b58", (String)"ChartContents_1", (String)"bos-monitor", (Object[])new Object[0]), max, committed, used);
        chart.setShowLegend(true);
        chart.setYaxisFormatter("mkb1024");
        return chart;
    }
}

