/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.jmx.chart;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.util.TemplateUtil;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ChartJsonHandler
extends AbstractHttpHandler {
    @Override
    public void handle0(HttpExchange pExchange) throws IOException {
        byte[] response = this.getJson();
        pExchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
        pExchange.sendResponseHeaders(202, response.length);
        pExchange.getResponseBody().write(response);
        pExchange.close();
    }

    private byte[] getJson() throws IOException {
        String json = System.getProperty("monitor.chartconfig");
        if (json != null) {
            json = this.replaceGCType(json);
            try {
                new JSONParser().parse(json);
                return json.getBytes("UTF-8");
            }
            catch (ParseException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        json = TemplateUtil.loadTemplate("/bos-monitor/jmx/chartconfig.json");
        json = this.replaceGCType(json);
        try {
            new JSONParser().parse(json);
            return json.getBytes("UTF-8");
        }
        catch (ParseException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private String replaceGCType(String json) {
        String[] gcTypes = this.getGCTypes();
        if (gcTypes != null && json.contains("PS Scavenge")) {
            json = json.replace("PS Scavenge", gcTypes[0]);
            json = json.replace("PS MarkSweep", gcTypes[1]);
        }
        return json;
    }

    private String[] getGCTypes() {
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
            if (!gcMxBean.getName().contains("G1")) continue;
            return new String[]{"G1 Young Generation", "G1 Old Generation"};
        }
        return null;
    }
}

