/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.log;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.encrypt.Encrypters;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.logback.LogbackFactory;
import kd.bos.monitor.log.ESQueryBuilder;
import kd.bos.monitor.log.KDException;
import kd.bos.monitor.log.LogObject;
import kd.bos.monitor.log.LogQuery;
import kd.bos.monitor.log.LogQueryHandler;
import kd.bos.monitor.log.QueryResult;
import kd.bos.util.StringUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class HttpESLogQuery
implements LogQuery {
    private static final Log LOGGER = LogbackFactory.getLog(HttpESLogQuery.class);
    private static final int MAX_RANGE = Integer.getInteger("monitor.log.maxSearchRange", 5);
    private static int MAX_CONTENT_LENGTH = 0x200000;
    private static String SLOW_LOGGER_CLASSNAME = "kd.bos.slowlog.SlowLogger";
    private static final String ES_USERNAME = "monitor.es.user";
    private static final String ES_PD = "monitor.es.password";
    private static final String ES_SSL_ENABLE = "monitor.es.ssl.enable";
    private static final String ES_CERTIFICATE_PATH = "monitor.es.certificate.path";
    private static final String ES_CERTIFICATE_PD = "monitor.es.certificate.password";
    private static final String ES_HTTP_CONNECTION_TIMEOUT = "monitor.es.connection.timeout";
    private static final String ES_HTTP_SOCKET_CONNECTION_TIMEOUT = "monitor.es.socket.connection.timeout";
    private static final String HTTPS_SCHEMA = "https";
    private static final String HTTP_SCHEMA = "http";
    private Map<String, HttpClient> clientCache = new ConcurrentHashMap<String, HttpClient>(8);
    private static List<String> columns = new ArrayList<String>(16);
    private static String DEFAULT_COLUMNS = "appName,instanceId,appId,logtags.appId,level,line,className,methodName,logtags.opKey,logtags.opMethod,logtags.formId,logtags.formName,message,message2,stacktrace,stacktrace2,time,logtags.traceId,logtags.tenantId,logtags.accountId,logtags.userId,logtags.userName";
    private static KeyStore trustStore;

    private SimpleDateFormat getSdfUTC() {
        SimpleDateFormat sdfUTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdfUTC.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdfUTC;
    }

    @Override
    public QueryResult query(String appName, String appId, String opKey, String opMethod, String formId, String formName, String className, String methodName, String instanceId, String traceId, String userId, String userName, String tenantId, String accountId, String level, int size, int timeEndHourOffSet, int timeRangeMinutes, String keyword, String slowLogger, boolean isDefine, Date beginTime, Date endTime) {
        String es_url = System.getProperty("monitor.es.url");
        if (StringUtils.isEmpty((String)es_url)) {
            return new QueryResult(-1, "monitor.es.url not configured.");
        }
        if (StringUtils.isEmpty((String)className) && Boolean.parseBoolean(slowLogger)) {
            className = SLOW_LOGGER_CLASSNAME;
        }
        HashMap<String, String> queryFields = new HashMap<String, String>(16);
        if (!StringUtils.isEmpty((String)appName)) {
            queryFields.put("appName", appName);
        }
        if (!StringUtils.isEmpty((String)appId)) {
            queryFields.put("logtags.appId", appId);
        }
        if (!StringUtils.isEmpty((String)opKey)) {
            queryFields.put("logtags.opKey", opKey);
        }
        if (!StringUtils.isEmpty((String)opMethod)) {
            queryFields.put("logtags.opMethod", opMethod);
        }
        if (!StringUtils.isEmpty((String)formId)) {
            queryFields.put("logtags.formId", formId);
        }
        if (!StringUtils.isEmpty((String)formName)) {
            queryFields.put("logtags.formName", formName);
        }
        if (!StringUtils.isEmpty((String)className)) {
            queryFields.put("className", className);
        }
        if (!StringUtils.isEmpty((String)methodName)) {
            queryFields.put("methodName", methodName);
        }
        if (!StringUtils.isEmpty((String)instanceId)) {
            queryFields.put("instanceId", instanceId);
        }
        if (!StringUtils.isEmpty((String)traceId)) {
            queryFields.put("logtags.traceId", traceId);
        }
        if (!StringUtils.isEmpty((String)userId)) {
            queryFields.put("logtags.userId", userId);
        }
        if (!StringUtils.isEmpty((String)userName)) {
            queryFields.put("logtags.userName", userName);
        }
        if (!StringUtils.isEmpty((String)traceId)) {
            queryFields.put("logtags.tenantId", tenantId);
        }
        if (!StringUtils.isEmpty((String)accountId)) {
            queryFields.put("logtags.accountId", accountId);
        }
        if (!StringUtils.isEmpty((String)level)) {
            queryFields.put("level", level);
        }
        Date end = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(end);
        if (timeEndHourOffSet > 0) {
            calendar.add(10, -timeEndHourOffSet);
            end = calendar.getTime();
        }
        Date begin = null;
        if (timeRangeMinutes > 0) {
            calendar.add(12, -timeRangeMinutes);
            begin = calendar.getTime();
        }
        if (isDefine) {
            begin = beginTime;
            end = endTime;
            calendar.setTime(beginTime);
            calendar.add(7, MAX_RANGE);
            Date time = calendar.getTime();
            if (end.after(time)) {
                end = time;
            }
        }
        try {
            QueryResult result = this.query(es_url, queryFields, keyword, begin, end, size, 0);
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getIndexName() {
        String index = System.getProperty("monitor.es.index");
        if (index == null || "".equals(index)) {
            return Instance.getClusterName() + "-log*";
        }
        String[] split = index.trim().split(",");
        StringBuilder sb = new StringBuilder();
        int n = split.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(split[i]).append("*");
        }
        return sb.toString();
    }

    private QueryResult query(String es_url, Map<String, String> queryFields, String keyword, Date startTime, Date endTime, int size, int from) {
        SimpleDateFormat sdfUTCFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        ArrayList<LogObject> logList = new ArrayList<LogObject>();
        String[] keywordFields = new String[]{"message", "stacktrace"};
        String[] keywords = Boolean.parseBoolean(System.getProperty("monitor.keyword.search.space", "false")) ? StringUtils.split((String)keyword, (boolean)true, (char[])new char[]{' '}) : (keyword != null ? keyword.split("\\|\\|") : new String[]{});
        String index = this.getIndexName();
        if (!es_url.endsWith("/")) {
            es_url = es_url + "/";
        }
        String url = es_url + index + "/_search";
        String query = ESQueryBuilder.build(keywords, keywordFields, queryFields, startTime, endTime, size, from);
        try {
            PostResult postResult = this.httpClientPost(url, query);
            if (postResult != null) {
                if (postResult.download) {
                    return this.createDownloadUrl(postResult.content);
                }
                JSONObject js = JSONObject.parseObject((String)postResult.content);
                JSONArray hits = js.getJSONObject("hits").getJSONArray("hits");
                if (hits != null && !hits.isEmpty()) {
                    for (Object obj : hits) {
                        JSONObject hit = (JSONObject)obj;
                        JSONObject o = hit.getJSONObject("_source");
                        HashMap<String, Object> log = new HashMap<String, Object>();
                        log.put("logid", hit.get((Object)"_id"));
                        for (String col : columns) {
                            int pos = col.indexOf(".");
                            if (pos < 0) {
                                log.put(col, o.get((Object)col));
                                continue;
                            }
                            String key = col.substring(0, pos);
                            JSONObject json = o.getJSONObject(key);
                            String tagkey = col.substring(pos + 1);
                            String value = json != null ? json.get((Object)tagkey) : "";
                            log.put(tagkey, value);
                        }
                        log.put("timestamp", o.get((Object)"@timestamp"));
                        LogObject logObj = new LogObject();
                        BeanUtils.populate((Object)logObj, log);
                        logObj.setTime(sdfUTCFormat.format(this.getSdfUTC().parse((String)log.get("time"))));
                        logList.add(logObj);
                    }
                }
            }
        }
        catch (Exception e) {
            return new QueryResult(-1, e.getMessage());
        }
        QueryResult qr = new QueryResult(logList);
        qr.setUrl(url);
        qr.setPostData(query);
        return qr;
    }

    /*
     * Exception decompiling
     */
    private QueryResult createDownloadUrl(String content) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void printLogObject(PrintWriter pw, LogObject log) {
        pw.println();
        StringBuilder sb = new StringBuilder();
        sb.append(log.getTime()).append("[").append(log.getLevel()).append("][").append(log.getAppName()).append("]");
        if (StringUtils.isNotEmpty((String)log.getTraceId())) {
            sb.append("[traceId=").append(log.getTraceId()).append("]");
        }
        sb.append(LogQueryHandler.getClassMethodLine(log)).append(":").append(LogQueryHandler.getMessage(log));
        if (StringUtils.isNotEmpty((String)log.getStacktrace())) {
            sb.append("\r\n").append(log.getStacktrace());
        }
        pw.println(sb.toString());
    }

    private PostResult httpClientPost(String url, String json) throws IOException {
        HttpClient client = this.clientCache.computeIfAbsent(url, u -> this.createHttpClient());
        HttpPost post = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Integer.parseInt(System.getProperty(ES_HTTP_CONNECTION_TIMEOUT, "5000"))).setSocketTimeout(Integer.parseInt(System.getProperty(ES_HTTP_SOCKET_CONNECTION_TIMEOUT, "60000"))).build();
        post.setConfig(requestConfig);
        try {
            StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)se);
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                long length = resEntity.getContentLength();
                if (length > (long)MAX_CONTENT_LENGTH) {
                    PostResult postResult = new PostResult(true, this.asJson(resEntity));
                    return postResult;
                }
                PostResult postResult = new PostResult(false, this.asJson(resEntity));
                return postResult;
            }
            throw new IOException("Can't access elastic, status:" + response.getStatusLine() + ", detail:" + response.toString());
        }
        finally {
            post.releaseConnection();
        }
    }

    private HttpClient createHttpClient() {
        CloseableHttpClient client;
        String username = System.getProperty(ES_USERNAME);
        String password = System.getProperty(ES_PD);
        Boolean isSslEnable = Boolean.parseBoolean(System.getProperty(ES_SSL_ENABLE));
        if (username != null && password != null) {
            password = Encrypters.decode((String)password);
            client = isSslEnable.booleanValue() ? this.createHttpsClient(username, password) : HttpClients.custom().setDefaultCredentialsProvider(this.initCreadentials(username, password)).build();
        } else {
            client = HttpClients.createDefault();
        }
        return client;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CloseableHttpClient createHttpsClient(String username, String password) {
        String path = System.getProperty(ES_CERTIFICATE_PATH);
        if (path == null) {
            throw new KDException("Certificate cann't be null when use SSL/TLS, please config: monitor.es.certificate.path");
        }
        String certificatePwd = System.getProperty(ES_CERTIFICATE_PD);
        if (certificatePwd == null) {
            throw new KDException("Certificate password cann't be null when use SSL/TLS, please config: monitor.es.certificate.password");
        }
        try (FileInputStream is = new FileInputStream(FilenameUtils.normalize((String)path));){
            trustStore.load(is, certificatePwd.toCharArray());
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(trustStore, null).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register(HTTPS_SCHEMA, (Object)sslsf).register(HTTP_SCHEMA, (Object)new PlainConnectionSocketFactory()).build();
            BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
            CloseableHttpClient closeableHttpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultCredentialsProvider(this.initCreadentials(username, password)).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
            return closeableHttpClient;
        }
        catch (Exception e) {
            throw new KDException(e);
        }
    }

    private CredentialsProvider initCreadentials(String username, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        return credentialsProvider;
    }

    private String asJson(HttpEntity resEntity) throws IOException {
        Header respHeader = resEntity.getContentEncoding();
        if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
            GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
            InputStream in = gzipEntity.getContent();
            return HttpESLogQuery.getContent(in);
        }
        return EntityUtils.toString((HttpEntity)resEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getContent(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                in = null;
            }
        }
        return sb.toString();
    }

    static {
        try {
            trustStore = KeyStore.getInstance("jks");
        }
        catch (KeyStoreException e) {
            trustStore = null;
        }
        columns.addAll(Arrays.asList(DEFAULT_COLUMNS.split(",")));
    }

    private static class PostResult {
        private boolean download;
        private String content;

        PostResult(boolean download, String content) {
            this.download = download;
            this.content = content;
        }
    }
}

