/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.log;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.OperationContextCreator;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.log.LogObject;
import kd.bos.monitor.log.LogQuery;
import kd.bos.monitor.log.LogQueryFactory;
import kd.bos.monitor.log.QueryResult;
import kd.bos.monitor.log.htmlcomponent.OptionsBuilder;
import kd.bos.monitor.util.ClassicTo404;
import kd.bos.monitor.util.TemplateUtil;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;

public final class LogQueryHandler
extends AbstractHttpHandler {
    private static int DEFAULT_SIZE = 100;
    private static final String MAGIC = "{result}";
    private static final String DIV_SUF = "</div>";
    private static final String ROW_COUNT = "{rowCount}";
    private static String[] columns = new String[]{Resources.getString((String)"\u65f6\u95f4", (String)"LogQueryHandler_54", (String)"bos-monitor", (Object[])new Object[0]), Resources.getString((String)"\u8282\u70b9", (String)"LogQueryHandler_55", (String)"bos-monitor", (Object[])new Object[0]) + "Id", "traceId", Resources.getString((String)"\u7528\u6237", (String)"LogQueryHandler_56", (String)"bos-monitor", (Object[])new Object[0]), Resources.getString((String)"\u79df\u6237", (String)"LogQueryHandler_57", (String)"bos-monitor", (Object[])new Object[0]) + "&" + Resources.getString((String)"\u5e10\u5957", (String)"LogQueryHandler_58", (String)"bos-monitor", (Object[])new Object[0]), Resources.getString((String)"\u4ee3\u7801\u4f4d\u7f6e", (String)"LogQueryHandler_59", (String)"bos-monitor", (Object[])new Object[0]), Resources.getString((String)"\u6d88\u606f", (String)"LogQueryHandler_60", (String)"bos-monitor", (Object[])new Object[0])};
    private static final String XMP_PRE = "<xmp>";
    private static final String XMP_SUF = "</xmp>";
    private static final String TD_SUF = "</td>";

    private String getParam(Map<String, String> params, String key, String def) {
        String value = params.get(key);
        if (value == null) {
            return def;
        }
        return value;
    }

    private int getIntParam(Map<String, String> params, String key, int def) {
        String value = params.get(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception ex) {
                return def;
            }
        }
        return def;
    }

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        String template;
        boolean disable = ClassicTo404.redirectTo404(exchange);
        if (disable) {
            return;
        }
        OperationContextCreator.getOrCreateForBos();
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        Map<String, String> params = this.getParams(exchange, false);
        String appName = this.getParam(params, "appName", "");
        String opKey = this.getParam(params, "opKey", "");
        String opMethod = this.getParam(params, "opMethod", "");
        String formId = this.getParam(params, "formId", "");
        String formName = this.getParam(params, "formName", "");
        String appId = this.getParam(params, "appId", "");
        String className = this.getParam(params, "className", "");
        String methodName = this.getParam(params, "methodName", "");
        String instanceId = this.getParam(params, "instanceId", "");
        String traceId = this.getParam(params, "traceId", "");
        String tenantId = this.getParam(params, "tenantId", "");
        String accountId = this.getParam(params, "accountId", "");
        String userId = this.getParam(params, "userId", "");
        String userName = this.getParam(params, "userName", "");
        String keyword = this.getParam(params, "keyword", "");
        String beginDateRange = this.getParam(params, "beginDateRange", "");
        String endDateRange = this.getParam(params, "endDateRange", "");
        String slowLogger = this.getParam(params, "slowLogger", "false");
        slowLogger = slowLogger.equalsIgnoreCase("on") ? String.valueOf(Boolean.TRUE) : String.valueOf(Boolean.FALSE);
        String isDefine = this.getParam(params, "isDefineTimeRange", String.valueOf(Boolean.FALSE));
        isDefine = isDefine.equalsIgnoreCase("on") ? String.valueOf(Boolean.TRUE) : String.valueOf(Boolean.FALSE);
        String level = this.getParam(params, "level", "");
        int size = this.getIntParam(params, "size", DEFAULT_SIZE);
        int timeEndHourOffSet = this.getIntParam(params, "timeEndHourOffSet", 0);
        int timeRangeMinutes = this.getIntParam(params, "timeRangeMinutes", 60);
        boolean b = Boolean.parseBoolean(isDefine);
        if (b) {
            Date begin = this.renderDate(beginDateRange);
            Date end = this.renderDate(endDateRange);
            if (begin == null || end == null) {
                String html = "please fill in the correct time.";
                out.println(html);
                out.flush();
                this.writeHtml(sw.toString(), exchange);
                return;
            }
            if (begin.after(end)) {
                String html = "End time must be greater than start time.";
                out.println(html);
                out.flush();
                this.writeHtml(sw.toString(), exchange);
                return;
            }
        }
        try {
            template = this.loadTemplate();
        }
        catch (Exception e) {
            String html = "Can't load html template.";
            out.println(html);
            out.flush();
            this.writeHtml(sw.toString(), exchange);
            return;
        }
        String html = this.render(params.isEmpty(), template, appName, appId, opKey, opMethod, formId, formName, className, methodName, instanceId, traceId, userId, userName, tenantId, accountId, level, size, timeEndHourOffSet, timeRangeMinutes, keyword, slowLogger, b, beginDateRange, endDateRange);
        out.print(html);
        out.flush();
        this.writeHtml(sw.toString(), exchange);
    }

    private String render(boolean empty, String template, String appName, String appId, String opKey, String opMethod, String formId, String formName, String className, String methodName, String instanceId, String traceId, String userId, String userName, String tenantId, String accountId, String level, int size, int timeEndHourOffSet, int timeRangeMinutes, String keyword, String slowLogger, boolean isDefine, String beginDateRange, String endDateRange) {
        String notice = null;
        String debug = null;
        template = template.replace("{appName}", appName);
        template = template.replace("{appId}", appId);
        template = template.replace("{opKey}", opKey);
        template = template.replace("{opMethod}", opMethod);
        template = template.replace("{formId}", formId);
        template = template.replace("{formName}", formName);
        template = template.replace("{className}", className);
        template = template.replace("{methodName}", methodName);
        template = template.replace("{instanceId}", instanceId);
        template = template.replace("{traceId}", traceId);
        template = template.replace("{keyword}", keyword);
        template = template.replace("{userId}", userId);
        template = template.replace("{userName}", userName);
        template = template.replace("{tenantId}", tenantId);
        template = template.replace("{accountId}", accountId);
        template = template.replace("{slowLoggerChecked}", Boolean.parseBoolean(slowLogger) ? "checked='checked'" : "");
        template = template.replace("{isDefineChecked}", isDefine ? "checked='checked'" : "");
        template = template.replace("{level}", this.renderLevel(template, level));
        template = template.replace("{size}", this.renderSize(template, "" + size));
        template = template.replace("{timeEndHourOffSet}", this.renderTimeEndHourOffSet(template, "" + timeEndHourOffSet));
        template = template.replace("{timeRangeMinutes}", this.renderTimeRangeHours(template, "" + timeRangeMinutes));
        template = template.replace("{beginDateRange}", beginDateRange);
        template = template.replace("{endDateRange}", endDateRange);
        if (empty) {
            template = this.renderEmpty(template, "");
        } else {
            LogQuery query = LogQueryFactory.getLogQuery();
            QueryResult result = query.query(appName, appId, opKey, opMethod, formId, formName, className, methodName, instanceId, traceId, userId, userName, tenantId, accountId, level, size, timeEndHourOffSet, timeRangeMinutes, keyword, slowLogger, isDefine, this.renderDate(beginDateRange), this.renderDate(endDateRange));
            if (result.getCode() == 0) {
                template = this.renderResult(template, result.getData());
            } else if (result.getCode() == -1) {
                template = this.renderError(template, result.getMessage());
            } else {
                template = this.renderEmpty(template, "");
                notice = "<span>" + Resources.getString((String)"\u7531\u4e8e\u67e5\u8be2\u6570\u636e\u91cf\u592a\u5927\uff0c\u8bf7\u4e0b\u8f7d\u65e5\u5fd7\u67e5\u770b", (String)"LogQueryHandler_0", (String)"bos-monitor", (Object[])new Object[0]) + "\uff1a<span><a href='" + result.getMessage() + "' target='_blank'>" + Resources.getString((String)"\u94fe\u63a5", (String)"LogQueryHandler_1", (String)"bos-monitor", (Object[])new Object[0]) + "</a>";
            }
            if (result.getUrl() != null) {
                debug = "<br/><div>---------debug info--------</div><div>post data is:</div><div>" + result.getPostData() + DIV_SUF;
            }
        }
        if (!empty && notice == null && StringUtils.isEmpty((String)keyword) && StringUtils.isEmpty((String)traceId)) {
            if (timeRangeMinutes > 60) {
                timeRangeMinutes = 60;
            }
            notice = Resources.getString((String)"\u63d0\u793a", (String)"LogQueryHandler_1", (String)"bos-monitor", (Object[])new Object[0]) + ": " + Resources.getString((String)"\u6ca1\u6709\u8f93\u5165\u5173\u952e\u5b57\u641c\u7d22", (String)"LogQueryHandler_2", (String)"bos-monitor", (Object[])new Object[0]) + "\uff0c" + Resources.getString((String)"\u6700\u591a\u53ea\u663e\u793a1\u4e2a\u5c0f\u65f6\u7684\u65e5\u5fd7", (String)"LogQueryHandler_3", (String)"bos-monitor", (Object[])new Object[0]);
        }
        template = template.replace("{notice}", notice == null ? "" : notice);
        template = template.replace("{debug}", debug == null ? "" : debug);
        return template;
    }

    private String renderError(String template, String message) {
        String result = "<div class='error'>" + message + DIV_SUF;
        template = template.replace(MAGIC, result);
        template = template.replace(ROW_COUNT, "");
        return template;
    }

    private String renderEmpty(String template, String message) {
        String result = "<div class='empty'>" + message + DIV_SUF;
        template = template.replace(MAGIC, result);
        template = template.replace(ROW_COUNT, "");
        return template;
    }

    private Date renderDate(String date) {
        if (!StringUtils.isEmpty((String)date)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                return sdf.parse(date.replaceAll("T", " "));
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    private String loadTemplate() throws IOException {
        return TemplateUtil.loadTemplate("/bos-monitor/log/logquery.template");
    }

    private String renderResult(String template, List<LogObject> logs) {
        StringBuilder builder = new StringBuilder();
        if (logs != null && logs.size() > 0) {
            builder.append("<table class=\"table\">");
            this.renderLogTable(builder, logs);
            builder.append("</table>");
            template = template.replace(ROW_COUNT, Resources.getString((String)"\u5171", (String)"LogQueryHandler_4", (String)"bos-monitor", (Object[])new Object[0]) + String.valueOf(logs.size()) + Resources.getString((String)"\u6761", (String)"LogQueryHandler_5", (String)"bos-monitor", (Object[])new Object[0]));
        } else {
            template = template.replace(ROW_COUNT, Resources.getString((String)"\u6ca1\u6709\u6570\u636e", (String)"LogQueryHandler_6", (String)"bos-monitor", (Object[])new Object[0]) + ", " + Resources.getString((String)"\u51710\u6761", (String)"LogQueryHandler_7", (String)"bos-monitor", (Object[])new Object[0]));
        }
        String result = builder.toString();
        template = template.replace(MAGIC, result);
        return template;
    }

    private String renderLevel(String template, String level) {
        OptionsBuilder optionsBuilder = new OptionsBuilder("Level", "level", level, new String[]{"", Resources.getString((String)"\u6240\u6709", (String)"LogQueryHandler_8", (String)"bos-monitor", (Object[])new Object[0]), "INFO", "INFO", "DEBUG", "DEBUG", "WARN", "WARN", "ERROR", "ERROR"});
        return optionsBuilder.render();
    }

    private String renderSize(String template, String size) {
        OptionsBuilder optionsBuilder = new OptionsBuilder(Resources.getString((String)"\u6761\u6570", (String)"LogQueryHandler_9", (String)"bos-monitor", (Object[])new Object[0]), "size", size, new String[]{"100", "100", "500", "500", "1000", "1000", "2000", "2000", "5000", "5000"});
        return optionsBuilder.render();
    }

    private String renderTimeRangeHours(String template, String timeRangeMinutes) {
        OptionsBuilder optionsBuilder = new OptionsBuilder(Resources.getString((String)"\u65f6\u95f4\u8303\u56f4", (String)"LogQueryHandler_10", (String)"bos-monitor", (Object[])new Object[0]), "timeRangeMinutes", timeRangeMinutes, new String[]{"15", Resources.getString((String)"15\u5206\u949f", (String)"LogQueryHandler_11", (String)"bos-monitor", (Object[])new Object[0]), "30", Resources.getString((String)"30\u5206\u949f", (String)"LogQueryHandler_12", (String)"bos-monitor", (Object[])new Object[0]), "60", Resources.getString((String)"1\u5c0f\u65f6", (String)"LogQueryHandler_13", (String)"bos-monitor", (Object[])new Object[0]), "120", Resources.getString((String)"2\u5c0f\u65f6", (String)"LogQueryHandler_14", (String)"bos-monitor", (Object[])new Object[0]), "240", Resources.getString((String)"4\u5c0f\u65f6", (String)"LogQueryHandler_15", (String)"bos-monitor", (Object[])new Object[0]), "480", Resources.getString((String)"8\u5c0f\u65f6", (String)"LogQueryHandler_16", (String)"bos-monitor", (Object[])new Object[0]), "1440", Resources.getString((String)"24\u5c0f\u65f6", (String)"LogQueryHandler_17", (String)"bos-monitor", (Object[])new Object[0]), "2880", Resources.getString((String)"48\u5c0f\u65f6", (String)"LogQueryHandler_18", (String)"bos-monitor", (Object[])new Object[0])});
        return optionsBuilder.render();
    }

    private String renderTimeEndHourOffSet(String template, String timeEndHourOffSet) {
        OptionsBuilder optionsBuilder = new OptionsBuilder(Resources.getString((String)"\u5f53\u524d\u65f6\u95f4", (String)"LogQueryHandler_19", (String)"bos-monitor", (Object[])new Object[0]), "timeEndHourOffSet", timeEndHourOffSet, new String[]{"0", Resources.getString((String)"\u5f53\u524d\u65f6\u95f4", (String)"LogQueryHandler_20", (String)"bos-monitor", (Object[])new Object[0]), "1", Resources.getString((String)"\u5f80\u524d1\u5c0f\u65f6", (String)"LogQueryHandler_21", (String)"bos-monitor", (Object[])new Object[0]), "2", Resources.getString((String)"\u5f80\u524d2\u5c0f\u65f6", (String)"LogQueryHandler_22", (String)"bos-monitor", (Object[])new Object[0]), "3", Resources.getString((String)"\u5f80\u524d3\u5c0f\u65f6", (String)"LogQueryHandler_23", (String)"bos-monitor", (Object[])new Object[0]), "4", Resources.getString((String)"\u5f80\u524d4\u5c0f\u65f6", (String)"LogQueryHandler_24", (String)"bos-monitor", (Object[])new Object[0]), "5", Resources.getString((String)"\u5f80\u524d5\u5c0f\u65f6", (String)"LogQueryHandler_25", (String)"bos-monitor", (Object[])new Object[0]), "6", Resources.getString((String)"\u5f80\u524d6\u5c0f\u65f6", (String)"LogQueryHandler_26", (String)"bos-monitor", (Object[])new Object[0]), "7", Resources.getString((String)"\u5f80\u524d7\u5c0f\u65f6", (String)"LogQueryHandler_27", (String)"bos-monitor", (Object[])new Object[0]), "8", Resources.getString((String)"\u5f80\u524d8\u5c0f\u65f6", (String)"LogQueryHandler_28", (String)"bos-monitor", (Object[])new Object[0]), "9", Resources.getString((String)"\u5f80\u524d9\u5c0f\u65f6", (String)"LogQueryHandler_29", (String)"bos-monitor", (Object[])new Object[0]), "10", Resources.getString((String)"\u5f80\u524d10\u5c0f\u65f6", (String)"LogQueryHandler_30", (String)"bos-monitor", (Object[])new Object[0]), "11", Resources.getString((String)"\u5f80\u524d11\u5c0f\u65f6", (String)"LogQueryHandler_31", (String)"bos-monitor", (Object[])new Object[0]), "12", Resources.getString((String)"\u5f80\u524d12\u5c0f\u65f6", (String)"LogQueryHandler_32", (String)"bos-monitor", (Object[])new Object[0]), "13", Resources.getString((String)"\u5f80\u524d13\u5c0f\u65f6", (String)"LogQueryHandler_33", (String)"bos-monitor", (Object[])new Object[0]), "14", Resources.getString((String)"\u5f80\u524d14\u5c0f\u65f6", (String)"LogQueryHandler_34", (String)"bos-monitor", (Object[])new Object[0]), "15", Resources.getString((String)"\u5f80\u524d15\u5c0f\u65f6", (String)"LogQueryHandler_35", (String)"bos-monitor", (Object[])new Object[0]), "16", Resources.getString((String)"\u5f80\u524d16\u5c0f\u65f6", (String)"LogQueryHandler_36", (String)"bos-monitor", (Object[])new Object[0]), "17", Resources.getString((String)"\u5f80\u524d17\u5c0f\u65f6", (String)"LogQueryHandler_37", (String)"bos-monitor", (Object[])new Object[0]), "18", Resources.getString((String)"\u5f80\u524d18\u5c0f\u65f6", (String)"LogQueryHandler_38", (String)"bos-monitor", (Object[])new Object[0]), "19", Resources.getString((String)"\u5f80\u524d19\u5c0f\u65f6", (String)"LogQueryHandler_39", (String)"bos-monitor", (Object[])new Object[0]), "20", Resources.getString((String)"\u5f80\u524d20\u5c0f\u65f6", (String)"LogQueryHandler_40", (String)"bos-monitor", (Object[])new Object[0]), "21", Resources.getString((String)"\u5f80\u524d21\u5c0f\u65f6", (String)"LogQueryHandler_41", (String)"bos-monitor", (Object[])new Object[0]), "22", Resources.getString((String)"\u5f80\u524d22\u5c0f\u65f6", (String)"LogQueryHandler_42", (String)"bos-monitor", (Object[])new Object[0]), "23", Resources.getString((String)"\u5f80\u524d23\u5c0f\u65f6", (String)"LogQueryHandler_43", (String)"bos-monitor", (Object[])new Object[0]), "24", Resources.getString((String)"\u5f80\u524d24\u5c0f\u65f6", (String)"LogQueryHandler_44", (String)"bos-monitor", (Object[])new Object[0]), "48", Resources.getString((String)"\u5f80\u524d2\u5929", (String)"LogQueryHandler_45", (String)"bos-monitor", (Object[])new Object[0]), "72", Resources.getString((String)"\u5f80\u524d3\u5929", (String)"LogQueryHandler_46", (String)"bos-monitor", (Object[])new Object[0]), "96", Resources.getString((String)"\u5f80\u524d4\u5929", (String)"LogQueryHandler_47", (String)"bos-monitor", (Object[])new Object[0]), "120", Resources.getString((String)"\u5f80\u524d5\u5929", (String)"LogQueryHandler_48", (String)"bos-monitor", (Object[])new Object[0]), "144", Resources.getString((String)"\u5f80\u524d6\u5929", (String)"LogQueryHandler_49", (String)"bos-monitor", (Object[])new Object[0]), "168", Resources.getString((String)"\u5f80\u524d7\u5929", (String)"LogQueryHandler_50", (String)"bos-monitor", (Object[])new Object[0]), "192", Resources.getString((String)"\u5f80\u524d8\u5929", (String)"LogQueryHandler_51", (String)"bos-monitor", (Object[])new Object[0]), "216", Resources.getString((String)"\u5f80\u524d9\u5929", (String)"LogQueryHandler_52", (String)"bos-monitor", (Object[])new Object[0]), "240", Resources.getString((String)"\u5f80\u524d10\u5929", (String)"LogQueryHandler_53", (String)"bos-monitor", (Object[])new Object[0])});
        return optionsBuilder.render();
    }

    public static String getClassMethodLine(LogObject log) {
        return log.getClassName() + "\r\n" + log.getMethodName() + "(" + log.getLine() + "):" + log.getLevel();
    }

    private String nullAsEmpty(String str) {
        return str == null ? "" : str;
    }

    private void renderLogTable(StringBuilder builder, List<LogObject> logs) {
        builder.append("<thead>");
        builder.append("<tr>");
        builder.append("<th class='time'>time</th>");
        builder.append("<th class='instanceId'>instanceId</th>");
        builder.append("<th class='appId'>appId</th>");
        builder.append("<th class='traceId'>traceId</th>");
        builder.append("<th class='user'>user</th>");
        builder.append("<th class='tenantAccount'>").append(Resources.getString((String)"\u79df\u6237", (String)"LogQueryHandler_61", (String)"bos-monitor", (Object[])new Object[0])).append("&").append(Resources.getString((String)"\u5e10\u5957", (String)"LogQueryHandler_62", (String)"bos-monitor", (Object[])new Object[0])).append("</th>");
        builder.append("<th class='opKey'>opKey&opMethod</th>");
        builder.append("<th class='formId'>formId&formName</th>");
        builder.append("<th class='code'>").append(Resources.getString((String)"\u4ee3\u7801\u4f4d\u7f6e", (String)"LogQueryHandler_63", (String)"bos-monitor", (Object[])new Object[0])).append("</th>");
        builder.append("<th class='message'>message</th>");
        builder.append("</tr>");
        builder.append("</thead>");
        builder.append("<tbody>");
        for (LogObject log : logs) {
            builder.append("<tr>");
            if (log.getTime() != null) {
                String[] times = log.getTime().split(" ");
                builder.append("<td class='time'>").append(XMP_PRE).append(this.nullAsEmpty(times[0])).append("\r\n").append(this.nullAsEmpty(times[1])).append(XMP_SUF).append(TD_SUF);
            }
            builder.append("<td class='instanceId'>").append(XMP_PRE).append(this.nullAsEmpty(log.getInstanceId())).append(XMP_SUF).append(TD_SUF);
            builder.append("<td class='appId'>").append(XMP_PRE).append(this.nullAsEmpty(log.getAppId())).append(XMP_SUF).append(TD_SUF);
            builder.append("<td class='traceId'>").append(XMP_PRE).append(this.nullAsEmpty(log.getTraceId())).append(XMP_SUF).append(TD_SUF);
            builder.append("<td class='user'>").append(XMP_PRE).append(this.nullAsEmpty(LogQueryHandler.getUserInfo(log))).append(XMP_SUF).append(TD_SUF);
            builder.append("<td class='tenantAccount'>").append(XMP_PRE).append(this.nullAsEmpty(log.getTenantId())).append("\r\n").append(this.nullAsEmpty(log.getAccountId())).append(XMP_SUF).append(TD_SUF);
            builder.append("<td class='opKey'>").append(XMP_PRE).append(this.nullAsEmpty(log.getOpKey())).append("\r\n").append(this.nullAsEmpty(log.getOpMethod())).append(XMP_SUF).append(TD_SUF);
            builder.append("<td class='formId'>").append(XMP_PRE).append(this.nullAsEmpty(log.getFormId())).append("\r\n").append(this.nullAsEmpty(log.getFormName())).append(XMP_SUF).append(TD_SUF);
            builder.append("<td class='code'>").append(XMP_PRE).append(LogQueryHandler.getClassMethodLine(log)).append(XMP_SUF).append(TD_SUF);
            builder.append("<td class='message'>").append(XMP_PRE).append(this.replaceTN(LogQueryHandler.getMessageAndStacktrace(log))).append(XMP_SUF).append(TD_SUF);
            builder.append("</tr>");
        }
        builder.append("</tbody>");
    }

    private Object replaceTN(String str) {
        return str;
    }

    public static String getMessageAndStacktrace(LogObject log) {
        String message = LogQueryHandler.getMessage(log);
        String stacktrace = LogQueryHandler.getStacktrace(log);
        if (StringUtils.isEmpty((String)message)) {
            return stacktrace;
        }
        if (message.contains("Caused by")) {
            return message;
        }
        if (StringUtils.isNotEmpty((String)stacktrace)) {
            if (stacktrace.contains(message)) {
                return stacktrace;
            }
            return message + "\r\n" + stacktrace;
        }
        return message;
    }

    public static String getMessage(LogObject log) {
        String message = log.getMessage();
        String message2 = log.getMessage2();
        if (message == null) {
            return message2;
        }
        if (message2 != null) {
            return message + message2;
        }
        return message;
    }

    public static String getStacktrace(LogObject log) {
        String str = log.getStacktrace();
        String str2 = log.getStacktrace2();
        if (str == null) {
            return str2;
        }
        if (str2 != null) {
            return str + str2;
        }
        return str;
    }

    public static String getUserInfo(LogObject log) {
        if (StringUtils.isNotEmpty((String)log.getUserName())) {
            return log.getUserName() + (StringUtils.isEmpty((String)log.getUserId()) ? "" : "\r\n" + log.getUserId());
        }
        return log.getUserId();
    }
}

