/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.metric;

import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.util.ExchangeUtils;
import kd.bos.monitor.util.UriQuery;
import kd.bos.monitor.util.UrlUtils;
import kd.bos.util.StringUtils;

public class MetricHandler
extends AbstractHttpHandler {
    private static final String HEADER = "Content-Type";
    private final String resourcePath;
    private String context;
    private Map<String, String> variables;

    public MetricHandler(String context, Map<String, String> variables, String resourcePath) {
        this.resourcePath = resourcePath;
        this.context = context;
        this.variables = variables;
    }

    @Override
    public void handle0(HttpExchange pExchange) throws IOException {
        URI uri = pExchange.getRequestURI();
        Map<String, String> params = UriQuery.toMap(pExchange.getRequestURI().getRawQuery());
        params.putAll(ExchangeUtils.parsePostParameters(pExchange));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> next : params.entrySet()) {
            String value = next.getValue();
            hashMap.put(next.getKey(), this.cleanXSSParam(value));
        }
        params = hashMap;
        boolean isNewIndex = "new".equals(params.get("type"));
        String suffix = isNewIndex ? "/index_new.html" : "/index.html";
        String reqPath = uri.getPath();
        int pos = reqPath.indexOf(this.context);
        if (pos >= 0) {
            if ((reqPath = reqPath.substring(pos + this.context.length())).length() < 3) {
                reqPath = suffix;
            }
        } else {
            reqPath = suffix;
        }
        try (InputStream in = MetricHandler.class.getResourceAsStream(this.resourcePath + reqPath);){
            if (in == null) {
                pExchange.sendResponseHeaders(404, 0L);
                pExchange.close();
                return;
            }
            if (reqPath.endsWith(".js")) {
                pExchange.getResponseHeaders().set(HEADER, "text/javascript; charset=UTF-8");
            } else if (reqPath.endsWith(".css")) {
                pExchange.getResponseHeaders().set(HEADER, "text/css; charset=UTF-8");
            } else if (reqPath.endsWith(".html")) {
                pExchange.getResponseHeaders().set(HEADER, "text/html; charset=UTF-8");
            }
            byte[] response = this.readBytes(in);
            if (reqPath.endsWith(suffix)) {
                response = this.replaceIndex(response, params);
            }
            pExchange.sendResponseHeaders(202, response.length);
            try (OutputStream os = pExchange.getResponseBody();){
                os.write(response);
            }
        }
        pExchange.close();
    }

    private byte[] replaceIndex(byte[] response, Map<String, String> params) {
        String chartJsonUrl;
        boolean isNewIndex = "new".equals(params.get("type"));
        String text = new String(response, StandardCharsets.UTF_8);
        String httpRootUrl = params.get("baseurl");
        String proxyurl = params.get("proxyurl");
        String chartJsonUrlVar = this.variables.get("chartJsonUrl");
        String jmxProxyUrl = this.variables.get("jmxProxyUrl");
        String string = chartJsonUrl = StringUtils.isEmpty((String)proxyurl) ? chartJsonUrlVar : UrlUtils.encodeProxy(httpRootUrl + chartJsonUrlVar, "proxy");
        if (isNewIndex) {
            String chartsReqParam = params.get("chartsReqParam");
            text = text.replace("{chartsReqParam}", chartsReqParam == null ? "" : chartsReqParam);
        } else {
            String title = params.get("title");
            String jmxapiUrl = UrlUtils.encodeProxy0(httpRootUrl + this.variables.get("jmxapiUrl"), "proxy");
            text = text.replace("{jmxapiUrl}", jmxapiUrl == null ? "" : jmxapiUrl);
            text = text.replace("{title}", title == null ? "" : title);
        }
        text = text.replace("{chartJsonUrl}", chartJsonUrl == null ? "" : chartJsonUrl);
        text = text.replace("{jmxProxyUrl}", jmxProxyUrl == null ? "" : "jmxProxy");
        return text.getBytes(StandardCharsets.UTF_8);
    }

    private byte[] readBytes(InputStream str) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int thisLine;
            while ((thisLine = str.read()) != -1) {
                bos.write(thisLine);
            }
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    @Override
    protected String cleanXSSParam(String value) {
        String cleanValue = value;
        if (StringUtils.isNotEmpty((String)cleanValue)) {
            cleanValue = cleanValue.replaceAll("prompt", "");
            cleanValue = cleanValue.replaceAll("xml", "");
            cleanValue = cleanValue.replaceAll("script", "");
            cleanValue = cleanValue.replaceAll("link", "");
            cleanValue = cleanValue.replaceAll("blink", "");
            cleanValue = cleanValue.replaceAll("sytle", "");
            cleanValue = cleanValue.replaceAll("iframe", "");
            cleanValue = cleanValue.replaceAll("frame", "");
            cleanValue = cleanValue.replaceAll("frameset", "");
            cleanValue = cleanValue.replaceAll("title", "");
            cleanValue = cleanValue.replaceAll("meta", "");
            cleanValue = cleanValue.replaceAll("applet", "");
            cleanValue = cleanValue.replaceAll("embed", "");
            cleanValue = cleanValue.replaceAll("object", "");
            cleanValue = cleanValue.replaceAll("ilayer", "");
            cleanValue = cleanValue.replaceAll("layer", "");
            cleanValue = cleanValue.replaceAll("base", "");
            cleanValue = cleanValue.replaceAll("bgsound", "");
            cleanValue = cleanValue.replaceAll("'", "&#39;");
            cleanValue = cleanValue.replaceAll("<", "&lt;");
            cleanValue = cleanValue.replaceAll(">", "&gt;");
        }
        return cleanValue;
    }
}

