/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.mq.rabbit.processor;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.monitor.mq.rabbit.Action;
import kd.bos.monitor.mq.rabbit.ConfigPicker;
import kd.bos.monitor.mq.rabbit.RabbitRestTool;
import kd.bos.monitor.mq.rabbit.RabbitmqAction;
import kd.bos.monitor.mq.rabbit.action.RabbitmqQueuesAction;
import kd.bos.monitor.mq.rabbit.processor.AbstractRabbitmqActionProcessor;

@Action(value=RabbitmqQueuesAction.class)
public class RabbitmqQueuesActionProcessor
extends AbstractRabbitmqActionProcessor {
    private static final String VHOST = "vhost";
    private static final String STATE = "state";
    private static final String ITEM_COUNT = "item_count";
    private static final String TOTAL_COUNT = "total_count";
    private static final String PAGE_COUNT = "page_count";
    private static final String PAGE_SIZE = "page_size";
    private static final String ITEMS = "items";

    @Override
    public String process(RabbitmqAction mqAction) {
        Set<String> serverKeys = this.getServerKeys();
        String result = null;
        if (!serverKeys.isEmpty()) {
            for (String serverKey : serverKeys) {
                String serverInfo = System.getProperty(serverKey);
                if (serverInfo == null) {
                    throw new KDException(BosErrorCode.mqServerConfiguration, new Object[]{"rabbit server not config for " + serverKey});
                }
                ConfigPicker cp = new ConfigPicker();
                try {
                    String host = Objects.requireNonNull(cp.getHost(), "host can't be empty.");
                    String user = Objects.requireNonNull(cp.getUser(), "user can't be empty.");
                    String password = Objects.requireNonNull(cp.getPassword(), "password can't be empty.");
                    int webPort = Integer.parseInt(Objects.requireNonNull(cp.getWebPort(), "web port can't be empty."));
                    String response = RabbitRestTool.getRestfulResult(host, webPort, this.getApi(mqAction), user, password);
                    result = this.buildJson(response);
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, BosErrorCode.rabbitmqConfiguration, new Object[]{e.getMessage()});
                }
            }
        }
        return result;
    }

    private Set<String> getServerKeys() {
        HashSet<String> serverKeys = new HashSet<String>();
        serverKeys.add("mq.server");
        return serverKeys;
    }

    @Override
    String getApi(RabbitmqAction mqAction) {
        String asc;
        RabbitmqQueuesAction action = (RabbitmqQueuesAction)mqAction;
        String api = "/api/queues/" + action.getVhost() + "?page=" + action.getPage() + "&page_size=" + action.getPageSize() + "&name=" + action.getName();
        String string = asc = "asc".equals(action.getAsc()) ? "false" : "true";
        if (!"".equals(action.getSort())) {
            api = api + "&sort=" + action.getSort() + "&sort_reverse=" + asc;
        }
        return api;
    }

    @Override
    String buildJson(String result) {
        result = result.trim();
        boolean isArray = false;
        if (result.startsWith("[")) {
            isArray = true;
        }
        if (isArray) {
            JSONArray itemsArray = JSONObject.parseArray((String)result);
            JSONArray nArray = new JSONArray();
            for (int i = 0; i < itemsArray.size(); ++i) {
                JSONObject queueitem = (JSONObject)itemsArray.get(i);
                String total = queueitem.getString("messages");
                String messages_ready = queueitem.getString("messages_ready");
                String messages_unacknowledged = queueitem.getString("messages_unacknowledged");
                String vhost = queueitem.getString(VHOST);
                String name = queueitem.getString("name");
                String state = queueitem.getString(STATE);
                JSONObject nitem = new JSONObject();
                nitem.put("name", (Object)name);
                nitem.put("total", (Object)total);
                nitem.put("ready", (Object)messages_ready);
                nitem.put("unacknowledged", (Object)messages_unacknowledged);
                nitem.put(VHOST, (Object)vhost);
                nitem.put(STATE, (Object)state);
                nArray.add((Object)nitem);
            }
            JSONObject nobject = new JSONObject();
            nobject.put(ITEM_COUNT, (Object)nArray.size());
            nobject.put(TOTAL_COUNT, (Object)nArray.size());
            nobject.put(PAGE_COUNT, (Object)1);
            nobject.put(PAGE_SIZE, (Object)1);
            nobject.put(ITEMS, (Object)nArray);
            return nobject.toJSONString();
        }
        JSONObject sobject = JSONObject.parseObject((String)result);
        if (sobject.containsKey((Object)"error")) {
            JSONObject nobject = new JSONObject();
            nobject.put(ITEM_COUNT, (Object)0);
            nobject.put(TOTAL_COUNT, (Object)0);
            nobject.put(PAGE_COUNT, (Object)1);
            nobject.put(PAGE_SIZE, (Object)1);
            JSONArray nArray = new JSONArray();
            nobject.put(ITEMS, (Object)nArray);
            return nobject.toJSONString();
        }
        String item_count = sobject.getString(ITEM_COUNT);
        String total_count = sobject.getString(TOTAL_COUNT);
        String page_count = sobject.getString(PAGE_COUNT);
        String page_size = sobject.getString(PAGE_SIZE);
        JSONArray itemsArray = sobject.getJSONArray(ITEMS);
        JSONObject nobject = new JSONObject();
        nobject.put(ITEM_COUNT, (Object)item_count);
        nobject.put(TOTAL_COUNT, (Object)total_count);
        nobject.put(PAGE_COUNT, (Object)page_count);
        nobject.put(PAGE_SIZE, (Object)page_size);
        JSONArray nArray = new JSONArray();
        for (int i = 0; i < itemsArray.size(); ++i) {
            JSONObject queueitem = (JSONObject)itemsArray.get(i);
            String total = queueitem.getString("messages");
            String messages_ready = queueitem.getString("messages_ready");
            String messages_unacknowledged = queueitem.getString("messages_unacknowledged");
            String vhost = queueitem.getString(VHOST);
            String name = queueitem.getString("name");
            String state = queueitem.getString(STATE);
            JSONObject nitem = new JSONObject();
            nitem.put("name", (Object)name);
            nitem.put("total", (Object)total);
            nitem.put("ready", (Object)messages_ready);
            nitem.put("unacknowledged", (Object)messages_unacknowledged);
            nitem.put(VHOST, (Object)vhost);
            nitem.put(STATE, (Object)state);
            nArray.add((Object)nitem);
        }
        nobject.put(ITEMS, (Object)nArray);
        return nobject.toJSONString();
    }
}

