/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.objmem.collector;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.OperationContextCreator;
import kd.bos.monitor.objmem.CollectResult;
import kd.bos.monitor.objmem.CollectTask;
import kd.bos.monitor.objmem.MemInfoCollector;
import kd.bos.monitor.objmem.Meminfo;
import kd.bos.util.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMemInfoCollector
implements MemInfoCollector {
    private static Logger logger = LoggerFactory.getLogger(OSMemInfoCollector.class);

    @Override
    public CollectResult getMemInfo(CollectTask task) {
        OperationContextCreator.getOrCreateForBos();
        int pid = task.getPid();
        ArrayList<Meminfo> list = new ArrayList<Meminfo>(256);
        String params = " -histo";
        params = task.isLive() ? params + ":live " : params + " ";
        try {
            String cmdPath = ConfigurationUtil.getString((String)"JAVA_HOME");
            String cmd = cmdPath.endsWith("/") ? cmdPath + "bin/jmap" + params + pid : cmdPath + "/bin/jmap" + params + pid;
            Process ps = Runtime.getRuntime().exec(cmd);
            try (InputStream is = ps.getInputStream();
                 InputStreamReader isr = new InputStreamReader(is);
                 BufferedReader br = new BufferedReader(isr);){
                this.readData(br, list);
            }
        }
        catch (IOException iex) {
            logger.error("get mem info exception", (Throwable)iex);
        }
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        MemoryUsage headMemory = memory.getHeapMemoryUsage();
        long used = headMemory.getUsed() / 1024L / 1024L;
        long max = headMemory.getMax() / 1024L / 1024L;
        return new CollectResult(max, used, list);
    }

    private void readData(BufferedReader br, List<Meminfo> list) throws IOException {
        String line;
        boolean startinfo = false;
        while ((line = br.readLine()) != null) {
            if (line.indexOf("--------------") >= 0) {
                startinfo = true;
                continue;
            }
            if (!startinfo || line.indexOf("Total") >= 0 && line.indexOf(":") < 0) continue;
            list.add(this.getMemInfo(line));
        }
    }

    private Meminfo getMemInfo(String line) {
        Meminfo info = new Meminfo();
        int index = 1;
        Pattern pattern = Pattern.compile("[\\S]+");
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            if (index == 2) {
                info.setInstances(Integer.parseInt(matcher.group()));
            }
            if (index == 3) {
                info.setBytes(Long.parseLong(matcher.group()));
            }
            if (index == 4) {
                info.setClsName(matcher.group());
            }
            ++index;
        }
        return info;
    }
}

