/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.proxy;

import com.google.common.io.CharStreams;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.OperationContextCreator;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.util.ClassicTo404;
import kd.bos.monitor.util.HttpClients;
import kd.bos.monitor.util.UrlUtils;
import kd.bos.mservice.monitor.ZkManagerService;
import kd.bos.util.MonitorHttpClients;

public class ProxyHandler
extends AbstractHttpHandler {
    private static final Log logger = LogFactory.getLog(ProxyHandler.class);
    public static final String PROXY_HEADER_KEY = Instance.getClusterName() + "MSPTrOoNxEy";
    public static final String PROXY_HEADER_VALUE = Instance.getClusterName() + "NSaAtRaAsShUaNNY";
    public static final String KEY = "proxyurl";
    private boolean appendProxyUrl;
    private static final int READ_TIMEOUT = Integer.parseInt(System.getProperty("monitor.proxy.readtimeout", "120"));

    public ProxyHandler(boolean appendProxyUrl) {
        this.appendProxyUrl = appendProxyUrl;
    }

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        boolean disable = ClassicTo404.redirectTo404(exchange);
        if (disable) {
            return;
        }
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        Map<String, String> params = this.getParams(exchange, true);
        String context = UrlUtils.getHomeUrl(exchange, null);
        try {
            this.process(out, context, params, exchange);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        out.flush();
        this.writeHtml(sw.toString(), exchange);
    }

    protected void process(PrintWriter out, String context, Map<String, String> params, HttpExchange exchange) {
        OperationContextCreator.getOrCreateForBos();
        String url = params.get("url");
        if (url == null || !url.contains("monitor0")) {
            out.println("What do you want to do?");
            return;
        }
        if (this.appendProxyUrl) {
            url = url.contains("?") ? url + "&proxyurl=" + context + "proxy" : url + "?proxyurl=" + context + "proxy";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String method = exchange.getRequestMethod();
        HashMap<String, String> proxyHeader = new HashMap<String, String>();
        proxyHeader.put(PROXY_HEADER_KEY, PROXY_HEADER_VALUE);
        int readTimeout = url.contains("pauseService") ? 5000 : READ_TIMEOUT * 1000 * 3;
        try {
            if ("GET".equalsIgnoreCase(method)) {
                String response = MonitorHttpClients.get((String)url, proxyHeader, (int)5000, (int)readTimeout);
                pw.println(response);
            } else {
                this.printStr(exchange, url, proxyHeader, pw);
            }
        }
        catch (IOException e1) {
            if (url.contains("pauseService")) {
                try {
                    ZkManagerService.doUnRegisterRpc();
                    ZkManagerService.doUnRegisterMonitor((String)new URL(url).getHost());
                    pw.println("The target server is invoker error,and force pause server success!");
                }
                catch (Exception e2) {
                    pw.println("force Pause server exception:" + e2.getMessage());
                }
            } else {
                pw.println("monitor proxy exception:" + e1.getMessage());
            }
        }
        catch (Exception e) {
            pw.println("monitor proxy exception:" + e.getMessage());
        }
        pw.flush();
        out.println(sw.toString());
    }

    private void printStr(HttpExchange exchange, String url, HashMap<String, String> proxyHeader, PrintWriter pw) {
        Headers headers = exchange.getRequestHeaders();
        HashMap map = new HashMap();
        for (Map.Entry entry : headers.entrySet()) {
            List lv = (List)entry.getValue();
            if (lv == null) continue;
            map.put(entry.getKey(), lv.get(0));
        }
        try {
            InputStream in = exchange.getRequestBody();
            String text = CharStreams.toString((Readable)new InputStreamReader(in, "UTF-8"));
            String response = HttpClients.postjson(url, proxyHeader, text, 30000, READ_TIMEOUT * 1000 * 3);
            response = this.cleanXSSResponse(response);
            pw.println(response);
        }
        catch (Exception e) {
            logger.error("monitor proxy exception", (Throwable)e);
        }
    }
}

