/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.redis;

import com.alibaba.fastjson.JSON;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.util.ClassicTo404;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.util.resource.Resources;
import redis.clients.jedis.util.Slowlog;

public class RedisMrgHandler
extends AbstractHttpHandler
implements Serializable {
    private static final long serialVersionUID = -1L;
    private static String DEFAULT_HIGHTLIGHT_KEYS = "connected_clients,used_memory_human,rejected_connections";
    private static final String[] HIGHLIGHT_KEYS = System.getProperty("monitor.redis.highlightkeys", DEFAULT_HIGHTLIGHT_KEYS).split(",");
    private SlowLogComparator comparator = new SlowLogComparator();
    private static final String CENTER_H1 = "<center><h1>";
    private static final String H1_CENTER = "</h1></center>";
    private static final String TD_TD = "</td><td>";

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        boolean disable = ClassicTo404.redirectTo404(exchange);
        if (disable) {
            return;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Map<String, String> params = this.getParams(exchange, true);
        String searchkey = params.get("key");
        String redisserver = params.get("server");
        Set<String> redisEndpoints = this.getRedisUrls();
        if (!redisEndpoints.isEmpty()) {
            for (String s : redisEndpoints) {
                JedisClient client = RedisFactory.getJedisClient((String)s);
                Throwable throwable = null;
                try {
                    String title = "Redis:" + s + " runtime info";
                    pw.println("<title>" + title + "</title>");
                    pw.println(CENTER_H1 + title + H1_CENTER);
                    this.printDiv(pw, searchkey, redisserver, s, client);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (client == null) continue;
                    if (throwable != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    client.close();
                }
            }
        } else {
            pw.println(CENTER_H1 + Resources.getString((String)"\u6ca1\u6709\u914d\u7f6e\u76d1\u63a7", (String)"RedisMrgHandler_2", (String)"bos-monitor", (Object[])new Object[0]) + "redis, monitor.redis " + Resources.getString((String)"\u4e3a\u7a7a", (String)"RedisMrgHandler_3", (String)"bos-monitor", (Object[])new Object[0]) + H1_CENTER);
        }
        pw.flush();
        String str = sw.toString();
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private void printDiv(PrintWriter pw, String searchkey, String redisserver, String s, JedisClient client) {
        pw.println("<div width='100%'>");
        pw.println("<form action='redis'>");
        pw.println("get key value");
        pw.print("<br/>");
        pw.println("key: <input type='text' name='key' value='" + (searchkey != null ? searchkey : "") + "' style='width:300'/>");
        pw.println("<input type='hidden' name='server' value='" + s + "'/>");
        if (s.equals(redisserver) && searchkey != null && searchkey.length() > 0) {
            String keytype = client.type(searchkey);
            pw.print("<br/>");
            pw.println(Resources.getString((String)"\u6570\u636e\u7c7b\u578b:", (String)"RedisMrgHandler_0", (String)"bos-monitor", (Object[])new Object[0]) + keytype);
            pw.print("<br/>");
            if ("string".equals(keytype)) {
                String value = client.get(searchkey);
                pw.println("value:" + value);
                pw.print("<br/>");
            } else if ("hash".equals(keytype)) {
                Map datamap = client.hgetAll(searchkey);
                for (Map.Entry entry : datamap.entrySet()) {
                    String k = (String)entry.getKey();
                    pw.println("<font color='blue'>key</font>:" + k + " <font color='blue'>value</font>:" + (String)entry.getValue());
                    pw.print("<br/>");
                }
            } else {
                pw.println(Resources.getString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u8be2", (String)"RedisMrgHandler_1", (String)"bos-monitor", (Object[])new Object[0]));
                pw.print("<br/>");
            }
        }
        pw.println("<input type='submit'>");
        pw.println("</form>");
        pw.println("<table border=1 width='100%'>");
        pw.println("<tr><th width='30%'>key</th><th width='70%'>value</th></tr>");
        List infos = client.getRedisInfo();
        if (infos != null) {
            for (Map map : infos) {
                Set set = map.entrySet();
                for (Map.Entry entry : set) {
                    this.renderRow(pw, (String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        pw.println("</table>");
        pw.println("<center><h1>top 20 slowlog</h1></center>");
        List logs = client.getLogs(20L);
        pw.println("<table border=1 width='100%'>");
        pw.println("<tr><th width='70%'>log</th><th width='15%'>time</th><th width='15%'>cost time</th></tr>");
        if (logs != null) {
            Collections.sort(logs, this.comparator);
            for (Slowlog slowlog : logs) {
                pw.println("<tr><td>" + JSON.toJSONString((Object)slowlog.getArgs()) + TD_TD + this.getDateStr(slowlog.getTimeStamp() * 1000L) + TD_TD + slowlog.getExecutionTime() / 1000L + "ms </td></tr>");
            }
        }
        pw.println("</table>");
        pw.println("</div>");
        pw.println("<br/><br/>");
    }

    private Set<String> getRedisUrls() {
        HashSet<String> Urls = new HashSet<String>();
        try {
            Class<?> redisfactorycl = Class.forName("kd.bos.redis.RedisFactory");
            Field filed = redisfactorycl.getDeclaredField("poolMap");
            filed.setAccessible(true);
            Map poolmap = (Map)filed.get(redisfactorycl);
            poolmap.forEach((k, v) -> Urls.add((String)k));
        }
        catch (Exception e) {
            return Urls;
        }
        return Urls;
    }

    private String getDateStr(long timeStmp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(new Date(timeStmp));
    }

    private void renderRow(PrintWriter pw, String key, String value) {
        key = key.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        value = value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        if ("NODENAME".endsWith(key)) {
            pw.println("<tr><th style='border:none' align='left'>CLUSTER NODE:  " + value + "</th></tr>");
        } else if (this.highlight(key)) {
            pw.println("<tr><td><span style='color:blue'>" + key + "</span></td><td><span style='color:blue'>" + value + "</span></td></tr>");
        } else {
            pw.println("<tr><td>" + key + TD_TD + value + "</td></tr>");
        }
    }

    private boolean highlight(String key) {
        for (String hkey : HIGHLIGHT_KEYS) {
            if (key.equals(hkey)) {
                return true;
            }
            if (!key.startsWith("db")) continue;
            return true;
        }
        return false;
    }

    private static class SlowLogComparator
    implements Comparator<Slowlog> {
        private SlowLogComparator() {
        }

        @Override
        public int compare(Slowlog o1, Slowlog o2) {
            if (o1.getExecutionTime() > o2.getExecutionTime()) {
                return -1;
            }
            if (o1.getExecutionTime() == o2.getExecutionTime()) {
                return 0;
            }
            return 1;
        }
    }
}

