/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.service;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.bundle.Resources;
import kd.bos.context.OperationContextCreator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.home.NodeInfo;
import kd.bos.monitor.httpserver.InnerHandler;
import kd.bos.monitor.proxy.ProxyHandler;
import kd.bos.monitor.service.ClusterNodeUtils;
import kd.bos.monitor.service.simulation.Simulate;
import kd.bos.monitor.service.simulation.SimulationFactory;
import kd.bos.monitor.util.ClassicTo404;
import kd.bos.monitor.util.HttpClients;
import kd.bos.monitor.util.UrlUtils;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterHealth;
import kd.bos.mservice.monitor.healthmanage.indicator.IndicatorValInfo;
import kd.bos.mservice.monitor.healthmanage.inspect.IndicatorsInspect;

public class ClusterNodeHealthHandler
extends InnerHandler {
    public static final String PROXY_HEADER_KEY = ProxyHandler.PROXY_HEADER_KEY;
    public static final String PROXY_HEADER_VALUE = ProxyHandler.PROXY_HEADER_VALUE;
    private static int readtimeout = 60;
    private static final Log logger = LogFactory.getLog(ClusterNodeHealthHandler.class);
    private static final String TARGET_BLANK = "' target='_blank'>";
    private static final String SPAN_HREF = " <span><a href='";
    private static final String A_SPAN = "</a></span> ";
    private static final String UTF8 = "UTF-8";

    public ClusterNodeHealthHandler(String context) {
        super(context);
    }

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        boolean disable = ClassicTo404.redirectTo404(exchange);
        if (disable) {
            return;
        }
        String urlHost = UrlUtils.getHomeUrl(exchange, null);
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        OperationContextCreator.getOrCreateForBos();
        HashMap<String, String> proxyHeader = new HashMap<String, String>();
        proxyHeader.put(PROXY_HEADER_KEY, PROXY_HEADER_VALUE);
        String handlerUrl = super.getInnerHandlerUrl();
        String homeUrl = UrlUtils.getHomeUrl(exchange, handlerUrl);
        handlerUrl = homeUrl + "nodehealth";
        try {
            Map appHealths = ClusterHealth.getClusterApplicationHealth();
            out.append("<h1>").append(Resources.get((String)"bos-monitor", (String)"ClusterNodeHealthHandler_8", (String)"\u5e94\u7528\u9ad8\u53ef\u7528", (Object[])new Object[0])).append("</h1>");
            out.append("<table border=\"1\" cellpadding=\"5\"> <tr><th>\u5e94\u7528\u540d\u79f0</th><th>\u5065\u5eb7</th><th>\u7e41\u5fd9</th><th>\u8fc7\u8f7d</th><th>\u9519\u8bef</th><th>\u603b\u8ba1</th></tr>");
            appHealths.forEach((appname, levelMap) -> {
                out.append("<tr>");
                out.append("<td> ").append((CharSequence)appname).append(" </td><td> ");
                AtomicInteger normal = (AtomicInteger)levelMap.get(HealthLevel.NORMAL.getLevel());
                int normalInt = normal == null ? 0 : normal.get();
                out.append(" " + normalInt).append(" </td><td> ");
                AtomicInteger busy = (AtomicInteger)levelMap.get(HealthLevel.BUSY.getLevel());
                int busyInt = busy == null ? 0 : busy.get();
                out.append(" " + busyInt).append(" </td><td> ");
                AtomicInteger overload = (AtomicInteger)levelMap.get(HealthLevel.OVERLOAD.getLevel());
                int overloadInt = overload == null ? 0 : overload.get();
                out.append(" " + overloadInt).append(" </td><td> ");
                AtomicInteger error = (AtomicInteger)levelMap.get(HealthLevel.ERROR.getLevel());
                int errorInt = error == null ? 0 : error.get();
                out.append(" " + errorInt).append(" </td> <td>");
                out.append(" " + (normalInt + busyInt + overloadInt + errorInt)).append(" </td> ");
            });
            out.append("</table>");
            String str = sw.toString();
            byte[] bytes = str.getBytes(UTF8);
            exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
            exchange.sendResponseHeaders(202, bytes.length);
            exchange.getResponseBody().write(bytes);
            ArrayList<NodeInfo> serverNodes = ClusterNodeUtils.getSortedNodeInfos();
            List ips = serverNodes.stream().map(node -> node.getMonitorUrl(false) + "/monitor0/nodehealth?proxyurl=/monitor/proxy").collect(Collectors.toList());
            for (String ip : ips) {
                PrintWriter nodePw;
                StringWriter nodeSw;
                block10: {
                    nodeSw = new StringWriter();
                    nodePw = new PrintWriter(nodeSw);
                    String response = "";
                    try {
                        response = HttpClients.get(ip, proxyHeader, 5000, readtimeout * 1000);
                        nodePw.println(response);
                        boolean isDebug = Boolean.getBoolean("node.malfunction.simulation.enable");
                        if (!isDebug) break block10;
                        HashMap<String, String> params = new HashMap<String, String>(1);
                        nodePw.append("<table>");
                        String simlulateStr = Resources.get((String)"bos-monitor", (String)"ClusterNodeHealthHandler_4", (String)"\u6545\u969c\u6a21\u62df", (Object[])new Object[0]);
                        String simlulateRestoreStr = Resources.get((String)"bos-monitor", (String)"ClusterNodeHealthHandler_5", (String)"\u6545\u969c\u6062\u590d", (Object[])new Object[0]);
                        for (IndicatorValInfo indicator : IndicatorsInspect.getAllHelathIndicators()) {
                            String name = indicator.getName();
                            try {
                                Simulate simulate = SimulationFactory.getSimulate(name);
                                if (simulate == null) {
                                }
                            }
                            catch (Exception e) {}
                            continue;
                            params.put("simulationtype", name);
                            nodePw.append("<tr><td>");
                            nodePw.append("&nbsp;&nbsp;").append(SPAN_HREF).append(this.createRef(urlHost, ip, params)).append(TARGET_BLANK).append(name + simlulateStr).append(A_SPAN);
                            nodePw.append("</td><td>");
                            nodePw.append("&nbsp;&nbsp;&nbsp;&nbsp;").append(SPAN_HREF).append(this.createRefRecorver(urlHost, ip, params)).append(TARGET_BLANK).append(name + simlulateRestoreStr + "<br>").append(A_SPAN);
                            nodePw.append("</td></tr>");
                        }
                        nodePw.append("<table>");
                    }
                    catch (Exception e) {
                        response = this.outPrintlnException(ip);
                        nodePw.println(response);
                    }
                }
                String nodeStr = nodeSw.toString();
                byte[] nodeBytes = nodeStr.getBytes(UTF8);
                exchange.getResponseBody().write(nodeBytes);
                exchange.getResponseBody().flush();
                nodePw.close();
                nodeSw.close();
            }
        }
        catch (Exception e1) {
            logger.error("cluster nodehealth exception", (Throwable)e1);
        }
        out.close();
        sw.close();
        exchange.close();
    }

    private String createRefRecorver(String urlHost, String ip, Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        sb.append(ip);
        params.forEach((k, v) -> sb.append("&").append((String)k).append("=").append((String)v));
        sb.append("&recover=true");
        try {
            return urlHost + "proxy?url=" + URLEncoder.encode(sb.toString(), UTF8);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UnsupportedEncodingException", (Throwable)e);
            return "";
        }
    }

    private String createRef(String urlHost, String ip, Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        sb.append(ip);
        params.forEach((k, v) -> sb.append("&").append((String)k).append("=").append((String)v));
        try {
            return urlHost + "proxy?url=" + URLEncoder.encode(sb.toString(), UTF8);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UnsupportedEncodingException", (Throwable)e);
            return "";
        }
    }

    private String outPrintlnException(String ip) {
        String title = Resources.get((String)"bos-monitor", (String)"ClusterNodeHealthHandler_3", (String)"\u8282\u70b9\u5806\u6808\u8bf7\u6c42\u5f02\u5e38", (Object[])new Object[0]) + ":" + ip;
        String ret = "<center><h1>" + title + "</h1></center>&nbsp;";
        return ret;
    }

    static {
        readtimeout = Integer.parseInt(System.getProperty("monitor.proxy.readtimeout", "60"));
    }
}

